/*
 * Decompiled with CFR 0.152.
 */
package AM.arenaMaker;

import AM.arenaMaker.arena.ArenaManager;
import AM.arenaMaker.cmd.ArenaCmd;
import AM.arenaMaker.cmd.DuelCmd;
import AM.arenaMaker.cmd.GameCmd;
import AM.arenaMaker.cmd.KitCmd;
import AM.arenaMaker.cmd.MakerMode;
import AM.arenaMaker.data.StatsManager;
import AM.arenaMaker.duel.DuelManager;
import AM.arenaMaker.game.GameManager;
import AM.arenaMaker.gui.AdminGUI;
import AM.arenaMaker.gui.MenuManager;
import AM.arenaMaker.gui.ShopGUI;
import AM.arenaMaker.hook.PAPIHook;
import AM.arenaMaker.hook.VaultHook;
import AM.arenaMaker.hook.WEHook;
import AM.arenaMaker.hook.WGHook;
import AM.arenaMaker.kit.KitManager;
import AM.arenaMaker.listener.DuelListener;
import AM.arenaMaker.listener.GameListener;
import AM.arenaMaker.queue.QueueManager;
import AM.arenaMaker.reward.RewardManager;
import AM.arenaMaker.shop.ShopManager;
import AM.arenaMaker.sign.SignManager;
import AM.arenaMaker.util.Visualizer;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.TabCompleter;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public final class ArenaMaker
extends JavaPlugin {
    private static ArenaMaker instance;
    private WEHook weHook;
    private WGHook wgHook;
    private VaultHook vaultHook;
    private ArenaManager arenaManager;
    private KitManager kitManager;
    private RewardManager rewardManager;
    private StatsManager statsManager;
    private DuelManager duelManager;
    private QueueManager queueManager;
    private SignManager signManager;
    private MenuManager menuManager;
    private MakerMode makerMode;
    private GameManager gameManager;
    private ShopManager shopManager;
    private ShopGUI shopGUI;
    private AdminGUI adminGUI;
    private Visualizer visualizer;

    public void onEnable() {
        instance = this;
        this.saveDefaultConfig();
        this.weHook = new WEHook();
        this.wgHook = new WGHook();
        this.vaultHook = new VaultHook();
        this.arenaManager = new ArenaManager(this);
        this.kitManager = new KitManager(this);
        this.rewardManager = new RewardManager(this);
        this.statsManager = new StatsManager(this);
        this.shopManager = new ShopManager(this);
        this.duelManager = new DuelManager(this);
        this.queueManager = new QueueManager(this);
        this.gameManager = new GameManager(this);
        this.signManager = new SignManager(this);
        this.menuManager = new MenuManager(this);
        this.shopGUI = new ShopGUI(this);
        this.adminGUI = new AdminGUI(this);
        this.visualizer = new Visualizer((Plugin)this);
        this.makerMode = new MakerMode(this);
        this.getServer().getPluginManager().registerEvents((Listener)new DuelListener(this), (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)new GameListener(this), (Plugin)this);
        ArenaCmd arenaCmd = new ArenaCmd(this);
        this.getCommand("arena").setExecutor((CommandExecutor)arenaCmd);
        this.getCommand("arena").setTabCompleter((TabCompleter)arenaCmd);
        DuelCmd duelCmd = new DuelCmd(this);
        this.getCommand("duel").setExecutor((CommandExecutor)duelCmd);
        this.getCommand("duel").setTabCompleter((TabCompleter)duelCmd);
        KitCmd kitCmd = new KitCmd(this);
        this.getCommand("kit").setExecutor((CommandExecutor)kitCmd);
        this.getCommand("kit").setTabCompleter((TabCompleter)kitCmd);
        GameCmd gameCmd = new GameCmd(this);
        this.getCommand("game").setExecutor((CommandExecutor)gameCmd);
        this.getCommand("game").setTabCompleter((TabCompleter)gameCmd);
        if (Bukkit.getPluginManager().isPluginEnabled("PlaceholderAPI")) {
            new PAPIHook(this).register();
            this.getLogger().info("PlaceholderAPI hooked");
        }
        this.getLogger().info("ArenaMaker enabled");
        this.getLogger().info("Loaded: " + this.arenaManager.count() + " arenas, " + this.kitManager.count() + " kits");
        if (!this.weHook.isEnabled()) {
            this.getLogger().warning("WorldEdit not found");
        }
        if (!this.wgHook.isEnabled()) {
            this.getLogger().warning("WorldGuard not found");
        }
        if (!this.vaultHook.isEnabled()) {
            this.getLogger().warning("Vault not found - economy disabled");
        }
    }

    public void onDisable() {
        if (this.arenaManager != null) {
            this.arenaManager.save();
        }
        if (this.statsManager != null) {
            this.statsManager.save();
        }
        if (this.kitManager != null) {
            this.kitManager.save();
        }
        if (this.signManager != null) {
            this.signManager.save();
        }
        if (this.shopManager != null) {
            this.shopManager.save();
        }
    }

    public static ArenaMaker getInstance() {
        return instance;
    }

    public ArenaManager getArenaManager() {
        return this.arenaManager;
    }

    public KitManager getKitManager() {
        return this.kitManager;
    }

    public RewardManager getRewardManager() {
        return this.rewardManager;
    }

    public StatsManager getStatsManager() {
        return this.statsManager;
    }

    public DuelManager getDuelManager() {
        return this.duelManager;
    }

    public QueueManager getQueueManager() {
        return this.queueManager;
    }

    public SignManager getSignManager() {
        return this.signManager;
    }

    public MenuManager getMenuManager() {
        return this.menuManager;
    }

    public MakerMode getMakerMode() {
        return this.makerMode;
    }

    public GameManager getGameManager() {
        return this.gameManager;
    }

    public ShopManager getShopManager() {
        return this.shopManager;
    }

    public ShopGUI getShopGUI() {
        return this.shopGUI;
    }

    public AdminGUI getAdminGUI() {
        return this.adminGUI;
    }

    public WEHook getWEHook() {
        return this.weHook;
    }

    public WGHook getWGHook() {
        return this.wgHook;
    }

    public VaultHook getVaultHook() {
        return this.vaultHook;
    }

    public Visualizer getVisualizer() {
        return this.visualizer;
    }
}

