/*
 * Decompiled with CFR 0.152.
 */
package AM.arenaMaker.arena;

import AM.arenaMaker.arena.Preset;
import AM.arenaMaker.game.GameMode;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.configuration.ConfigurationSection;

public class Arena {
    private final String id;
    private String name;
    private Location pos1;
    private Location pos2;
    private Location spawn1;
    private Location spawn2;
    private Location lobby;
    private Preset preset;
    private boolean enabled;
    private String regionId;
    private GameMode gameMode;
    private List<Location> mobSpawns;
    private String shopId;
    private int maxPlayers;
    private int minPlayers;

    public Arena(String id) {
        this.id = id;
        this.name = id;
        this.preset = Preset.CUSTOM;
        this.enabled = false;
        this.gameMode = GameMode.DUEL;
        this.mobSpawns = new ArrayList<Location>();
        this.maxPlayers = 2;
        this.minPlayers = 2;
    }

    public String getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Location getPos1() {
        return this.pos1;
    }

    public void setPos1(Location pos1) {
        this.pos1 = pos1;
    }

    public Location getPos2() {
        return this.pos2;
    }

    public void setPos2(Location pos2) {
        this.pos2 = pos2;
    }

    public Location getSpawn1() {
        return this.spawn1;
    }

    public void setSpawn1(Location spawn1) {
        this.spawn1 = spawn1;
    }

    public Location getSpawn2() {
        return this.spawn2;
    }

    public void setSpawn2(Location spawn2) {
        this.spawn2 = spawn2;
    }

    public Location getLobby() {
        return this.lobby;
    }

    public void setLobby(Location lobby) {
        this.lobby = lobby;
    }

    public Preset getPreset() {
        return this.preset;
    }

    public void setPreset(Preset preset) {
        this.preset = preset;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public String getRegionId() {
        return this.regionId;
    }

    public void setRegionId(String regionId) {
        this.regionId = regionId;
    }

    public GameMode getGameMode() {
        return this.gameMode;
    }

    public void setGameMode(GameMode gameMode) {
        this.gameMode = gameMode;
        this.minPlayers = gameMode.getMinPlayers();
        this.maxPlayers = gameMode.getMaxPlayers();
    }

    public List<Location> getMobSpawns() {
        return this.mobSpawns;
    }

    public void addMobSpawn(Location loc) {
        this.mobSpawns.add(loc);
    }

    public void clearMobSpawns() {
        this.mobSpawns.clear();
    }

    public String getShopId() {
        return this.shopId;
    }

    public void setShopId(String shopId) {
        this.shopId = shopId;
    }

    public int getMaxPlayers() {
        return this.maxPlayers;
    }

    public void setMaxPlayers(int maxPlayers) {
        this.maxPlayers = maxPlayers;
    }

    public int getMinPlayers() {
        return this.minPlayers;
    }

    public void setMinPlayers(int minPlayers) {
        this.minPlayers = minPlayers;
    }

    public boolean isComplete() {
        return this.pos1 != null && this.pos2 != null && this.spawn1 != null && this.spawn2 != null;
    }

    public Location getCenter() {
        if (this.pos1 == null || this.pos2 == null) {
            return null;
        }
        return new Location(this.pos1.getWorld(), (this.pos1.getX() + this.pos2.getX()) / 2.0, (this.pos1.getY() + this.pos2.getY()) / 2.0, (this.pos1.getZ() + this.pos2.getZ()) / 2.0);
    }

    public void save(ConfigurationSection section) {
        section.set("name", (Object)this.name);
        section.set("preset", (Object)this.preset.name());
        section.set("enabled", (Object)this.enabled);
        section.set("region", (Object)this.regionId);
        section.set("mode", (Object)this.gameMode.name());
        section.set("shop", (Object)this.shopId);
        section.set("max-players", (Object)this.maxPlayers);
        section.set("min-players", (Object)this.minPlayers);
        this.saveLoc(section, "pos1", this.pos1);
        this.saveLoc(section, "pos2", this.pos2);
        this.saveLoc(section, "spawn1", this.spawn1);
        this.saveLoc(section, "spawn2", this.spawn2);
        this.saveLoc(section, "lobby", this.lobby);
        ArrayList<String> spawnList = new ArrayList<String>();
        for (Location loc : this.mobSpawns) {
            spawnList.add(this.locToString(loc));
        }
        section.set("mob-spawns", spawnList);
    }

    public static Arena load(String id, ConfigurationSection section) {
        Arena arena = new Arena(id);
        arena.name = section.getString("name", id);
        arena.preset = Preset.fromName(section.getString("preset", "CUSTOM"));
        arena.enabled = section.getBoolean("enabled", false);
        arena.regionId = section.getString("region");
        arena.gameMode = GameMode.fromName(section.getString("mode", "DUEL"));
        arena.shopId = section.getString("shop");
        arena.maxPlayers = section.getInt("max-players", arena.gameMode.getMaxPlayers());
        arena.minPlayers = section.getInt("min-players", arena.gameMode.getMinPlayers());
        arena.pos1 = Arena.loadLoc(section, "pos1");
        arena.pos2 = Arena.loadLoc(section, "pos2");
        arena.spawn1 = Arena.loadLoc(section, "spawn1");
        arena.spawn2 = Arena.loadLoc(section, "spawn2");
        arena.lobby = Arena.loadLoc(section, "lobby");
        List spawnList = section.getStringList("mob-spawns");
        for (String str : spawnList) {
            Location loc = Arena.stringToLoc(str);
            if (loc == null) continue;
            arena.mobSpawns.add(loc);
        }
        return arena;
    }

    private void saveLoc(ConfigurationSection section, String key, Location loc) {
        if (loc == null) {
            return;
        }
        section.set(key + ".world", (Object)loc.getWorld().getName());
        section.set(key + ".x", (Object)loc.getX());
        section.set(key + ".y", (Object)loc.getY());
        section.set(key + ".z", (Object)loc.getZ());
        section.set(key + ".yaw", (Object)Float.valueOf(loc.getYaw()));
        section.set(key + ".pitch", (Object)Float.valueOf(loc.getPitch()));
    }

    private static Location loadLoc(ConfigurationSection section, String key) {
        if (!section.contains(key + ".world")) {
            return null;
        }
        World world = Bukkit.getWorld((String)section.getString(key + ".world"));
        if (world == null) {
            return null;
        }
        return new Location(world, section.getDouble(key + ".x"), section.getDouble(key + ".y"), section.getDouble(key + ".z"), (float)section.getDouble(key + ".yaw"), (float)section.getDouble(key + ".pitch"));
    }

    private String locToString(Location loc) {
        return loc.getWorld().getName() + "," + loc.getX() + "," + loc.getY() + "," + loc.getZ();
    }

    private static Location stringToLoc(String str) {
        String[] parts = str.split(",");
        if (parts.length < 4) {
            return null;
        }
        World world = Bukkit.getWorld((String)parts[0]);
        if (world == null) {
            return null;
        }
        return new Location(world, Double.parseDouble(parts[1]), Double.parseDouble(parts[2]), Double.parseDouble(parts[3]));
    }
}

