/*
 * Decompiled with CFR 0.152.
 */
package AM.arenaMaker.arena;

import AM.arenaMaker.ArenaMaker;
import AM.arenaMaker.arena.Arena;
import AM.arenaMaker.hook.WGHook;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;

public class ArenaManager {
    private final ArenaMaker plugin;
    private final Map<String, Arena> arenas;
    private final File file;
    private FileConfiguration data;

    public ArenaManager(ArenaMaker plugin) {
        this.plugin = plugin;
        this.arenas = new HashMap<String, Arena>();
        this.file = new File(plugin.getDataFolder(), "arenas.yml");
        this.load();
    }

    public Arena create(String id) {
        if (this.arenas.containsKey(id.toLowerCase())) {
            return null;
        }
        Arena arena = new Arena(id.toLowerCase());
        this.arenas.put(id.toLowerCase(), arena);
        this.save();
        return arena;
    }

    public Arena get(String id) {
        return this.arenas.get(id.toLowerCase());
    }

    public boolean exists(String id) {
        return this.arenas.containsKey(id.toLowerCase());
    }

    public boolean delete(String id) {
        Arena arena = this.arenas.remove(id.toLowerCase());
        if (arena == null) {
            return false;
        }
        WGHook wg = this.plugin.getWGHook();
        if (wg.isEnabled() && arena.getRegionId() != null && arena.getPos1() != null) {
            wg.removeRegion(arena.getRegionId(), arena.getPos1().getWorld());
        }
        this.save();
        return true;
    }

    public Collection<Arena> getAll() {
        return this.arenas.values();
    }

    public int count() {
        return this.arenas.size();
    }

    public void load() {
        this.arenas.clear();
        if (!this.file.exists()) {
            this.data = new YamlConfiguration();
            return;
        }
        this.data = YamlConfiguration.loadConfiguration((File)this.file);
        ConfigurationSection section = this.data.getConfigurationSection("arenas");
        if (section == null) {
            return;
        }
        for (String key : section.getKeys(false)) {
            ConfigurationSection arenaSection = section.getConfigurationSection(key);
            if (arenaSection == null) continue;
            Arena arena = Arena.load(key, arenaSection);
            this.arenas.put(key.toLowerCase(), arena);
        }
    }

    public void save() {
        this.data = new YamlConfiguration();
        for (Arena arena : this.arenas.values()) {
            ConfigurationSection section = this.data.createSection("arenas." + arena.getId());
            arena.save(section);
        }
        try {
            this.data.save(this.file);
        }
        catch (IOException e) {
            this.plugin.getLogger().severe("Failed to save arenas: " + e.getMessage());
        }
    }
}

