/*
 * Decompiled with CFR 0.152.
 */
package AM.arenaMaker.arena;

import org.bukkit.configuration.ConfigurationSection;

public class ArenaRules {
    private boolean pvpEnabled = true;
    private boolean hungerEnabled = false;
    private boolean fallDamage = true;
    private boolean regenEnabled = true;
    private boolean keepInventory = true;
    private boolean allowFlight = false;
    private boolean allowPearls = true;
    private boolean allowPotions = true;
    private boolean allowBows = true;
    private int maxDuration = 300;
    private double minWager = 0.0;
    private double maxWager = 10000.0;
    private String defaultKit = "pvp";
    private String winReward = "win";

    public boolean isPvpEnabled() {
        return this.pvpEnabled;
    }

    public void setPvpEnabled(boolean pvpEnabled) {
        this.pvpEnabled = pvpEnabled;
    }

    public boolean isHungerEnabled() {
        return this.hungerEnabled;
    }

    public void setHungerEnabled(boolean hungerEnabled) {
        this.hungerEnabled = hungerEnabled;
    }

    public boolean isFallDamage() {
        return this.fallDamage;
    }

    public void setFallDamage(boolean fallDamage) {
        this.fallDamage = fallDamage;
    }

    public boolean isRegenEnabled() {
        return this.regenEnabled;
    }

    public void setRegenEnabled(boolean regenEnabled) {
        this.regenEnabled = regenEnabled;
    }

    public boolean isKeepInventory() {
        return this.keepInventory;
    }

    public void setKeepInventory(boolean keepInventory) {
        this.keepInventory = keepInventory;
    }

    public boolean isAllowFlight() {
        return this.allowFlight;
    }

    public void setAllowFlight(boolean allowFlight) {
        this.allowFlight = allowFlight;
    }

    public boolean isAllowPearls() {
        return this.allowPearls;
    }

    public void setAllowPearls(boolean allowPearls) {
        this.allowPearls = allowPearls;
    }

    public boolean isAllowPotions() {
        return this.allowPotions;
    }

    public void setAllowPotions(boolean allowPotions) {
        this.allowPotions = allowPotions;
    }

    public boolean isAllowBows() {
        return this.allowBows;
    }

    public void setAllowBows(boolean allowBows) {
        this.allowBows = allowBows;
    }

    public int getMaxDuration() {
        return this.maxDuration;
    }

    public void setMaxDuration(int maxDuration) {
        this.maxDuration = maxDuration;
    }

    public double getMinWager() {
        return this.minWager;
    }

    public void setMinWager(double minWager) {
        this.minWager = minWager;
    }

    public double getMaxWager() {
        return this.maxWager;
    }

    public void setMaxWager(double maxWager) {
        this.maxWager = maxWager;
    }

    public String getDefaultKit() {
        return this.defaultKit;
    }

    public void setDefaultKit(String defaultKit) {
        this.defaultKit = defaultKit;
    }

    public String getWinReward() {
        return this.winReward;
    }

    public void setWinReward(String winReward) {
        this.winReward = winReward;
    }

    public void save(ConfigurationSection section) {
        section.set("pvp", (Object)this.pvpEnabled);
        section.set("hunger", (Object)this.hungerEnabled);
        section.set("fall-damage", (Object)this.fallDamage);
        section.set("regen", (Object)this.regenEnabled);
        section.set("keep-inventory", (Object)this.keepInventory);
        section.set("flight", (Object)this.allowFlight);
        section.set("pearls", (Object)this.allowPearls);
        section.set("potions", (Object)this.allowPotions);
        section.set("bows", (Object)this.allowBows);
        section.set("max-duration", (Object)this.maxDuration);
        section.set("min-wager", (Object)this.minWager);
        section.set("max-wager", (Object)this.maxWager);
        section.set("default-kit", (Object)this.defaultKit);
        section.set("win-reward", (Object)this.winReward);
    }

    public static ArenaRules load(ConfigurationSection section) {
        ArenaRules rules = new ArenaRules();
        rules.pvpEnabled = section.getBoolean("pvp", true);
        rules.hungerEnabled = section.getBoolean("hunger", false);
        rules.fallDamage = section.getBoolean("fall-damage", true);
        rules.regenEnabled = section.getBoolean("regen", true);
        rules.keepInventory = section.getBoolean("keep-inventory", true);
        rules.allowFlight = section.getBoolean("flight", false);
        rules.allowPearls = section.getBoolean("pearls", true);
        rules.allowPotions = section.getBoolean("potions", true);
        rules.allowBows = section.getBoolean("bows", true);
        rules.maxDuration = section.getInt("max-duration", 300);
        rules.minWager = section.getDouble("min-wager", 0.0);
        rules.maxWager = section.getDouble("max-wager", 10000.0);
        rules.defaultKit = section.getString("default-kit", "pvp");
        rules.winReward = section.getString("win-reward", "win");
        return rules;
    }
}

