/*
 * Decompiled with CFR 0.152.
 */
package AM.arenaMaker.cmd;

import AM.arenaMaker.ArenaMaker;
import AM.arenaMaker.arena.Arena;
import AM.arenaMaker.arena.Preset;
import AM.arenaMaker.game.GameMode;
import AM.arenaMaker.hook.WEHook;
import AM.arenaMaker.hook.WGHook;
import AM.arenaMaker.util.Msg;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.bukkit.Location;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabCompleter;
import org.bukkit.entity.Player;

public class ArenaCmd
implements CommandExecutor,
TabCompleter {
    private final ArenaMaker plugin;

    public ArenaCmd(ArenaMaker plugin) {
        this.plugin = plugin;
    }

    public boolean onCommand(CommandSender sender, Command cmd, String label, String[] args) {
        String sub;
        if (!(sender instanceof Player)) {
            Msg.error(sender, "Only players can use this.");
            return true;
        }
        Player player = (Player)sender;
        if (args.length == 0) {
            this.showHelp(player);
            return true;
        }
        switch (sub = args[0].toLowerCase()) {
            case "create": {
                this.handleCreate(player, args);
                break;
            }
            case "delete": {
                this.handleDelete(player, args);
                break;
            }
            case "setpos": {
                this.handleSetPos(player, args);
                break;
            }
            case "setspawn": {
                this.handleSetSpawn(player, args);
                break;
            }
            case "setlobby": {
                this.handleSetLobby(player, args);
                break;
            }
            case "info": {
                this.handleInfo(player, args);
                break;
            }
            case "list": {
                this.handleList(player);
                break;
            }
            case "wand": {
                this.handleWand(player);
                break;
            }
            case "select": {
                this.handleSelect(player, args);
                break;
            }
            case "enable": {
                this.handleEnable(player, args);
                break;
            }
            case "disable": {
                this.handleDisable(player, args);
                break;
            }
            case "protect": {
                this.handleProtect(player, args);
                break;
            }
            case "tp": {
                this.handleTeleport(player, args);
                break;
            }
            case "maker": {
                this.handleMaker(player);
                break;
            }
            case "presets": {
                this.handlePresets(player);
                break;
            }
            case "setmode": {
                this.handleSetMode(player, args);
                break;
            }
            case "addmobspawn": {
                this.handleAddMobSpawn(player, args);
                break;
            }
            case "clearmobspawns": {
                this.handleClearMobSpawns(player, args);
                break;
            }
            case "gui": 
            case "admin": 
            case "menu": {
                this.plugin.getAdminGUI().openMain(player);
                break;
            }
            case "hide": {
                this.plugin.getVisualizer().stop(player);
                Msg.send((CommandSender)player, "Visualization hidden.");
                break;
            }
            default: {
                this.showHelp(player);
            }
        }
        return true;
    }

    private void showHelp(Player player) {
        Msg.raw((CommandSender)player, "");
        Msg.info((CommandSender)player, "Arena Maker Commands");
        Msg.raw((CommandSender)player, String.valueOf(Msg.SECONDARY) + " /arena gui " + String.valueOf(Msg.HIGHLIGHT) + "- Open admin panel");
        Msg.raw((CommandSender)player, String.valueOf(Msg.SECONDARY) + " /arena create <id> " + String.valueOf(Msg.HIGHLIGHT) + "- Create arena");
        Msg.raw((CommandSender)player, String.valueOf(Msg.SECONDARY) + " /arena delete <id> " + String.valueOf(Msg.HIGHLIGHT) + "- Delete arena");
        Msg.raw((CommandSender)player, String.valueOf(Msg.SECONDARY) + " /arena setpos <id> <1|2> " + String.valueOf(Msg.HIGHLIGHT) + "- Set corners");
        Msg.raw((CommandSender)player, String.valueOf(Msg.SECONDARY) + " /arena setspawn <id> <1|2> " + String.valueOf(Msg.HIGHLIGHT) + "- Set spawns");
        Msg.raw((CommandSender)player, String.valueOf(Msg.SECONDARY) + " /arena setlobby <id> " + String.valueOf(Msg.HIGHLIGHT) + "- Set lobby");
        Msg.raw((CommandSender)player, String.valueOf(Msg.SECONDARY) + " /arena select <id> " + String.valueOf(Msg.HIGHLIGHT) + "- Use WE selection");
        Msg.raw((CommandSender)player, String.valueOf(Msg.SECONDARY) + " /arena protect <id> " + String.valueOf(Msg.HIGHLIGHT) + "- Create WG region");
        Msg.raw((CommandSender)player, String.valueOf(Msg.SECONDARY) + " /arena enable/disable <id> " + String.valueOf(Msg.HIGHLIGHT) + "- Toggle arena");
        Msg.raw((CommandSender)player, String.valueOf(Msg.SECONDARY) + " /arena info <id> " + String.valueOf(Msg.HIGHLIGHT) + "- Arena details");
        Msg.raw((CommandSender)player, String.valueOf(Msg.SECONDARY) + " /arena list " + String.valueOf(Msg.HIGHLIGHT) + "- List arenas");
        Msg.raw((CommandSender)player, String.valueOf(Msg.SECONDARY) + " /arena tp <id> " + String.valueOf(Msg.HIGHLIGHT) + "- Teleport to arena");
        Msg.raw((CommandSender)player, String.valueOf(Msg.SECONDARY) + " /arena maker " + String.valueOf(Msg.HIGHLIGHT) + "- Start wizard mode");
        Msg.raw((CommandSender)player, String.valueOf(Msg.SECONDARY) + " /arena presets " + String.valueOf(Msg.HIGHLIGHT) + "- View presets");
        Msg.raw((CommandSender)player, String.valueOf(Msg.SECONDARY) + " /arena setmode <id> <mode> " + String.valueOf(Msg.HIGHLIGHT) + "- Set game mode");
        Msg.raw((CommandSender)player, String.valueOf(Msg.SECONDARY) + " /arena addmobspawn <id> " + String.valueOf(Msg.HIGHLIGHT) + "- Add mob spawn");
        Msg.raw((CommandSender)player, String.valueOf(Msg.SECONDARY) + " /arena hide " + String.valueOf(Msg.HIGHLIGHT) + "- Hide visualizer");
        Msg.raw((CommandSender)player, "");
    }

    private void handleCreate(Player player, String[] args) {
        Preset preset;
        if (args.length < 2) {
            Msg.error((CommandSender)player, "Usage: /arena create <id> [preset]");
            return;
        }
        String id = args[1];
        if (this.plugin.getArenaManager().exists(id)) {
            Msg.error((CommandSender)player, "Arena '" + id + "' already exists.");
            return;
        }
        Arena arena = this.plugin.getArenaManager().create(id);
        if (arena == null) {
            Msg.error((CommandSender)player, "Failed to create arena.");
            return;
        }
        if (args.length >= 3 && (preset = Preset.fromName(args[2])) != null) {
            arena.setPreset(preset);
            this.plugin.getArenaManager().save();
        }
        Msg.success((CommandSender)player, "Created arena " + Msg.accent(id) + ".");
        Msg.send((CommandSender)player, "Use " + Msg.accent("/arena setpos") + " or " + Msg.accent("/arena select") + " to set bounds.");
    }

    private void handleDelete(Player player, String[] args) {
        if (args.length < 2) {
            Msg.error((CommandSender)player, "Usage: /arena delete <id>");
            return;
        }
        String id = args[1];
        if (!this.plugin.getArenaManager().exists(id)) {
            Msg.error((CommandSender)player, "Arena '" + id + "' not found.");
            return;
        }
        this.plugin.getArenaManager().delete(id);
        Msg.success((CommandSender)player, "Deleted arena " + Msg.accent(id) + ".");
    }

    private void handleSetPos(Player player, String[] args) {
        if (args.length < 3) {
            Msg.error((CommandSender)player, "Usage: /arena setpos <id> <1|2>");
            return;
        }
        Arena arena = this.plugin.getArenaManager().get(args[1]);
        if (arena == null) {
            Msg.error((CommandSender)player, "Arena not found.");
            return;
        }
        int pos = args[2].equals("1") ? 1 : 2;
        Location loc = player.getLocation().getBlock().getLocation();
        if (pos == 1) {
            arena.setPos1(loc);
        } else {
            arena.setPos2(loc);
        }
        this.plugin.getArenaManager().save();
        Msg.success((CommandSender)player, "Set position " + pos + " for " + Msg.accent(arena.getId()) + ".");
        if (arena.getPos1() != null && arena.getPos2() != null) {
            this.plugin.getVisualizer().showBounds(player, arena.getPos1(), arena.getPos2());
        } else if (loc != null) {
            this.plugin.getVisualizer().showCorner(player, loc);
        }
    }

    private void handleSetSpawn(Player player, String[] args) {
        if (args.length < 3) {
            Msg.error((CommandSender)player, "Usage: /arena setspawn <id> <1|2>");
            return;
        }
        Arena arena = this.plugin.getArenaManager().get(args[1]);
        if (arena == null) {
            Msg.error((CommandSender)player, "Arena not found.");
            return;
        }
        int spawn = args[2].equals("1") ? 1 : 2;
        Location loc = player.getLocation();
        if (spawn == 1) {
            arena.setSpawn1(loc);
        } else {
            arena.setSpawn2(loc);
        }
        this.plugin.getArenaManager().save();
        Msg.success((CommandSender)player, "Set spawn " + spawn + " for " + Msg.accent(arena.getId()) + ".");
        if (arena.getPos1() != null && arena.getPos2() != null) {
            this.plugin.getVisualizer().showBoundsWithSpawns(player, arena.getPos1(), arena.getPos2(), arena.getSpawn1(), arena.getSpawn2());
        }
    }

    private void handleSetLobby(Player player, String[] args) {
        if (args.length < 2) {
            Msg.error((CommandSender)player, "Usage: /arena setlobby <id>");
            return;
        }
        Arena arena = this.plugin.getArenaManager().get(args[1]);
        if (arena == null) {
            Msg.error((CommandSender)player, "Arena not found.");
            return;
        }
        arena.setLobby(player.getLocation());
        this.plugin.getArenaManager().save();
        Msg.success((CommandSender)player, "Set lobby for " + Msg.accent(arena.getId()) + ".");
    }

    private void handleInfo(Player player, String[] args) {
        if (args.length < 2) {
            Msg.error((CommandSender)player, "Usage: /arena info <id>");
            return;
        }
        Arena arena = this.plugin.getArenaManager().get(args[1]);
        if (arena == null) {
            Msg.error((CommandSender)player, "Arena not found.");
            return;
        }
        Msg.raw((CommandSender)player, "");
        Msg.info((CommandSender)player, "Arena: " + Msg.accent(arena.getId()));
        Msg.raw((CommandSender)player, String.valueOf(Msg.SECONDARY) + " Preset: " + String.valueOf(Msg.HIGHLIGHT) + arena.getPreset().getDisplay());
        Msg.raw((CommandSender)player, String.valueOf(Msg.SECONDARY) + " Status: " + (arena.isEnabled() ? String.valueOf(Msg.SUCCESS) + "Enabled" : String.valueOf(Msg.ERROR) + "Disabled"));
        Msg.raw((CommandSender)player, String.valueOf(Msg.SECONDARY) + " Complete: " + (arena.isComplete() ? String.valueOf(Msg.SUCCESS) + "Yes" : String.valueOf(Msg.ERROR) + "No"));
        Msg.raw((CommandSender)player, String.valueOf(Msg.SECONDARY) + " Pos1: " + (arena.getPos1() != null ? String.valueOf(Msg.HIGHLIGHT) + this.formatLoc(arena.getPos1()) : String.valueOf(Msg.ERROR) + "Not set"));
        Msg.raw((CommandSender)player, String.valueOf(Msg.SECONDARY) + " Pos2: " + (arena.getPos2() != null ? String.valueOf(Msg.HIGHLIGHT) + this.formatLoc(arena.getPos2()) : String.valueOf(Msg.ERROR) + "Not set"));
        Msg.raw((CommandSender)player, String.valueOf(Msg.SECONDARY) + " Spawn1: " + (arena.getSpawn1() != null ? String.valueOf(Msg.HIGHLIGHT) + this.formatLoc(arena.getSpawn1()) : String.valueOf(Msg.ERROR) + "Not set"));
        Msg.raw((CommandSender)player, String.valueOf(Msg.SECONDARY) + " Spawn2: " + (arena.getSpawn2() != null ? String.valueOf(Msg.HIGHLIGHT) + this.formatLoc(arena.getSpawn2()) : String.valueOf(Msg.ERROR) + "Not set"));
        Msg.raw((CommandSender)player, String.valueOf(Msg.SECONDARY) + " Region: " + (arena.getRegionId() != null ? String.valueOf(Msg.HIGHLIGHT) + arena.getRegionId() : String.valueOf(Msg.ERROR) + "None"));
        Msg.raw((CommandSender)player, "");
        if (arena.getPos1() != null && arena.getPos2() != null) {
            this.plugin.getVisualizer().showBoundsWithSpawns(player, arena.getPos1(), arena.getPos2(), arena.getSpawn1(), arena.getSpawn2());
        }
    }

    private void handleList(Player player) {
        Collection<Arena> arenas = this.plugin.getArenaManager().getAll();
        if (arenas.isEmpty()) {
            Msg.send((CommandSender)player, "No arenas created yet.");
            return;
        }
        Msg.raw((CommandSender)player, "");
        Msg.info((CommandSender)player, "Arenas (" + arenas.size() + ")");
        for (Arena arena : arenas) {
            String status = arena.isEnabled() ? String.valueOf(Msg.SUCCESS) + "\u25cf" : String.valueOf(Msg.ERROR) + "\u25cf";
            Msg.raw((CommandSender)player, " " + status + String.valueOf(Msg.SECONDARY) + " " + arena.getId() + " " + String.valueOf(Msg.HIGHLIGHT) + "(" + arena.getPreset().getDisplay() + ")");
        }
        Msg.raw((CommandSender)player, "");
    }

    private void handleWand(Player player) {
        WEHook we = this.plugin.getWEHook();
        if (!we.isEnabled()) {
            Msg.error((CommandSender)player, "WorldEdit not available.");
            return;
        }
        player.performCommand("wand");
        Msg.send((CommandSender)player, "Use the wand to select arena corners.");
    }

    private void handleSelect(Player player, String[] args) {
        if (args.length < 2) {
            Msg.error((CommandSender)player, "Usage: /arena select <id>");
            return;
        }
        WEHook we = this.plugin.getWEHook();
        if (!we.isEnabled()) {
            Msg.error((CommandSender)player, "WorldEdit not available.");
            return;
        }
        Arena arena = this.plugin.getArenaManager().get(args[1]);
        if (arena == null) {
            Msg.error((CommandSender)player, "Arena not found.");
            return;
        }
        Location[] sel = we.getSelection(player);
        if (sel == null) {
            Msg.error((CommandSender)player, "No WorldEdit selection. Use //wand first.");
            return;
        }
        arena.setPos1(sel[0]);
        arena.setPos2(sel[1]);
        this.plugin.getArenaManager().save();
        Msg.success((CommandSender)player, "Applied selection to " + Msg.accent(arena.getId()) + ".");
        this.plugin.getVisualizer().showBounds(player, sel[0], sel[1]);
    }

    private void handleProtect(Player player, String[] args) {
        if (args.length < 2) {
            Msg.error((CommandSender)player, "Usage: /arena protect <id>");
            return;
        }
        WGHook wg = this.plugin.getWGHook();
        if (!wg.isEnabled()) {
            Msg.error((CommandSender)player, "WorldGuard not available.");
            return;
        }
        Arena arena = this.plugin.getArenaManager().get(args[1]);
        if (arena == null) {
            Msg.error((CommandSender)player, "Arena not found.");
            return;
        }
        if (arena.getPos1() == null || arena.getPos2() == null) {
            Msg.error((CommandSender)player, "Set positions first.");
            return;
        }
        String regionId = wg.createRegion(arena.getId(), arena.getPos1(), arena.getPos2());
        if (regionId == null) {
            Msg.error((CommandSender)player, "Failed to create region.");
            return;
        }
        arena.setRegionId(regionId);
        this.plugin.getArenaManager().save();
        Msg.success((CommandSender)player, "Created region " + Msg.accent(regionId) + ".");
    }

    private void handleEnable(Player player, String[] args) {
        if (args.length < 2) {
            Msg.error((CommandSender)player, "Usage: /arena enable <id>");
            return;
        }
        Arena arena = this.plugin.getArenaManager().get(args[1]);
        if (arena == null) {
            Msg.error((CommandSender)player, "Arena not found.");
            return;
        }
        if (!arena.isComplete()) {
            Msg.error((CommandSender)player, "Arena setup incomplete.");
            return;
        }
        arena.setEnabled(true);
        this.plugin.getArenaManager().save();
        Msg.success((CommandSender)player, "Enabled arena " + Msg.accent(arena.getId()) + ".");
    }

    private void handleDisable(Player player, String[] args) {
        if (args.length < 2) {
            Msg.error((CommandSender)player, "Usage: /arena disable <id>");
            return;
        }
        Arena arena = this.plugin.getArenaManager().get(args[1]);
        if (arena == null) {
            Msg.error((CommandSender)player, "Arena not found.");
            return;
        }
        arena.setEnabled(false);
        this.plugin.getArenaManager().save();
        Msg.send((CommandSender)player, "Disabled arena " + Msg.accent(arena.getId()) + ".");
    }

    private void handleTeleport(Player player, String[] args) {
        Location dest;
        if (args.length < 2) {
            Msg.error((CommandSender)player, "Usage: /arena tp <id>");
            return;
        }
        Arena arena = this.plugin.getArenaManager().get(args[1]);
        if (arena == null) {
            Msg.error((CommandSender)player, "Arena not found.");
            return;
        }
        Location location = dest = arena.getSpawn1() != null ? arena.getSpawn1() : arena.getCenter();
        if (dest == null) {
            Msg.error((CommandSender)player, "No spawn or center set.");
            return;
        }
        player.teleport(dest);
        Msg.success((CommandSender)player, "Teleported to " + Msg.accent(arena.getId()) + ".");
    }

    private void handleMaker(Player player) {
        if (this.plugin.getMakerMode().isInMode(player)) {
            this.plugin.getMakerMode().exit(player);
            Msg.send((CommandSender)player, "Exited maker mode.");
        } else {
            this.plugin.getMakerMode().enter(player);
        }
    }

    private void handlePresets(Player player) {
        Msg.raw((CommandSender)player, "");
        Msg.info((CommandSender)player, "Arena Presets");
        for (Preset p : Preset.values()) {
            if (p == Preset.CUSTOM) continue;
            Msg.raw((CommandSender)player, String.valueOf(Msg.SECONDARY) + " " + p.name() + " " + String.valueOf(Msg.HIGHLIGHT) + "- " + p.getDisplay() + " (" + p.getSizeX() + "x" + p.getSizeZ() + ")");
        }
        Msg.raw((CommandSender)player, "");
    }

    private void handleSetMode(Player player, String[] args) {
        if (args.length < 3) {
            Msg.error((CommandSender)player, "Usage: /arena setmode <id> <mode>");
            Msg.send((CommandSender)player, "Modes: DUEL, FFA, WAVES, INFECTED, KOTH, TDM");
            return;
        }
        Arena arena = this.plugin.getArenaManager().get(args[1]);
        if (arena == null) {
            Msg.error((CommandSender)player, "Arena not found.");
            return;
        }
        GameMode mode = GameMode.fromName(args[2]);
        arena.setGameMode(mode);
        this.plugin.getArenaManager().save();
        Msg.success((CommandSender)player, "Set mode to " + Msg.accent(mode.getDisplay()) + " for " + arena.getId());
    }

    private void handleAddMobSpawn(Player player, String[] args) {
        if (args.length < 2) {
            Msg.error((CommandSender)player, "Usage: /arena addmobspawn <id>");
            return;
        }
        Arena arena = this.plugin.getArenaManager().get(args[1]);
        if (arena == null) {
            Msg.error((CommandSender)player, "Arena not found.");
            return;
        }
        arena.addMobSpawn(player.getLocation());
        this.plugin.getArenaManager().save();
        Msg.success((CommandSender)player, "Added mob spawn #" + arena.getMobSpawns().size() + " to " + Msg.accent(arena.getId()));
    }

    private void handleClearMobSpawns(Player player, String[] args) {
        if (args.length < 2) {
            Msg.error((CommandSender)player, "Usage: /arena clearmobspawns <id>");
            return;
        }
        Arena arena = this.plugin.getArenaManager().get(args[1]);
        if (arena == null) {
            Msg.error((CommandSender)player, "Arena not found.");
            return;
        }
        arena.clearMobSpawns();
        this.plugin.getArenaManager().save();
        Msg.success((CommandSender)player, "Cleared all mob spawns from " + Msg.accent(arena.getId()));
    }

    private String formatLoc(Location loc) {
        return loc.getBlockX() + ", " + loc.getBlockY() + ", " + loc.getBlockZ();
    }

    public List<String> onTabComplete(CommandSender sender, Command cmd, String label, String[] args) {
        List<String> completions = new ArrayList<String>();
        if (args.length == 1) {
            List<String> subs = Arrays.asList("gui", "create", "delete", "setpos", "setspawn", "setlobby", "info", "list", "wand", "select", "enable", "disable", "protect", "tp", "maker", "presets", "setmode", "addmobspawn", "clearmobspawns", "hide");
            String input = args[0].toLowerCase();
            completions = subs.stream().filter(s -> s.startsWith(input)).collect(Collectors.toList());
        } else if (args.length == 2) {
            String sub = args[0].toLowerCase();
            if (Arrays.asList("delete", "setpos", "setspawn", "setlobby", "info", "select", "enable", "disable", "protect", "tp", "setmode", "addmobspawn", "clearmobspawns").contains(sub)) {
                String input = args[1].toLowerCase();
                completions = this.plugin.getArenaManager().getAll().stream().map(Arena::getId).filter(id -> id.startsWith(input)).collect(Collectors.toList());
            } else if (sub.equals("create")) {
                completions = Arrays.asList("<id>");
            }
        } else if (args.length == 3) {
            String sub = args[0].toLowerCase();
            if (sub.equals("setpos") || sub.equals("setspawn")) {
                completions = Arrays.asList("1", "2");
            } else if (sub.equals("create")) {
                completions = Arrays.stream(Preset.values()).map(Enum::name).collect(Collectors.toList());
            } else if (sub.equals("setmode")) {
                completions = Arrays.stream(GameMode.values()).map(Enum::name).collect(Collectors.toList());
            }
        }
        return completions;
    }
}

