/*
 * Decompiled with CFR 0.152.
 */
package AM.arenaMaker.cmd;

import AM.arenaMaker.ArenaMaker;
import AM.arenaMaker.arena.Arena;
import AM.arenaMaker.data.PlayerStats;
import AM.arenaMaker.duel.DuelMatch;
import AM.arenaMaker.duel.DuelRequest;
import AM.arenaMaker.kit.Kit;
import AM.arenaMaker.util.Msg;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.UUID;
import java.util.stream.Collectors;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabCompleter;
import org.bukkit.entity.Player;

public class DuelCmd
implements CommandExecutor,
TabCompleter {
    private final ArenaMaker plugin;

    public DuelCmd(ArenaMaker plugin) {
        this.plugin = plugin;
    }

    public boolean onCommand(CommandSender sender, Command cmd, String label, String[] args) {
        String sub;
        if (!(sender instanceof Player)) {
            Msg.error(sender, "Only players can use this.");
            return true;
        }
        Player player = (Player)sender;
        if (args.length == 0) {
            this.showHelp(player);
            return true;
        }
        switch (sub = args[0].toLowerCase()) {
            case "challenge": 
            case "request": {
                this.handleChallenge(player, args);
                break;
            }
            case "accept": {
                this.handleAccept(player, args);
                break;
            }
            case "deny": 
            case "decline": {
                this.handleDeny(player);
                break;
            }
            case "stats": {
                this.handleStats(player, args);
                break;
            }
            case "top": 
            case "leaderboard": {
                this.handleTop(player, args);
                break;
            }
            case "queue": {
                this.handleQueue(player, args);
                break;
            }
            case "leave": {
                this.handleLeave(player);
                break;
            }
            case "spectate": 
            case "spec": {
                this.handleSpectate(player, args);
                break;
            }
            default: {
                this.showHelp(player);
            }
        }
        return true;
    }

    private void showHelp(Player player) {
        Msg.raw((CommandSender)player, "");
        Msg.info((CommandSender)player, "Duel Commands");
        Msg.raw((CommandSender)player, String.valueOf(Msg.SECONDARY) + " /duel <player> [wager] " + String.valueOf(Msg.HIGHLIGHT) + "- Challenge player");
        Msg.raw((CommandSender)player, String.valueOf(Msg.SECONDARY) + " /duel accept " + String.valueOf(Msg.HIGHLIGHT) + "- Accept duel request");
        Msg.raw((CommandSender)player, String.valueOf(Msg.SECONDARY) + " /duel deny " + String.valueOf(Msg.HIGHLIGHT) + "- Deny duel request");
        Msg.raw((CommandSender)player, String.valueOf(Msg.SECONDARY) + " /duel stats [player] " + String.valueOf(Msg.HIGHLIGHT) + "- View stats");
        Msg.raw((CommandSender)player, String.valueOf(Msg.SECONDARY) + " /duel top [wins/elo/streak] " + String.valueOf(Msg.HIGHLIGHT) + "- Leaderboards");
        Msg.raw((CommandSender)player, String.valueOf(Msg.SECONDARY) + " /duel queue [arena] " + String.valueOf(Msg.HIGHLIGHT) + "- Join matchmaking");
        Msg.raw((CommandSender)player, String.valueOf(Msg.SECONDARY) + " /duel leave " + String.valueOf(Msg.HIGHLIGHT) + "- Leave queue");
        Msg.raw((CommandSender)player, "");
    }

    private void handleChallenge(Player player, String[] args) {
        if (args.length < 2) {
            Msg.error((CommandSender)player, "Usage: /duel <player> [wager]");
            return;
        }
        if (this.plugin.getDuelManager().isInMatch(player.getUniqueId())) {
            Msg.error((CommandSender)player, "You're already in a match.");
            return;
        }
        Player target = Bukkit.getPlayer((String)args[1]);
        if (target == null) {
            Msg.error((CommandSender)player, "Player not found.");
            return;
        }
        if (target.equals((Object)player)) {
            Msg.error((CommandSender)player, "You can't duel yourself.");
            return;
        }
        if (this.plugin.getDuelManager().isInMatch(target.getUniqueId())) {
            Msg.error((CommandSender)player, "That player is in a match.");
            return;
        }
        Arena arena = this.plugin.getDuelManager().findAvailableArena();
        if (arena == null) {
            Msg.error((CommandSender)player, "No arenas available.");
            return;
        }
        double wager = 0.0;
        if (args.length >= 3) {
            try {
                wager = Double.parseDouble(args[2]);
                if (wager < 0.0) {
                    wager = 0.0;
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        if (wager > 0.0 && this.plugin.getVaultHook().isEnabled()) {
            if (!this.plugin.getVaultHook().has(player, wager)) {
                Msg.error((CommandSender)player, "You don't have enough money.");
                return;
            }
            if (!this.plugin.getVaultHook().has(target, wager)) {
                Msg.error((CommandSender)player, "They don't have enough money.");
                return;
            }
            this.plugin.getStatsManager().get(player.getUniqueId()).addWagered(wager);
        }
        Kit kit = this.plugin.getKitManager().get("pvp");
        int duration = this.plugin.getConfig().getInt("duel.default-duration", 300);
        boolean sent = this.plugin.getDuelManager().sendRequest(player, target, arena, kit, wager, duration);
        if (!sent) {
            Msg.error((CommandSender)player, "Failed to send request.");
            return;
        }
        Msg.success((CommandSender)player, "Sent duel request to " + Msg.accent(target.getName()) + ".");
        if (wager > 0.0) {
            Msg.send((CommandSender)player, "Wager: " + Msg.accent(this.plugin.getVaultHook().format(wager)));
        }
        Msg.raw((CommandSender)target, "");
        Msg.info((CommandSender)target, Msg.accent(player.getName()) + " challenges you to a duel!");
        if (wager > 0.0) {
            Msg.send((CommandSender)target, "Wager: " + Msg.accent(this.plugin.getVaultHook().format(wager)));
        }
        Msg.send((CommandSender)target, "Arena: " + Msg.accent(arena.getName()));
        Msg.send((CommandSender)target, "Type " + Msg.accent("/duel accept") + " or " + Msg.accent("/duel deny"));
        Msg.raw((CommandSender)target, "");
    }

    private void handleAccept(Player player, String[] args) {
        DuelRequest request = this.plugin.getDuelManager().getRequest(player);
        if (request == null) {
            Msg.error((CommandSender)player, "No pending duel request.");
            return;
        }
        if (request.getWager() > 0.0 && this.plugin.getVaultHook().isEnabled() && !this.plugin.getVaultHook().has(player, request.getWager())) {
            Msg.error((CommandSender)player, "You don't have enough money for the wager.");
            return;
        }
        Player sender = Bukkit.getPlayer((UUID)request.getSender());
        if (sender == null) {
            Msg.error((CommandSender)player, "Challenger is no longer online.");
            this.plugin.getDuelManager().denyRequest(player);
            return;
        }
        boolean started = this.plugin.getDuelManager().acceptRequest(player);
        if (!started) {
            Msg.error((CommandSender)player, "Failed to start duel.");
            return;
        }
        Msg.success((CommandSender)player, "Duel accepted!");
        Msg.success((CommandSender)sender, Msg.accent(player.getName()) + " accepted your duel!");
    }

    private void handleDeny(Player player) {
        DuelRequest request = this.plugin.getDuelManager().getRequest(player);
        if (request == null) {
            Msg.error((CommandSender)player, "No pending duel request.");
            return;
        }
        this.plugin.getDuelManager().denyRequest(player);
        Msg.send((CommandSender)player, "Duel request denied.");
        Player sender = Bukkit.getPlayer((UUID)request.getSender());
        if (sender != null) {
            Msg.send((CommandSender)sender, Msg.accent(player.getName()) + " denied your duel request.");
        }
    }

    private void handleStats(Player player, String[] args) {
        String targetName;
        UUID targetId;
        if (args.length >= 2) {
            OfflinePlayer target = Bukkit.getOfflinePlayer((String)args[1]);
            targetId = target.getUniqueId();
            targetName = target.getName() != null ? target.getName() : args[1];
        } else {
            targetId = player.getUniqueId();
            targetName = player.getName();
        }
        PlayerStats stats = this.plugin.getStatsManager().get(targetId);
        int rank = this.plugin.getStatsManager().getRank(targetId);
        Msg.raw((CommandSender)player, "");
        Msg.info((CommandSender)player, "Stats: " + Msg.accent(targetName));
        Msg.raw((CommandSender)player, String.valueOf(Msg.SECONDARY) + " Rank: " + String.valueOf(Msg.HIGHLIGHT) + "#" + rank);
        Msg.raw((CommandSender)player, String.valueOf(Msg.SECONDARY) + " Elo: " + String.valueOf(Msg.HIGHLIGHT) + stats.getElo());
        Msg.raw((CommandSender)player, String.valueOf(Msg.SECONDARY) + " Wins: " + String.valueOf(Msg.SUCCESS) + stats.getWins() + String.valueOf(Msg.SECONDARY) + " | Losses: " + String.valueOf(Msg.ERROR) + stats.getLosses());
        Msg.raw((CommandSender)player, String.valueOf(Msg.SECONDARY) + " Win Rate: " + String.valueOf(Msg.HIGHLIGHT) + String.format("%.1f%%", stats.getWinRate()));
        Msg.raw((CommandSender)player, String.valueOf(Msg.SECONDARY) + " Streak: " + String.valueOf(Msg.HIGHLIGHT) + stats.getStreak() + String.valueOf(Msg.SECONDARY) + " | Best: " + String.valueOf(Msg.HIGHLIGHT) + stats.getBestStreak());
        Msg.raw((CommandSender)player, String.valueOf(Msg.SECONDARY) + " K/D: " + String.valueOf(Msg.HIGHLIGHT) + String.format("%.2f", stats.getKdr()));
        if (this.plugin.getVaultHook().isEnabled()) {
            Msg.raw((CommandSender)player, String.valueOf(Msg.SECONDARY) + " Earnings: " + String.valueOf(Msg.SUCCESS) + this.plugin.getVaultHook().format(stats.getEarnings()));
        }
        Msg.raw((CommandSender)player, "");
    }

    private void handleTop(Player player, String[] args) {
        String type;
        List<PlayerStats> top = switch (type = args.length >= 2 ? args[1].toLowerCase() : "elo") {
            case "wins" -> this.plugin.getStatsManager().getTopByWins(10);
            case "streak" -> this.plugin.getStatsManager().getTopByStreak(10);
            case "earnings", "money" -> this.plugin.getStatsManager().getTopByEarnings(10);
            default -> this.plugin.getStatsManager().getTopByElo(10);
        };
        Msg.raw((CommandSender)player, "");
        Msg.info((CommandSender)player, "Top 10 - " + type.substring(0, 1).toUpperCase() + type.substring(1));
        int rank = 1;
        for (PlayerStats stats : top) {
            OfflinePlayer op = Bukkit.getOfflinePlayer((UUID)stats.getUuid());
            String name = op.getName() != null ? op.getName() : "Unknown";
            String value = switch (type) {
                case "wins" -> String.valueOf(stats.getWins());
                case "streak" -> String.valueOf(stats.getBestStreak());
                case "earnings", "money" -> this.plugin.getVaultHook().format(stats.getEarnings());
                default -> String.valueOf(stats.getElo());
            };
            Msg.raw((CommandSender)player, String.valueOf(Msg.HIGHLIGHT) + " #" + rank + " " + String.valueOf(Msg.SECONDARY) + name + " " + String.valueOf(Msg.PRIMARY) + value);
            ++rank;
        }
        Msg.raw((CommandSender)player, "");
    }

    private void handleQueue(Player player, String[] args) {
        Arena arena;
        if (this.plugin.getQueueManager().isInQueue(player.getUniqueId())) {
            int pos = this.plugin.getQueueManager().getQueuePosition(player.getUniqueId());
            Msg.send((CommandSender)player, "You're in queue. Position: " + Msg.accent(String.valueOf(pos)));
            return;
        }
        if (args.length >= 2) {
            arena = this.plugin.getArenaManager().get(args[1]);
            if (arena == null) {
                Msg.error((CommandSender)player, "Arena not found.");
                return;
            }
        } else {
            arena = this.plugin.getDuelManager().findAvailableArena();
            if (arena == null) {
                Msg.error((CommandSender)player, "No arenas available.");
                return;
            }
        }
        this.plugin.getQueueManager().addToQueue(player, arena);
    }

    private void handleLeave(Player player) {
        if (this.plugin.getQueueManager().isInQueue(player.getUniqueId())) {
            this.plugin.getQueueManager().removeFromQueue(player);
            return;
        }
        DuelMatch match = this.plugin.getDuelManager().getPlayerMatch(player.getUniqueId());
        if (match != null) {
            Msg.error((CommandSender)player, "You can't leave during a match.");
            return;
        }
        Msg.error((CommandSender)player, "You're not in a queue or match.");
    }

    private void handleSpectate(Player player, String[] args) {
        if (args.length < 2) {
            Msg.error((CommandSender)player, "Usage: /duel spectate <player>");
            return;
        }
        Player target = Bukkit.getPlayer((String)args[1]);
        if (target == null) {
            Msg.error((CommandSender)player, "Player not found.");
            return;
        }
        DuelMatch match = this.plugin.getDuelManager().getPlayerMatch(target.getUniqueId());
        if (match == null) {
            Msg.error((CommandSender)player, "That player is not in a match.");
            return;
        }
        player.teleport(match.getArena().getCenter());
        Msg.success((CommandSender)player, "Spectating match in " + Msg.accent(match.getArena().getName()));
    }

    public List<String> onTabComplete(CommandSender sender, Command cmd, String label, String[] args) {
        ArrayList<String> completions = new ArrayList<String>();
        if (args.length == 1) {
            List<String> subs = Arrays.asList("challenge", "accept", "deny", "stats", "top", "queue", "leave", "spectate");
            String input = args[0].toLowerCase();
            for (Player p : Bukkit.getOnlinePlayers()) {
                if (!p.getName().toLowerCase().startsWith(input)) continue;
                completions.add(p.getName());
            }
            completions.addAll(subs.stream().filter(s -> s.startsWith(input)).collect(Collectors.toList()));
        } else if (args.length == 2) {
            String sub = args[0].toLowerCase();
            String input = args[1].toLowerCase();
            if (sub.equals("stats") || sub.equals("spectate") || sub.equals("challenge")) {
                for (Player p : Bukkit.getOnlinePlayers()) {
                    if (!p.getName().toLowerCase().startsWith(input)) continue;
                    completions.add(p.getName());
                }
            } else if (sub.equals("top")) {
                completions.addAll(Arrays.asList("elo", "wins", "streak", "earnings"));
            } else if (sub.equals("queue")) {
                completions.addAll(this.plugin.getArenaManager().getAll().stream().map(Arena::getId).filter(id -> id.startsWith(input)).collect(Collectors.toList()));
            }
        }
        return completions;
    }
}

