/*
 * Decompiled with CFR 0.152.
 */
package AM.arenaMaker.cmd;

import AM.arenaMaker.ArenaMaker;
import AM.arenaMaker.arena.Arena;
import AM.arenaMaker.game.Difficulty;
import AM.arenaMaker.game.GameMode;
import AM.arenaMaker.game.GameSession;
import AM.arenaMaker.shop.Shop;
import AM.arenaMaker.util.Msg;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabCompleter;
import org.bukkit.entity.Player;

public class GameCmd
implements CommandExecutor,
TabCompleter {
    private final ArenaMaker plugin;

    public GameCmd(ArenaMaker plugin) {
        this.plugin = plugin;
    }

    public boolean onCommand(CommandSender sender, Command cmd, String label, String[] args) {
        String sub;
        if (!(sender instanceof Player)) {
            Msg.error(sender, "Only players can use this.");
            return true;
        }
        Player player = (Player)sender;
        if (args.length == 0) {
            this.showHelp(player);
            return true;
        }
        switch (sub = args[0].toLowerCase()) {
            case "create": {
                this.handleCreate(player, args);
                break;
            }
            case "join": {
                this.handleJoin(player, args);
                break;
            }
            case "leave": {
                this.handleLeave(player);
                break;
            }
            case "start": {
                this.handleStart(player);
                break;
            }
            case "stop": 
            case "end": {
                this.handleStop(player);
                break;
            }
            case "shop": {
                this.handleShop(player);
                break;
            }
            case "points": {
                this.handlePoints(player);
                break;
            }
            case "list": {
                this.handleList(player);
                break;
            }
            case "info": {
                this.handleInfo(player);
                break;
            }
            case "modes": {
                this.handleModes(player);
                break;
            }
            case "difficulty": {
                this.handleDifficulty(player, args);
                break;
            }
            default: {
                this.showHelp(player);
            }
        }
        return true;
    }

    private void showHelp(Player player) {
        Msg.raw((CommandSender)player, "");
        Msg.info((CommandSender)player, "Game Commands");
        Msg.raw((CommandSender)player, String.valueOf(Msg.SECONDARY) + " /game create <arena> <mode> [diff] " + String.valueOf(Msg.HIGHLIGHT) + "- Create game");
        Msg.raw((CommandSender)player, String.valueOf(Msg.SECONDARY) + " /game join [arena] " + String.valueOf(Msg.HIGHLIGHT) + "- Join game");
        Msg.raw((CommandSender)player, String.valueOf(Msg.SECONDARY) + " /game leave " + String.valueOf(Msg.HIGHLIGHT) + "- Leave current game");
        Msg.raw((CommandSender)player, String.valueOf(Msg.SECONDARY) + " /game start " + String.valueOf(Msg.HIGHLIGHT) + "- Start game");
        Msg.raw((CommandSender)player, String.valueOf(Msg.SECONDARY) + " /game stop " + String.valueOf(Msg.HIGHLIGHT) + "- Force end game");
        Msg.raw((CommandSender)player, String.valueOf(Msg.SECONDARY) + " /game difficulty <diff> " + String.valueOf(Msg.HIGHLIGHT) + "- Set difficulty");
        Msg.raw((CommandSender)player, String.valueOf(Msg.SECONDARY) + " /game shop " + String.valueOf(Msg.HIGHLIGHT) + "- Open shop");
        Msg.raw((CommandSender)player, String.valueOf(Msg.SECONDARY) + " /game points " + String.valueOf(Msg.HIGHLIGHT) + "- Check points");
        Msg.raw((CommandSender)player, String.valueOf(Msg.SECONDARY) + " /game list " + String.valueOf(Msg.HIGHLIGHT) + "- Active games");
        Msg.raw((CommandSender)player, String.valueOf(Msg.SECONDARY) + " /game modes " + String.valueOf(Msg.HIGHLIGHT) + "- List game modes");
        Msg.raw((CommandSender)player, "");
    }

    private void handleCreate(Player player, String[] args) {
        Shop shop;
        GameSession session;
        if (!player.hasPermission("arena.admin")) {
            Msg.error((CommandSender)player, "No permission.");
            return;
        }
        if (args.length < 3) {
            Msg.error((CommandSender)player, "Usage: /game create <arena> <mode> [difficulty]");
            return;
        }
        Arena arena = this.plugin.getArenaManager().get(args[1]);
        if (arena == null) {
            Msg.error((CommandSender)player, "Arena not found.");
            return;
        }
        if (!arena.isEnabled()) {
            Msg.error((CommandSender)player, "Arena is not enabled.");
            return;
        }
        GameMode mode = GameMode.fromName(args[2]);
        Difficulty difficulty = Difficulty.NORMAL;
        if (args.length >= 4) {
            difficulty = Difficulty.fromName(args[3]);
        }
        if ((session = this.plugin.getGameManager().createSession(arena, mode)) == null) {
            Msg.error((CommandSender)player, "Failed to create game. Arena may be busy.");
            return;
        }
        session.setDifficulty(difficulty);
        if (arena.getShopId() != null && (shop = this.plugin.getShopManager().get(arena.getShopId())) != null) {
            session.setShop(shop);
        }
        this.plugin.getGameManager().joinSession(player, session);
        Msg.success((CommandSender)player, "Created " + Msg.accent(mode.getDisplay()) + " game in " + Msg.accent(arena.getName()) + "!");
        Msg.send((CommandSender)player, "Difficulty: " + difficulty.getFormatted());
        Msg.send((CommandSender)player, "Players can join with " + Msg.accent("/game join " + arena.getId()));
    }

    private void handleJoin(Player player, String[] args) {
        if (this.plugin.getGameManager().isInGame(player.getUniqueId())) {
            Msg.error((CommandSender)player, "You're already in a game.");
            return;
        }
        GameSession session = null;
        if (args.length >= 2) {
            Arena arena = this.plugin.getArenaManager().get(args[1]);
            if (arena == null) {
                Msg.error((CommandSender)player, "Arena not found.");
                return;
            }
            session = this.plugin.getGameManager().getArenaSession(arena.getId());
        } else {
            Collection<GameSession> sessions = this.plugin.getGameManager().getActiveSessions();
            for (GameSession s : sessions) {
                if (s.getState() != GameSession.State.WAITING) continue;
                session = s;
                break;
            }
        }
        if (session == null) {
            Msg.error((CommandSender)player, "No available games. Create one with /game create.");
            return;
        }
        if (session.getState() != GameSession.State.WAITING) {
            Msg.error((CommandSender)player, "Game already in progress.");
            return;
        }
        if (this.plugin.getGameManager().joinSession(player, session)) {
            Msg.success((CommandSender)player, "Joined game in " + Msg.accent(session.getArena().getName()) + "!");
        } else {
            Msg.error((CommandSender)player, "Failed to join game.");
        }
    }

    private void handleLeave(Player player) {
        if (!this.plugin.getGameManager().isInGame(player.getUniqueId())) {
            Msg.error((CommandSender)player, "You're not in a game.");
            return;
        }
        this.plugin.getGameManager().leaveSession(player);
        Msg.success((CommandSender)player, "Left the game.");
    }

    private void handleStart(Player player) {
        GameSession session = this.plugin.getGameManager().getPlayerSession(player.getUniqueId());
        if (session == null) {
            Msg.error((CommandSender)player, "You're not in a game.");
            return;
        }
        if (session.getState() != GameSession.State.WAITING) {
            Msg.error((CommandSender)player, "Game already started.");
            return;
        }
        if (session.getPlayerCount() < session.getMode().getMinPlayers()) {
            Msg.error((CommandSender)player, "Need at least " + session.getMode().getMinPlayers() + " players.");
            return;
        }
        session.start();
    }

    private void handleStop(Player player) {
        if (!player.hasPermission("arena.admin")) {
            Msg.error((CommandSender)player, "No permission.");
            return;
        }
        GameSession session = this.plugin.getGameManager().getPlayerSession(player.getUniqueId());
        if (session == null) {
            Msg.error((CommandSender)player, "You're not in a game.");
            return;
        }
        session.end();
        Msg.send((CommandSender)player, "Game ended.");
    }

    private void handleShop(Player player) {
        GameSession session = this.plugin.getGameManager().getPlayerSession(player.getUniqueId());
        if (session == null) {
            Msg.error((CommandSender)player, "You're not in a game.");
            return;
        }
        Shop shop = session.getShop();
        if (shop == null) {
            shop = this.plugin.getShopManager().getDefault();
        }
        if (shop == null) {
            Msg.error((CommandSender)player, "No shop available.");
            return;
        }
        this.plugin.getShopGUI().open(player, shop);
    }

    private void handlePoints(Player player) {
        GameSession session = this.plugin.getGameManager().getPlayerSession(player.getUniqueId());
        if (session == null) {
            Msg.error((CommandSender)player, "You're not in a game.");
            return;
        }
        int points = session.getPoints().getPoints(player.getUniqueId());
        int kills = session.getKills(player.getUniqueId());
        Msg.raw((CommandSender)player, "");
        Msg.info((CommandSender)player, "Your Stats");
        Msg.send((CommandSender)player, "Points: " + Msg.accent(String.valueOf(points)));
        Msg.send((CommandSender)player, "Kills: " + Msg.accent(String.valueOf(kills)));
        Msg.send((CommandSender)player, "Wave: " + Msg.accent(String.valueOf(session.getCurrentWave())));
        Msg.raw((CommandSender)player, "");
    }

    private void handleList(Player player) {
        Collection<GameSession> sessions = this.plugin.getGameManager().getActiveSessions();
        if (sessions.isEmpty()) {
            Msg.send((CommandSender)player, "No active games.");
            return;
        }
        Msg.raw((CommandSender)player, "");
        Msg.info((CommandSender)player, "Active Games (" + sessions.size() + ")");
        for (GameSession session : sessions) {
            String status = switch (session.getState()) {
                default -> throw new MatchException(null, null);
                case GameSession.State.WAITING -> String.valueOf(Msg.HIGHLIGHT) + "Waiting";
                case GameSession.State.COUNTDOWN -> String.valueOf(Msg.HIGHLIGHT) + "Starting";
                case GameSession.State.ACTIVE -> String.valueOf(Msg.SUCCESS) + "Active";
                case GameSession.State.PAUSED -> String.valueOf(Msg.SECONDARY) + "Paused";
                case GameSession.State.ENDING -> String.valueOf(Msg.ERROR) + "Ending";
            };
            Msg.raw((CommandSender)player, String.valueOf(Msg.SECONDARY) + " " + session.getArena().getName() + " " + String.valueOf(Msg.HIGHLIGHT) + "(" + session.getMode().getDisplay() + ")" + String.valueOf(Msg.SECONDARY) + " - " + status + String.valueOf(Msg.SECONDARY) + " [" + session.getPlayerCount() + "/" + session.getMode().getMaxPlayers() + "]");
        }
        Msg.raw((CommandSender)player, "");
    }

    private void handleInfo(Player player) {
        GameSession session = this.plugin.getGameManager().getPlayerSession(player.getUniqueId());
        if (session == null) {
            Msg.error((CommandSender)player, "You're not in a game.");
            return;
        }
        Msg.raw((CommandSender)player, "");
        Msg.info((CommandSender)player, "Game Info");
        Msg.send((CommandSender)player, "Arena: " + Msg.accent(session.getArena().getName()));
        Msg.send((CommandSender)player, "Mode: " + Msg.accent(session.getMode().getDisplay()));
        Msg.send((CommandSender)player, "State: " + Msg.accent(session.getState().name()));
        Msg.send((CommandSender)player, "Players: " + Msg.accent(session.getPlayerCount() + "/" + session.getMode().getMaxPlayers()));
        Msg.send((CommandSender)player, "Wave: " + Msg.accent(String.valueOf(session.getCurrentWave())));
        Msg.send((CommandSender)player, "Time: " + Msg.accent(this.formatTime(session.getTimeElapsed())));
        Msg.raw((CommandSender)player, "");
    }

    private void handleModes(Player player) {
        Msg.raw((CommandSender)player, "");
        Msg.info((CommandSender)player, "Game Modes");
        for (GameMode mode : GameMode.values()) {
            Msg.raw((CommandSender)player, String.valueOf(Msg.SECONDARY) + " " + mode.name() + " " + String.valueOf(Msg.HIGHLIGHT) + "- " + mode.getDisplay() + " (" + mode.getMinPlayers() + "-" + mode.getMaxPlayers() + " players)" + (String)(mode.isWavesEnabled() ? String.valueOf(Msg.SUCCESS) + " [WAVES]" : ""));
        }
        Msg.raw((CommandSender)player, "");
    }

    private void handleDifficulty(Player player, String[] args) {
        GameSession session = this.plugin.getGameManager().getPlayerSession(player.getUniqueId());
        if (session == null) {
            Msg.error((CommandSender)player, "You're not in a game.");
            return;
        }
        if (session.getState() != GameSession.State.WAITING) {
            Msg.error((CommandSender)player, "Can only change difficulty before starting.");
            return;
        }
        if (args.length < 2) {
            Msg.raw((CommandSender)player, "");
            Msg.info((CommandSender)player, "Difficulties");
            for (Difficulty diff : Difficulty.values()) {
                Msg.raw((CommandSender)player, " " + String.valueOf(diff.getColor()) + diff.name() + String.valueOf(Msg.SECONDARY) + " - HP: " + String.format("%.0f%%", diff.getHealthMult() * 100.0) + ", DMG: " + String.format("%.0f%%", diff.getDamageMult() * 100.0) + ", Points: " + String.format("%.0f%%", diff.getPointsMult() * 100.0) + ", Lives: " + String.valueOf(diff.getStartingLives() == 0 ? "None" : Integer.valueOf(diff.getStartingLives())));
            }
            Msg.raw((CommandSender)player, "");
            Msg.send((CommandSender)player, "Current: " + session.getDifficulty().getFormatted());
            return;
        }
        Difficulty diff = Difficulty.fromName(args[1]);
        session.setDifficulty(diff);
        Msg.success((CommandSender)player, "Difficulty set to " + diff.getFormatted());
    }

    private String formatTime(int seconds) {
        int mins = seconds / 60;
        int secs = seconds % 60;
        return String.format("%02d:%02d", mins, secs);
    }

    public List<String> onTabComplete(CommandSender sender, Command cmd, String label, String[] args) {
        List<String> completions = new ArrayList<String>();
        if (args.length == 1) {
            List<String> subs = Arrays.asList("create", "join", "leave", "start", "stop", "difficulty", "shop", "points", "list", "info", "modes");
            completions = subs.stream().filter(s -> s.startsWith(args[0].toLowerCase())).collect(Collectors.toList());
        } else if (args.length == 2) {
            String sub = args[0].toLowerCase();
            if (sub.equals("create") || sub.equals("join")) {
                completions = this.plugin.getArenaManager().getAll().stream().filter(Arena::isEnabled).map(Arena::getId).filter(id -> id.startsWith(args[1].toLowerCase())).collect(Collectors.toList());
            } else if (sub.equals("difficulty")) {
                completions = Arrays.stream(Difficulty.values()).map(Enum::name).filter(n -> n.toLowerCase().startsWith(args[1].toLowerCase())).collect(Collectors.toList());
            }
        } else if (args.length == 3) {
            if (args[0].equalsIgnoreCase("create")) {
                completions = Arrays.stream(GameMode.values()).map(Enum::name).filter(n -> n.toLowerCase().startsWith(args[2].toLowerCase())).collect(Collectors.toList());
            }
        } else if (args.length == 4 && args[0].equalsIgnoreCase("create")) {
            completions = Arrays.stream(Difficulty.values()).map(Enum::name).filter(n -> n.toLowerCase().startsWith(args[3].toLowerCase())).collect(Collectors.toList());
        }
        return completions;
    }
}

