/*
 * Decompiled with CFR 0.152.
 */
package AM.arenaMaker.cmd;

import AM.arenaMaker.ArenaMaker;
import AM.arenaMaker.kit.Kit;
import AM.arenaMaker.util.Msg;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabCompleter;
import org.bukkit.entity.Player;

public class KitCmd
implements CommandExecutor,
TabCompleter {
    private final ArenaMaker plugin;

    public KitCmd(ArenaMaker plugin) {
        this.plugin = plugin;
    }

    public boolean onCommand(CommandSender sender, Command cmd, String label, String[] args) {
        String sub;
        if (!(sender instanceof Player)) {
            Msg.error(sender, "Only players can use this.");
            return true;
        }
        Player player = (Player)sender;
        if (!player.hasPermission("arena.admin")) {
            Msg.error((CommandSender)player, "No permission.");
            return true;
        }
        if (args.length == 0) {
            this.showHelp(player);
            return true;
        }
        switch (sub = args[0].toLowerCase()) {
            case "create": {
                this.handleCreate(player, args);
                break;
            }
            case "delete": {
                this.handleDelete(player, args);
                break;
            }
            case "save": {
                this.handleSave(player, args);
                break;
            }
            case "load": 
            case "preview": {
                this.handleLoad(player, args);
                break;
            }
            case "list": {
                this.handleList(player);
                break;
            }
            case "seticon": {
                this.handleSetIcon(player, args);
                break;
            }
            case "rename": {
                this.handleRename(player, args);
                break;
            }
            default: {
                this.showHelp(player);
            }
        }
        return true;
    }

    private void showHelp(Player player) {
        Msg.raw((CommandSender)player, "");
        Msg.info((CommandSender)player, "Kit Commands");
        Msg.raw((CommandSender)player, String.valueOf(Msg.SECONDARY) + " /kit create <id> " + String.valueOf(Msg.HIGHLIGHT) + "- Create kit");
        Msg.raw((CommandSender)player, String.valueOf(Msg.SECONDARY) + " /kit delete <id> " + String.valueOf(Msg.HIGHLIGHT) + "- Delete kit");
        Msg.raw((CommandSender)player, String.valueOf(Msg.SECONDARY) + " /kit save <id> " + String.valueOf(Msg.HIGHLIGHT) + "- Save your inventory as kit");
        Msg.raw((CommandSender)player, String.valueOf(Msg.SECONDARY) + " /kit load <id> " + String.valueOf(Msg.HIGHLIGHT) + "- Preview kit");
        Msg.raw((CommandSender)player, String.valueOf(Msg.SECONDARY) + " /kit list " + String.valueOf(Msg.HIGHLIGHT) + "- List all kits");
        Msg.raw((CommandSender)player, String.valueOf(Msg.SECONDARY) + " /kit seticon <id> <material> " + String.valueOf(Msg.HIGHLIGHT) + "- Set kit icon");
        Msg.raw((CommandSender)player, String.valueOf(Msg.SECONDARY) + " /kit rename <id> <name> " + String.valueOf(Msg.HIGHLIGHT) + "- Rename kit");
        Msg.raw((CommandSender)player, "");
    }

    private void handleCreate(Player player, String[] args) {
        if (args.length < 2) {
            Msg.error((CommandSender)player, "Usage: /kit create <id>");
            return;
        }
        String id = args[1];
        if (this.plugin.getKitManager().exists(id)) {
            Msg.error((CommandSender)player, "Kit already exists.");
            return;
        }
        Kit kit = this.plugin.getKitManager().createFromPlayer(id, player);
        if (kit == null) {
            Msg.error((CommandSender)player, "Failed to create kit.");
            return;
        }
        Msg.success((CommandSender)player, "Created kit " + Msg.accent(id) + " from your inventory.");
    }

    private void handleDelete(Player player, String[] args) {
        if (args.length < 2) {
            Msg.error((CommandSender)player, "Usage: /kit delete <id>");
            return;
        }
        String id = args[1];
        if (!this.plugin.getKitManager().delete(id)) {
            Msg.error((CommandSender)player, "Kit not found.");
            return;
        }
        Msg.success((CommandSender)player, "Deleted kit " + Msg.accent(id) + ".");
    }

    private void handleSave(Player player, String[] args) {
        if (args.length < 2) {
            Msg.error((CommandSender)player, "Usage: /kit save <id>");
            return;
        }
        String id = args[1];
        Kit kit = this.plugin.getKitManager().get(id);
        if (kit == null) {
            kit = this.plugin.getKitManager().createFromPlayer(id, player);
        } else {
            kit.loadFromPlayer(player);
            this.plugin.getKitManager().save();
        }
        Msg.success((CommandSender)player, "Saved your inventory to kit " + Msg.accent(id) + ".");
    }

    private void handleLoad(Player player, String[] args) {
        if (args.length < 2) {
            Msg.error((CommandSender)player, "Usage: /kit load <id>");
            return;
        }
        Kit kit = this.plugin.getKitManager().get(args[1]);
        if (kit == null) {
            Msg.error((CommandSender)player, "Kit not found.");
            return;
        }
        kit.apply(player);
        Msg.success((CommandSender)player, "Applied kit " + Msg.accent(kit.getName()) + ".");
    }

    private void handleList(Player player) {
        Collection<Kit> kits = this.plugin.getKitManager().getAll();
        if (kits.isEmpty()) {
            Msg.send((CommandSender)player, "No kits created yet.");
            return;
        }
        Msg.raw((CommandSender)player, "");
        Msg.info((CommandSender)player, "Kits (" + kits.size() + ")");
        for (Kit kit : kits) {
            Msg.raw((CommandSender)player, String.valueOf(Msg.SECONDARY) + " - " + kit.getId() + " " + String.valueOf(Msg.HIGHLIGHT) + "(" + kit.getName() + ")");
        }
        Msg.raw((CommandSender)player, "");
    }

    private void handleSetIcon(Player player, String[] args) {
        if (args.length < 3) {
            Msg.error((CommandSender)player, "Usage: /kit seticon <id> <material>");
            return;
        }
        Kit kit = this.plugin.getKitManager().get(args[1]);
        if (kit == null) {
            Msg.error((CommandSender)player, "Kit not found.");
            return;
        }
        kit.setIcon(args[2].toUpperCase());
        this.plugin.getKitManager().save();
        Msg.success((CommandSender)player, "Set icon for " + Msg.accent(kit.getId()) + ".");
    }

    private void handleRename(Player player, String[] args) {
        if (args.length < 3) {
            Msg.error((CommandSender)player, "Usage: /kit rename <id> <name>");
            return;
        }
        Kit kit = this.plugin.getKitManager().get(args[1]);
        if (kit == null) {
            Msg.error((CommandSender)player, "Kit not found.");
            return;
        }
        String name = String.join((CharSequence)" ", Arrays.copyOfRange(args, 2, args.length));
        kit.setName(name);
        this.plugin.getKitManager().save();
        Msg.success((CommandSender)player, "Renamed kit to " + Msg.accent(name) + ".");
    }

    public List<String> onTabComplete(CommandSender sender, Command cmd, String label, String[] args) {
        List<String> completions = new ArrayList<String>();
        if (args.length == 1) {
            List<String> subs = Arrays.asList("create", "delete", "save", "load", "list", "seticon", "rename");
            completions = subs.stream().filter(s -> s.startsWith(args[0].toLowerCase())).collect(Collectors.toList());
        } else if (args.length == 2) {
            String sub = args[0].toLowerCase();
            if (Arrays.asList("delete", "save", "load", "seticon", "rename").contains(sub)) {
                completions = this.plugin.getKitManager().getAll().stream().map(Kit::getId).filter(id -> id.startsWith(args[1].toLowerCase())).collect(Collectors.toList());
            }
        }
        return completions;
    }
}

