/*
 * Decompiled with CFR 0.152.
 */
package AM.arenaMaker.cmd;

import AM.arenaMaker.ArenaMaker;
import AM.arenaMaker.arena.Arena;
import AM.arenaMaker.arena.Preset;
import AM.arenaMaker.util.Msg;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.bukkit.Location;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.block.Action;
import org.bukkit.event.player.AsyncPlayerChatEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.plugin.Plugin;

public class MakerMode
implements Listener {
    private final ArenaMaker plugin;
    private final Map<UUID, MakerSession> sessions;

    public MakerMode(ArenaMaker plugin) {
        this.plugin = plugin;
        this.sessions = new HashMap<UUID, MakerSession>();
        plugin.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)plugin);
    }

    public boolean isInMode(Player player) {
        return this.sessions.containsKey(player.getUniqueId());
    }

    public void enter(Player player) {
        this.sessions.put(player.getUniqueId(), new MakerSession());
        Msg.title(player, "Arena Maker", "Wizard mode active");
        Msg.raw((CommandSender)player, "");
        Msg.info((CommandSender)player, "Arena Maker Wizard");
        Msg.send((CommandSender)player, "Type the arena name in chat:");
        Msg.raw((CommandSender)player, "");
    }

    public void exit(Player player) {
        this.sessions.remove(player.getUniqueId());
        this.plugin.getVisualizer().stop(player);
        Msg.send((CommandSender)player, "Exited maker mode.");
    }

    @EventHandler
    public void onChat(AsyncPlayerChatEvent event) {
        Player player = event.getPlayer();
        MakerSession session = this.sessions.get(player.getUniqueId());
        if (session == null) {
            return;
        }
        event.setCancelled(true);
        String msg = event.getMessage().toLowerCase().trim();
        this.plugin.getServer().getScheduler().runTask((Plugin)this.plugin, () -> this.handleInput(player, session, msg));
    }

    private void handleInput(Player player, MakerSession session, String input) {
        switch (session.step) {
            case 0: {
                if (this.plugin.getArenaManager().exists(input)) {
                    Msg.error((CommandSender)player, "Arena exists. Try another name:");
                    return;
                }
                session.arenaId = input;
                session.step = 1;
                Msg.success((CommandSender)player, "Name set: " + Msg.accent(input));
                this.showPresets(player);
                break;
            }
            case 1: {
                Preset preset = Preset.fromName(input);
                if (preset == null) {
                    Msg.error((CommandSender)player, "Invalid preset. Try again:");
                    return;
                }
                session.preset = preset;
                session.step = 2;
                Msg.success((CommandSender)player, "Preset: " + Msg.accent(preset.getDisplay()));
                Msg.send((CommandSender)player, "");
                Msg.send((CommandSender)player, "Left-click to set " + Msg.accent("Position 1"));
                break;
            }
        }
    }

    @EventHandler
    public void onInteract(PlayerInteractEvent event) {
        Player player = event.getPlayer();
        MakerSession session = this.sessions.get(player.getUniqueId());
        if (session == null || session.step < 2) {
            return;
        }
        Action action = event.getAction();
        if (action != Action.LEFT_CLICK_BLOCK && action != Action.RIGHT_CLICK_BLOCK) {
            return;
        }
        event.setCancelled(true);
        Location loc = event.getClickedBlock().getLocation();
        switch (session.step) {
            case 2: {
                if (action != Action.LEFT_CLICK_BLOCK) break;
                session.pos1 = loc;
                session.step = 3;
                Msg.success((CommandSender)player, "Position 1 set.");
                Msg.send((CommandSender)player, "Right-click to set " + Msg.accent("Position 2"));
                this.plugin.getVisualizer().showCorner(player, loc);
                break;
            }
            case 3: {
                if (action != Action.RIGHT_CLICK_BLOCK) break;
                session.pos2 = loc;
                session.step = 4;
                Msg.success((CommandSender)player, "Position 2 set.");
                Msg.send((CommandSender)player, "Left-click to set " + Msg.accent("Spawn 1"));
                this.plugin.getVisualizer().showBounds(player, session.pos1, session.pos2);
                break;
            }
            case 4: {
                if (action != Action.LEFT_CLICK_BLOCK) break;
                session.spawn1 = player.getLocation();
                session.step = 5;
                Msg.success((CommandSender)player, "Spawn 1 set.");
                Msg.send((CommandSender)player, "Right-click to set " + Msg.accent("Spawn 2"));
                this.plugin.getVisualizer().showBoundsWithSpawn(player, session.pos1, session.pos2, session.spawn1);
                break;
            }
            case 5: {
                if (action != Action.RIGHT_CLICK_BLOCK) break;
                session.spawn2 = player.getLocation();
                session.step = 6;
                Msg.success((CommandSender)player, "Spawn 2 set.");
                this.plugin.getVisualizer().stop(player);
                this.completeArena(player, session);
            }
        }
    }

    private void showPresets(Player player) {
        Msg.send((CommandSender)player, "Choose a preset:");
        for (Preset p : Preset.values()) {
            if (p == Preset.CUSTOM) {
                Msg.raw((CommandSender)player, String.valueOf(Msg.SECONDARY) + " " + p.name().toLowerCase() + String.valueOf(Msg.HIGHLIGHT) + " - Your own size");
                continue;
            }
            Msg.raw((CommandSender)player, String.valueOf(Msg.SECONDARY) + " " + p.name().toLowerCase() + String.valueOf(Msg.HIGHLIGHT) + " - " + p.getSizeX() + "x" + p.getSizeZ());
        }
    }

    private void completeArena(Player player, MakerSession session) {
        Arena arena = this.plugin.getArenaManager().create(session.arenaId);
        if (arena == null) {
            Msg.error((CommandSender)player, "Failed to create arena.");
            this.sessions.remove(player.getUniqueId());
            return;
        }
        arena.setPreset(session.preset);
        arena.setPos1(session.pos1);
        arena.setPos2(session.pos2);
        arena.setSpawn1(session.spawn1);
        arena.setSpawn2(session.spawn2);
        arena.setLobby(player.getLocation());
        if (this.plugin.getWGHook().isEnabled()) {
            String regionId = this.plugin.getWGHook().createRegion(arena.getId(), session.pos1, session.pos2);
            arena.setRegionId(regionId);
        }
        arena.setEnabled(true);
        this.plugin.getArenaManager().save();
        this.sessions.remove(player.getUniqueId());
        Msg.raw((CommandSender)player, "");
        Msg.title(player, "Arena Created!", arena.getId());
        Msg.success((CommandSender)player, "Arena " + Msg.accent(arena.getId()) + " is ready!");
        Msg.raw((CommandSender)player, "");
    }

    @EventHandler
    public void onQuit(PlayerQuitEvent event) {
        this.sessions.remove(event.getPlayer().getUniqueId());
        this.plugin.getVisualizer().stop(event.getPlayer());
    }

    private static class MakerSession {
        int step = 0;
        String arenaId;
        Preset preset;
        Location pos1;
        Location pos2;
        Location spawn1;
        Location spawn2;

        private MakerSession() {
        }
    }
}

