/*
 * Decompiled with CFR 0.152.
 */
package AM.arenaMaker.data;

import java.util.UUID;
import org.bukkit.configuration.ConfigurationSection;

public class PlayerStats {
    private final UUID uuid;
    private int wins;
    private int losses;
    private int draws;
    private int streak;
    private int bestStreak;
    private double earnings;
    private double wagered;
    private int kills;
    private int deaths;

    public PlayerStats(UUID uuid) {
        this.uuid = uuid;
    }

    public UUID getUuid() {
        return this.uuid;
    }

    public int getWins() {
        return this.wins;
    }

    public void addWin() {
        ++this.wins;
        ++this.streak;
        if (this.streak > this.bestStreak) {
            this.bestStreak = this.streak;
        }
    }

    public int getLosses() {
        return this.losses;
    }

    public void addLoss() {
        ++this.losses;
        this.streak = 0;
    }

    public int getDraws() {
        return this.draws;
    }

    public void addDraw() {
        ++this.draws;
    }

    public int getStreak() {
        return this.streak;
    }

    public int getBestStreak() {
        return this.bestStreak;
    }

    public int getTotalMatches() {
        return this.wins + this.losses + this.draws;
    }

    public double getWinRate() {
        int total = this.getTotalMatches();
        if (total == 0) {
            return 0.0;
        }
        return (double)this.wins / (double)total * 100.0;
    }

    public double getKdr() {
        if (this.deaths == 0) {
            return this.kills;
        }
        return (double)this.kills / (double)this.deaths;
    }

    public double getEarnings() {
        return this.earnings;
    }

    public void addEarnings(double amount) {
        this.earnings += amount;
    }

    public double getWagered() {
        return this.wagered;
    }

    public void addWagered(double amount) {
        this.wagered += amount;
    }

    public int getKills() {
        return this.kills;
    }

    public void addKill() {
        ++this.kills;
    }

    public int getDeaths() {
        return this.deaths;
    }

    public void addDeath() {
        ++this.deaths;
    }

    public int getElo() {
        return 1000 + this.wins * 25 - this.losses * 20 + this.streak * 5;
    }

    public void save(ConfigurationSection section) {
        section.set("wins", (Object)this.wins);
        section.set("losses", (Object)this.losses);
        section.set("draws", (Object)this.draws);
        section.set("streak", (Object)this.streak);
        section.set("best-streak", (Object)this.bestStreak);
        section.set("earnings", (Object)this.earnings);
        section.set("wagered", (Object)this.wagered);
        section.set("kills", (Object)this.kills);
        section.set("deaths", (Object)this.deaths);
    }

    public static PlayerStats load(UUID uuid, ConfigurationSection section) {
        PlayerStats stats = new PlayerStats(uuid);
        stats.wins = section.getInt("wins", 0);
        stats.losses = section.getInt("losses", 0);
        stats.draws = section.getInt("draws", 0);
        stats.streak = section.getInt("streak", 0);
        stats.bestStreak = section.getInt("best-streak", 0);
        stats.earnings = section.getDouble("earnings", 0.0);
        stats.wagered = section.getDouble("wagered", 0.0);
        stats.kills = section.getInt("kills", 0);
        stats.deaths = section.getInt("deaths", 0);
        return stats;
    }
}

