/*
 * Decompiled with CFR 0.152.
 */
package AM.arenaMaker.data;

import AM.arenaMaker.ArenaMaker;
import AM.arenaMaker.data.PlayerStats;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Collectors;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Player;

public class StatsManager {
    private final ArenaMaker plugin;
    private final Map<UUID, PlayerStats> stats;
    private final File file;
    private FileConfiguration data;

    public StatsManager(ArenaMaker plugin) {
        this.plugin = plugin;
        this.stats = new HashMap<UUID, PlayerStats>();
        this.file = new File(plugin.getDataFolder(), "stats.yml");
        this.load();
    }

    public PlayerStats get(Player player) {
        return this.get(player.getUniqueId());
    }

    public PlayerStats get(UUID uuid) {
        return this.stats.computeIfAbsent(uuid, PlayerStats::new);
    }

    public List<PlayerStats> getTopByWins(int limit) {
        return this.stats.values().stream().sorted((a, b) -> Integer.compare(b.getWins(), a.getWins())).limit(limit).collect(Collectors.toList());
    }

    public List<PlayerStats> getTopByElo(int limit) {
        return this.stats.values().stream().sorted((a, b) -> Integer.compare(b.getElo(), a.getElo())).limit(limit).collect(Collectors.toList());
    }

    public List<PlayerStats> getTopByStreak(int limit) {
        return this.stats.values().stream().sorted((a, b) -> Integer.compare(b.getBestStreak(), a.getBestStreak())).limit(limit).collect(Collectors.toList());
    }

    public List<PlayerStats> getTopByEarnings(int limit) {
        return this.stats.values().stream().sorted((a, b) -> Double.compare(b.getEarnings(), a.getEarnings())).limit(limit).collect(Collectors.toList());
    }

    public int getRank(UUID uuid) {
        List sorted = this.stats.values().stream().sorted((a, b) -> Integer.compare(b.getElo(), a.getElo())).collect(Collectors.toList());
        for (int i = 0; i < sorted.size(); ++i) {
            if (!((PlayerStats)sorted.get(i)).getUuid().equals(uuid)) continue;
            return i + 1;
        }
        return sorted.size() + 1;
    }

    public void load() {
        this.stats.clear();
        if (!this.file.exists()) {
            this.data = new YamlConfiguration();
            return;
        }
        this.data = YamlConfiguration.loadConfiguration((File)this.file);
        ConfigurationSection section = this.data.getConfigurationSection("players");
        if (section == null) {
            return;
        }
        for (String key : section.getKeys(false)) {
            try {
                UUID uuid = UUID.fromString(key);
                ConfigurationSection playerSection = section.getConfigurationSection(key);
                if (playerSection == null) continue;
                this.stats.put(uuid, PlayerStats.load(uuid, playerSection));
            }
            catch (IllegalArgumentException illegalArgumentException) {}
        }
    }

    public void save() {
        this.data = new YamlConfiguration();
        for (Map.Entry<UUID, PlayerStats> entry : this.stats.entrySet()) {
            ConfigurationSection section = this.data.createSection("players." + entry.getKey().toString());
            entry.getValue().save(section);
        }
        try {
            this.data.save(this.file);
        }
        catch (IOException e) {
            this.plugin.getLogger().severe("Failed to save stats: " + e.getMessage());
        }
    }

    public void savePlayer(UUID uuid) {
        this.save();
    }
}

