/*
 * Decompiled with CFR 0.152.
 */
package AM.arenaMaker.duel;

import AM.arenaMaker.ArenaMaker;
import AM.arenaMaker.arena.Arena;
import AM.arenaMaker.duel.DuelMatch;
import AM.arenaMaker.duel.DuelRequest;
import AM.arenaMaker.kit.Kit;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.bukkit.entity.Player;

public class DuelManager {
    private final ArenaMaker plugin;
    private final Map<UUID, DuelRequest> pendingRequests;
    private final Map<String, DuelMatch> activeMatches;
    private final Map<UUID, String> playerMatches;
    private final Set<String> busyArenas;
    private int matchCounter;

    public DuelManager(ArenaMaker plugin) {
        this.plugin = plugin;
        this.pendingRequests = new HashMap<UUID, DuelRequest>();
        this.activeMatches = new HashMap<String, DuelMatch>();
        this.playerMatches = new HashMap<UUID, String>();
        this.busyArenas = new HashSet<String>();
        this.matchCounter = 0;
    }

    public boolean sendRequest(Player sender, Player target, Arena arena, Kit kit, double wager, int duration) {
        if (this.isInMatch(sender.getUniqueId()) || this.isInMatch(target.getUniqueId())) {
            return false;
        }
        if (this.isArenaBusy(arena.getId())) {
            return false;
        }
        this.cleanExpiredRequests();
        DuelRequest request = new DuelRequest(sender.getUniqueId(), target.getUniqueId(), arena, kit, wager, duration);
        this.pendingRequests.put(target.getUniqueId(), request);
        return true;
    }

    public DuelRequest getRequest(Player player) {
        this.cleanExpiredRequests();
        return this.pendingRequests.get(player.getUniqueId());
    }

    public DuelRequest getRequestFrom(Player sender, Player target) {
        DuelRequest request = this.pendingRequests.get(target.getUniqueId());
        if (request != null && request.getSender().equals(sender.getUniqueId())) {
            return request;
        }
        return null;
    }

    public boolean acceptRequest(Player player) {
        DuelRequest request = this.pendingRequests.remove(player.getUniqueId());
        if (request == null || request.isExpired()) {
            return false;
        }
        return this.startMatch(request);
    }

    public boolean denyRequest(Player player) {
        return this.pendingRequests.remove(player.getUniqueId()) != null;
    }

    public boolean startMatch(DuelRequest request) {
        if (this.isArenaBusy(request.getArena().getId())) {
            return false;
        }
        String matchId = "match_" + ++this.matchCounter;
        DuelMatch match = new DuelMatch(matchId, request.getArena(), request.getSender(), request.getTarget(), request.getKit(), request.getWager(), request.getDuration());
        this.activeMatches.put(matchId, match);
        this.playerMatches.put(request.getSender(), matchId);
        this.playerMatches.put(request.getTarget(), matchId);
        this.busyArenas.add(request.getArena().getId());
        match.start(this.plugin);
        return true;
    }

    public DuelMatch getMatch(String id) {
        return this.activeMatches.get(id);
    }

    public DuelMatch getPlayerMatch(UUID uuid) {
        String matchId = this.playerMatches.get(uuid);
        if (matchId == null) {
            return null;
        }
        return this.activeMatches.get(matchId);
    }

    public boolean isInMatch(UUID uuid) {
        return this.playerMatches.containsKey(uuid);
    }

    public boolean isArenaBusy(String arenaId) {
        return this.busyArenas.contains(arenaId);
    }

    public void endMatch(String matchId) {
        DuelMatch match = this.activeMatches.remove(matchId);
        if (match == null) {
            return;
        }
        this.playerMatches.remove(match.getPlayer1());
        this.playerMatches.remove(match.getPlayer2());
        this.busyArenas.remove(match.getArena().getId());
    }

    public void handleDeath(Player player, Player killer) {
        DuelMatch match = this.getPlayerMatch(player.getUniqueId());
        if (match == null) {
            return;
        }
        if (match.getState() != DuelMatch.State.ACTIVE) {
            return;
        }
        this.plugin.getStatsManager().get(player.getUniqueId()).addDeath();
        if (killer != null && match.isParticipant(killer.getUniqueId())) {
            this.plugin.getStatsManager().get(killer.getUniqueId()).addKill();
        }
        UUID winnerId = match.getOpponent(player.getUniqueId());
        match.endWithWinner(this.plugin, winnerId);
    }

    public void handleQuit(Player player) {
        this.pendingRequests.remove(player.getUniqueId());
        this.pendingRequests.values().removeIf(r -> r.getSender().equals(player.getUniqueId()));
        DuelMatch match = this.getPlayerMatch(player.getUniqueId());
        if (match != null && match.getState() == DuelMatch.State.ACTIVE) {
            UUID winnerId = match.getOpponent(player.getUniqueId());
            match.endWithWinner(this.plugin, winnerId);
        }
    }

    public Collection<DuelMatch> getActiveMatches() {
        return this.activeMatches.values();
    }

    public int getActiveMatchCount() {
        return this.activeMatches.size();
    }

    public Arena findAvailableArena() {
        for (Arena arena : this.plugin.getArenaManager().getAll()) {
            if (!arena.isEnabled() || this.isArenaBusy(arena.getId())) continue;
            return arena;
        }
        return null;
    }

    private void cleanExpiredRequests() {
        this.pendingRequests.values().removeIf(DuelRequest::isExpired);
    }
}

