/*
 * Decompiled with CFR 0.152.
 */
package AM.arenaMaker.duel;

import AM.arenaMaker.ArenaMaker;
import AM.arenaMaker.arena.Arena;
import AM.arenaMaker.kit.Kit;
import AM.arenaMaker.reward.Reward;
import AM.arenaMaker.util.Msg;
import AM.arenaMaker.util.PlayerState;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.GameMode;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.scheduler.BukkitTask;

public class DuelMatch {
    private static final long TICKS_PER_SEC = 20L;
    private static final int COUNTDOWN_SECS = 5;
    private static final int END_DELAY_TICKS = 60;
    private final String id;
    private final Arena arena;
    private final UUID player1;
    private final UUID player2;
    private final Kit kit;
    private final double wager;
    private final int duration;
    private State state;
    private long startTime;
    private int timeLeft;
    private UUID winner;
    private BukkitTask timerTask;

    public DuelMatch(String id, Arena arena, UUID player1, UUID player2, Kit kit, double wager, int duration) {
        this.id = id;
        this.arena = arena;
        this.player1 = player1;
        this.player2 = player2;
        this.kit = kit;
        this.wager = wager;
        this.duration = duration;
        this.state = State.WAITING;
    }

    public String getId() {
        return this.id;
    }

    public Arena getArena() {
        return this.arena;
    }

    public UUID getPlayer1() {
        return this.player1;
    }

    public UUID getPlayer2() {
        return this.player2;
    }

    public Kit getKit() {
        return this.kit;
    }

    public double getWager() {
        return this.wager;
    }

    public int getDuration() {
        return this.duration;
    }

    public State getState() {
        return this.state;
    }

    public UUID getWinner() {
        return this.winner;
    }

    public int getTimeLeft() {
        return this.timeLeft;
    }

    public boolean isParticipant(UUID uuid) {
        return this.player1.equals(uuid) || this.player2.equals(uuid);
    }

    public UUID getOpponent(UUID uuid) {
        return this.player1.equals(uuid) ? this.player2 : this.player1;
    }

    public void start(ArenaMaker plugin) {
        Player p1 = Bukkit.getPlayer((UUID)this.player1);
        Player p2 = Bukkit.getPlayer((UUID)this.player2);
        if (p1 == null || p2 == null) {
            this.cancel(plugin);
            return;
        }
        this.savePlayerState(p1);
        this.savePlayerState(p2);
        p1.teleport(this.arena.getSpawn1());
        p2.teleport(this.arena.getSpawn2());
        p1.setGameMode(GameMode.SURVIVAL);
        p2.setGameMode(GameMode.SURVIVAL);
        p1.getInventory().clear();
        p2.getInventory().clear();
        if (this.kit != null) {
            this.kit.apply(p1);
            this.kit.apply(p2);
        }
        p1.setHealth(p1.getMaxHealth());
        p2.setHealth(p2.getMaxHealth());
        p1.setFoodLevel(20);
        p2.setFoodLevel(20);
        this.state = State.COUNTDOWN;
        this.startCountdown(plugin, p1, p2);
    }

    private void startCountdown(final ArenaMaker plugin, final Player p1, final Player p2) {
        new BukkitRunnable(){
            int count = 5;

            public void run() {
                if (this.count <= 0) {
                    DuelMatch.this.state = State.ACTIVE;
                    DuelMatch.this.startTime = System.currentTimeMillis();
                    DuelMatch.this.timeLeft = DuelMatch.this.duration;
                    Msg.title(p1, "FIGHT!", "");
                    Msg.title(p2, "FIGHT!", "");
                    DuelMatch.this.startTimer(plugin);
                    this.cancel();
                    return;
                }
                Msg.title(p1, String.valueOf(this.count), "Get ready!");
                Msg.title(p2, String.valueOf(this.count), "Get ready!");
                --this.count;
            }
        }.runTaskTimer((Plugin)plugin, 0L, 20L);
    }

    private void startTimer(final ArenaMaker plugin) {
        this.timerTask = new BukkitRunnable(){

            public void run() {
                if (DuelMatch.this.state != State.ACTIVE) {
                    this.cancel();
                    return;
                }
                --DuelMatch.this.timeLeft;
                Player p1 = Bukkit.getPlayer((UUID)DuelMatch.this.player1);
                Player p2 = Bukkit.getPlayer((UUID)DuelMatch.this.player2);
                if (p1 != null) {
                    Msg.actionBar(p1, DuelMatch.this.formatTime(DuelMatch.this.timeLeft));
                }
                if (p2 != null) {
                    Msg.actionBar(p2, DuelMatch.this.formatTime(DuelMatch.this.timeLeft));
                }
                if (DuelMatch.this.timeLeft <= 10 && DuelMatch.this.timeLeft > 0) {
                    if (p1 != null) {
                        Msg.title(p1, String.valueOf(DuelMatch.this.timeLeft), "Time running out!");
                    }
                    if (p2 != null) {
                        Msg.title(p2, String.valueOf(DuelMatch.this.timeLeft), "Time running out!");
                    }
                }
                if (DuelMatch.this.timeLeft <= 0) {
                    DuelMatch.this.endDraw(plugin);
                    this.cancel();
                }
            }
        }.runTaskTimer((Plugin)plugin, 20L, 20L);
    }

    private String formatTime(int seconds) {
        int mins = seconds / 60;
        int secs = seconds % 60;
        return String.format("%02d:%02d", mins, secs);
    }

    public void endWithWinner(final ArenaMaker plugin, UUID winnerId) {
        if (this.state == State.ENDING) {
            return;
        }
        this.state = State.ENDING;
        this.winner = winnerId;
        if (this.timerTask != null) {
            this.timerTask.cancel();
        }
        UUID loserId = this.getOpponent(winnerId);
        Player winnerPlayer = Bukkit.getPlayer((UUID)winnerId);
        Player loserPlayer = Bukkit.getPlayer((UUID)loserId);
        plugin.getStatsManager().get(winnerId).addWin();
        plugin.getStatsManager().get(loserId).addLoss();
        if (this.wager > 0.0 && plugin.getVaultHook().isEnabled() && loserPlayer != null && winnerPlayer != null) {
            plugin.getVaultHook().transfer(loserPlayer, winnerPlayer, this.wager);
            plugin.getStatsManager().get(winnerId).addEarnings(this.wager);
        }
        plugin.getStatsManager().save();
        if (winnerPlayer != null) {
            Msg.title(winnerPlayer, "VICTORY!", (String)(this.wager > 0.0 ? "+" + plugin.getVaultHook().format(this.wager) : ""));
            Reward reward = plugin.getRewardManager().get("win");
            if (reward != null) {
                reward.give(winnerPlayer, plugin);
            }
        }
        if (loserPlayer != null) {
            Msg.title(loserPlayer, "DEFEAT", (String)(this.wager > 0.0 ? "-" + plugin.getVaultHook().format(this.wager) : ""));
        }
        new BukkitRunnable(){

            public void run() {
                DuelMatch.this.restoreAndCleanup(plugin);
            }
        }.runTaskLater((Plugin)plugin, 60L);
    }

    public void endDraw(final ArenaMaker plugin) {
        if (this.state == State.ENDING) {
            return;
        }
        this.state = State.ENDING;
        if (this.timerTask != null) {
            this.timerTask.cancel();
        }
        plugin.getStatsManager().get(this.player1).addDraw();
        plugin.getStatsManager().get(this.player2).addDraw();
        plugin.getStatsManager().save();
        Player p1 = Bukkit.getPlayer((UUID)this.player1);
        Player p2 = Bukkit.getPlayer((UUID)this.player2);
        if (p1 != null) {
            Msg.title(p1, "DRAW", "Time ran out!");
        }
        if (p2 != null) {
            Msg.title(p2, "DRAW", "Time ran out!");
        }
        new BukkitRunnable(){

            public void run() {
                DuelMatch.this.restoreAndCleanup(plugin);
            }
        }.runTaskLater((Plugin)plugin, 60L);
    }

    public void cancel(ArenaMaker plugin) {
        this.state = State.ENDING;
        if (this.timerTask != null) {
            this.timerTask.cancel();
        }
        this.restoreAndCleanup(plugin);
    }

    private void savePlayerState(Player player) {
        PlayerState.save(player);
    }

    private void restoreAndCleanup(ArenaMaker plugin) {
        PlayerState.restore(this.player1);
        PlayerState.restore(this.player2);
        plugin.getDuelManager().endMatch(this.id);
    }

    public static enum State {
        WAITING,
        COUNTDOWN,
        ACTIVE,
        ENDING;

    }
}

