/*
 * Decompiled with CFR 0.152.
 */
package AM.arenaMaker.duel;

import AM.arenaMaker.arena.Arena;
import AM.arenaMaker.kit.Kit;
import java.util.UUID;

public class DuelRequest {
    private final UUID sender;
    private final UUID target;
    private final Arena arena;
    private final Kit kit;
    private final double wager;
    private final long timestamp;
    private final int duration;

    public DuelRequest(UUID sender, UUID target, Arena arena, Kit kit, double wager, int duration) {
        this.sender = sender;
        this.target = target;
        this.arena = arena;
        this.kit = kit;
        this.wager = wager;
        this.duration = duration;
        this.timestamp = System.currentTimeMillis();
    }

    public UUID getSender() {
        return this.sender;
    }

    public UUID getTarget() {
        return this.target;
    }

    public Arena getArena() {
        return this.arena;
    }

    public Kit getKit() {
        return this.kit;
    }

    public double getWager() {
        return this.wager;
    }

    public int getDuration() {
        return this.duration;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public boolean isExpired() {
        return System.currentTimeMillis() - this.timestamp > 60000L;
    }
}

