/*
 * Decompiled with CFR 0.152.
 */
package AM.arenaMaker.game;

import org.bukkit.ChatColor;
import org.bukkit.Material;

public enum Difficulty {
    EASY("Easy", ChatColor.GREEN, Material.LIME_WOOL, 0.7, 0.6, 1.3, 0.8, 5),
    NORMAL("Normal", ChatColor.YELLOW, Material.YELLOW_WOOL, 1.0, 1.0, 1.0, 1.0, 3),
    HARD("Hard", ChatColor.RED, Material.RED_WOOL, 1.4, 1.3, 0.8, 1.2, 2),
    EXTREME("Extreme", ChatColor.DARK_RED, Material.BLACK_WOOL, 2.0, 1.8, 0.6, 1.5, 1),
    NIGHTMARE("Nightmare", ChatColor.DARK_PURPLE, Material.PURPLE_WOOL, 3.0, 2.5, 0.4, 2.0, 0);

    private final String display;
    private final ChatColor color;
    private final Material icon;
    private final double healthMult;
    private final double damageMult;
    private final double pointsMult;
    private final double priceMult;
    private final int startingLives;

    private Difficulty(String display, ChatColor color, Material icon, double healthMult, double damageMult, double pointsMult, double priceMult, int startingLives) {
        this.display = display;
        this.color = color;
        this.icon = icon;
        this.healthMult = healthMult;
        this.damageMult = damageMult;
        this.pointsMult = pointsMult;
        this.priceMult = priceMult;
        this.startingLives = startingLives;
    }

    public String getDisplay() {
        return this.display;
    }

    public ChatColor getColor() {
        return this.color;
    }

    public Material getIcon() {
        return this.icon;
    }

    public double getHealthMult() {
        return this.healthMult;
    }

    public double getDamageMult() {
        return this.damageMult;
    }

    public double getPointsMult() {
        return this.pointsMult;
    }

    public double getPriceMult() {
        return this.priceMult;
    }

    public int getStartingLives() {
        return this.startingLives;
    }

    public String getFormatted() {
        return String.valueOf(this.color) + this.display;
    }

    public static Difficulty fromName(String name) {
        for (Difficulty d : Difficulty.values()) {
            if (!d.name().equalsIgnoreCase(name)) continue;
            return d;
        }
        return NORMAL;
    }
}

