/*
 * Decompiled with CFR 0.152.
 */
package AM.arenaMaker.game;

import AM.arenaMaker.ArenaMaker;
import AM.arenaMaker.arena.Arena;
import AM.arenaMaker.game.GameMode;
import AM.arenaMaker.game.GameSession;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.bukkit.entity.Player;

public class GameManager {
    private final ArenaMaker plugin;
    private final Map<String, GameSession> sessions;
    private final Map<UUID, String> playerSessions;
    private final Map<String, String> arenaSessions;
    private int sessionCounter;

    public GameManager(ArenaMaker plugin) {
        this.plugin = plugin;
        this.sessions = new HashMap<String, GameSession>();
        this.playerSessions = new HashMap<UUID, String>();
        this.arenaSessions = new HashMap<String, String>();
        this.sessionCounter = 0;
    }

    public GameSession createSession(Arena arena, GameMode mode) {
        if (this.isArenaBusy(arena.getId())) {
            return null;
        }
        String sessionId = "game_" + ++this.sessionCounter;
        GameSession session = new GameSession(this.plugin, sessionId, arena, mode);
        this.sessions.put(sessionId, session);
        this.arenaSessions.put(arena.getId(), sessionId);
        return session;
    }

    public GameSession getSession(String id) {
        return this.sessions.get(id);
    }

    public GameSession getPlayerSession(UUID uuid) {
        String sessionId = this.playerSessions.get(uuid);
        if (sessionId == null) {
            return null;
        }
        return this.sessions.get(sessionId);
    }

    public GameSession getArenaSession(String arenaId) {
        String sessionId = this.arenaSessions.get(arenaId);
        return sessionId != null ? this.sessions.get(sessionId) : null;
    }

    public boolean isInGame(UUID uuid) {
        return this.playerSessions.containsKey(uuid);
    }

    public boolean isArenaBusy(String arenaId) {
        return this.arenaSessions.containsKey(arenaId);
    }

    public boolean joinSession(Player player, GameSession session) {
        if (this.isInGame(player.getUniqueId())) {
            return false;
        }
        if (session.join(player)) {
            this.playerSessions.put(player.getUniqueId(), session.getId());
            return true;
        }
        return false;
    }

    public void leaveSession(Player player) {
        String sessionId = this.playerSessions.remove(player.getUniqueId());
        if (sessionId == null) {
            return;
        }
        GameSession session = this.sessions.get(sessionId);
        if (session != null) {
            session.leave(player);
        }
    }

    public void endSession(String sessionId) {
        GameSession session = this.sessions.remove(sessionId);
        if (session == null) {
            return;
        }
        this.arenaSessions.remove(session.getArena().getId());
        for (UUID uuid : session.getPlayers()) {
            this.playerSessions.remove(uuid);
        }
    }

    public Collection<GameSession> getActiveSessions() {
        return this.sessions.values();
    }

    public int getActiveSessionCount() {
        return this.sessions.size();
    }

    public void handlePlayerQuit(Player player) {
        this.leaveSession(player);
    }
}

