/*
 * Decompiled with CFR 0.152.
 */
package AM.arenaMaker.game;

public enum GameMode {
    DUEL("1v1 Duel", 2, 2, false, false),
    FFA("Free For All", 2, 16, false, false),
    WAVES("Wave Survival", 1, 4, true, true),
    INFECTED("Infected", 4, 16, false, false),
    KOTH("King of the Hill", 2, 8, false, false),
    TDM("Team Deathmatch", 4, 16, false, false);

    private final String display;
    private final int minPlayers;
    private final int maxPlayers;
    private final boolean mobsEnabled;
    private final boolean wavesEnabled;

    private GameMode(String display, int minPlayers, int maxPlayers, boolean mobsEnabled, boolean wavesEnabled) {
        this.display = display;
        this.minPlayers = minPlayers;
        this.maxPlayers = maxPlayers;
        this.mobsEnabled = mobsEnabled;
        this.wavesEnabled = wavesEnabled;
    }

    public String getDisplay() {
        return this.display;
    }

    public int getMinPlayers() {
        return this.minPlayers;
    }

    public int getMaxPlayers() {
        return this.maxPlayers;
    }

    public boolean isMobsEnabled() {
        return this.mobsEnabled;
    }

    public boolean isWavesEnabled() {
        return this.wavesEnabled;
    }

    public static GameMode fromName(String name) {
        for (GameMode mode : GameMode.values()) {
            if (!mode.name().equalsIgnoreCase(name)) continue;
            return mode;
        }
        return DUEL;
    }
}

