/*
 * Decompiled with CFR 0.152.
 */
package AM.arenaMaker.game;

import AM.arenaMaker.ArenaMaker;
import AM.arenaMaker.arena.Arena;
import AM.arenaMaker.game.Difficulty;
import AM.arenaMaker.game.GameMode;
import AM.arenaMaker.game.PointsManager;
import AM.arenaMaker.game.Wave;
import AM.arenaMaker.game.WaveSpawner;
import AM.arenaMaker.reward.Reward;
import AM.arenaMaker.shop.Shop;
import AM.arenaMaker.util.Msg;
import AM.arenaMaker.util.PlayerState;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.scheduler.BukkitTask;

public class GameSession {
    private static final long TICKS_PER_SEC = 20L;
    private static final int COUNTDOWN_SECS = 5;
    private static final int START_POINTS = 500;
    private static final int WAVE_DELAY_TICKS = 100;
    private static final int END_DELAY_TICKS = 100;
    private static final int RESPAWN_DELAY_TICKS = 60;
    private final String id;
    private final Arena arena;
    private final GameMode mode;
    private final Set<UUID> players;
    private final Set<UUID> alive;
    private final Map<UUID, Integer> kills;
    private final Map<Integer, Wave> waves;
    private final PointsManager points;
    private State state;
    private WaveSpawner spawner;
    private Shop shop;
    private BukkitTask gameTask;
    private int timeElapsed;
    private int currentWave;
    private Difficulty difficulty;
    private int lives;
    private final ArenaMaker plugin;

    public GameSession(ArenaMaker plugin, String id, Arena arena, GameMode mode) {
        this.plugin = plugin;
        this.id = id;
        this.arena = arena;
        this.mode = mode;
        this.players = new HashSet<UUID>();
        this.alive = new HashSet<UUID>();
        this.kills = new HashMap<UUID, Integer>();
        this.waves = new HashMap<Integer, Wave>();
        this.points = new PointsManager(plugin);
        this.state = State.WAITING;
        this.shop = plugin.getShopManager().getDefault();
        this.difficulty = Difficulty.NORMAL;
        this.lives = this.difficulty.getStartingLives();
    }

    public String getId() {
        return this.id;
    }

    public Arena getArena() {
        return this.arena;
    }

    public GameMode getMode() {
        return this.mode;
    }

    public State getState() {
        return this.state;
    }

    public Set<UUID> getPlayers() {
        return this.players;
    }

    public Set<UUID> getAlive() {
        return this.alive;
    }

    public int getPlayerCount() {
        return this.players.size();
    }

    public boolean isPlayer(UUID uuid) {
        return this.players.contains(uuid);
    }

    public boolean isAlive(UUID uuid) {
        return this.alive.contains(uuid);
    }

    public int getKills(UUID uuid) {
        return this.kills.getOrDefault(uuid, 0);
    }

    public PointsManager getPoints() {
        return this.points;
    }

    public Shop getShop() {
        return this.shop;
    }

    public void setShop(Shop shop) {
        this.shop = shop;
    }

    public int getCurrentWave() {
        return this.currentWave;
    }

    public int getTimeElapsed() {
        return this.timeElapsed;
    }

    public Difficulty getDifficulty() {
        return this.difficulty;
    }

    public void setDifficulty(Difficulty difficulty) {
        this.difficulty = difficulty;
        this.lives = difficulty.getStartingLives();
    }

    public int getLives() {
        return this.lives;
    }

    public boolean useLive() {
        if (this.lives <= 0) {
            return false;
        }
        --this.lives;
        return true;
    }

    public double getHealthMult() {
        return this.difficulty.getHealthMult();
    }

    public double getDamageMult() {
        return this.difficulty.getDamageMult();
    }

    public double getPointsMult() {
        return this.difficulty.getPointsMult();
    }

    public double getPriceMult() {
        return this.difficulty.getPriceMult();
    }

    public Wave getWaveConfig(int wave) {
        return this.waves.get(wave);
    }

    public void setWaveConfig(int wave, Wave config) {
        this.waves.put(wave, config);
    }

    public boolean join(Player player) {
        if (this.state != State.WAITING) {
            return false;
        }
        if (this.players.size() >= this.mode.getMaxPlayers()) {
            return false;
        }
        if (this.players.contains(player.getUniqueId())) {
            return false;
        }
        this.savePlayerState(player);
        this.players.add(player.getUniqueId());
        this.alive.add(player.getUniqueId());
        this.kills.put(player.getUniqueId(), 0);
        player.teleport(this.arena.getLobby() != null ? this.arena.getLobby() : this.arena.getSpawn1());
        player.setGameMode(org.bukkit.GameMode.SURVIVAL);
        player.getInventory().clear();
        player.setHealth(player.getMaxHealth());
        player.setFoodLevel(20);
        this.broadcast(Msg.accent(player.getName()) + " joined! (" + this.players.size() + "/" + this.mode.getMaxPlayers() + ")");
        if (this.players.size() >= this.mode.getMinPlayers()) {
            this.broadcast("Enough players! Type " + Msg.accent("/game start") + " to begin.");
        }
        return true;
    }

    public void leave(Player player) {
        this.players.remove(player.getUniqueId());
        this.alive.remove(player.getUniqueId());
        this.restorePlayerState(player);
        this.points.resetSession(player.getUniqueId());
        this.plugin.getShopManager().resetPurchases(player.getUniqueId());
        this.broadcast(Msg.accent(player.getName()) + " left the game.");
        if (this.state == State.ACTIVE && this.alive.isEmpty()) {
            this.end();
        }
    }

    public void start() {
        if (this.state != State.WAITING) {
            return;
        }
        if (this.players.size() < this.mode.getMinPlayers()) {
            return;
        }
        this.state = State.COUNTDOWN;
        new BukkitRunnable(){
            int count = 5;

            public void run() {
                if (this.count <= 0) {
                    GameSession.this.beginGame();
                    this.cancel();
                    return;
                }
                for (UUID uuid : GameSession.this.players) {
                    Player p = Bukkit.getPlayer((UUID)uuid);
                    if (p == null) continue;
                    Msg.title(p, String.valueOf(this.count), "Get ready!");
                }
                --this.count;
            }
        }.runTaskTimer((Plugin)this.plugin, 0L, 20L);
    }

    private void beginGame() {
        this.state = State.ACTIVE;
        this.timeElapsed = 0;
        this.currentWave = 0;
        int i = 0;
        for (UUID uuid : this.players) {
            Location spawn;
            Player p = Bukkit.getPlayer((UUID)uuid);
            if (p == null) continue;
            Location location = spawn = i % 2 == 0 ? this.arena.getSpawn1() : this.arena.getSpawn2();
            if (spawn != null) {
                p.teleport(spawn);
            }
            Msg.title(p, "GO!", this.mode.getDisplay());
            this.points.addPoints(uuid, 500);
            ++i;
        }
        if (this.mode.isWavesEnabled()) {
            this.spawner = new WaveSpawner(this.plugin, this, this.arena);
            this.spawner.startNextWave();
        }
        this.gameTask = new BukkitRunnable(){

            public void run() {
                if (GameSession.this.state != State.ACTIVE) {
                    this.cancel();
                    return;
                }
                ++GameSession.this.timeElapsed;
                GameSession.this.updateScoreboard();
            }
        }.runTaskTimer((Plugin)this.plugin, 20L, 20L);
    }

    public void onWaveStart(int wave) {
        this.currentWave = wave;
        this.broadcast("Wave " + Msg.accent(String.valueOf(wave)) + " starting!");
        for (UUID uuid : this.players) {
            Player p = Bukkit.getPlayer((UUID)uuid);
            if (p == null || this.spawner == null) continue;
            Msg.title(p, "Wave " + wave, this.spawner.getAliveMobCount() + " enemies");
        }
    }

    public void onWaveComplete(int wave) {
        Wave config = this.getWaveConfig(wave);
        int baseBonus = config != null ? config.getBonusPoints() : wave * 50;
        int bonus = (int)((double)baseBonus * this.getPointsMult());
        this.broadcast("Wave " + Msg.accent(String.valueOf(wave)) + " complete! +" + bonus + " bonus points");
        for (UUID uuid : this.alive) {
            this.points.addPoints(uuid, bonus);
            Player p = Bukkit.getPlayer((UUID)uuid);
            if (p == null) continue;
            Msg.title(p, "Wave Complete!", "Shop: /game shop");
        }
        new BukkitRunnable(){

            public void run() {
                if (GameSession.this.state == State.ACTIVE) {
                    GameSession.this.spawner.startNextWave();
                }
            }
        }.runTaskLater((Plugin)this.plugin, 100L);
    }

    public void onMobKill(Player killer, int mobPoints) {
        if (!this.isPlayer(killer.getUniqueId())) {
            return;
        }
        this.kills.merge(killer.getUniqueId(), 1, Integer::sum);
        int adjusted = (int)((double)mobPoints * this.getPointsMult());
        this.points.addPoints(killer, adjusted, "Kill");
    }

    public void onPlayerDeath(Player player) {
        if (this.lives > 0) {
            this.useLive();
            this.broadcast(Msg.accent(player.getName()) + " died! Lives: " + this.lives);
            this.respawnPlayer(player);
            return;
        }
        this.alive.remove(player.getUniqueId());
        this.broadcast(Msg.accent(player.getName()) + " is out!");
        if (this.alive.isEmpty()) {
            this.end();
        }
    }

    private void respawnPlayer(final Player player) {
        new BukkitRunnable(){

            public void run() {
                if (GameSession.this.state != State.ACTIVE) {
                    return;
                }
                Location spawn = GameSession.this.arena.getSpawn1();
                if (spawn != null) {
                    player.teleport(spawn);
                }
                player.setHealth(player.getMaxHealth());
                player.setFoodLevel(20);
                Msg.title(player, "Respawned!", GameSession.this.lives + " lives left");
            }
        }.runTaskLater((Plugin)this.plugin, 60L);
    }

    public void end() {
        this.state = State.ENDING;
        if (this.gameTask != null) {
            this.gameTask.cancel();
        }
        if (this.spawner != null) {
            this.spawner.cleanup();
        }
        int highestWave = this.currentWave;
        UUID topKiller = null;
        int topKills = 0;
        for (Map.Entry<UUID, Integer> entry : this.kills.entrySet()) {
            if (entry.getValue() <= topKills) continue;
            topKills = entry.getValue();
            topKiller = entry.getKey();
        }
        String topName = topKiller != null ? Bukkit.getOfflinePlayer(topKiller).getName() : "Nobody";
        for (UUID uuid : this.players) {
            Player p = Bukkit.getPlayer((UUID)uuid);
            if (p == null) continue;
            Msg.title(p, "Game Over!", "Wave " + highestWave);
            Msg.raw((CommandSender)p, "");
            Msg.info((CommandSender)p, "Game Summary");
            Msg.send((CommandSender)p, "Waves: " + Msg.accent(String.valueOf(highestWave)));
            Msg.send((CommandSender)p, "Your Kills: " + Msg.accent(String.valueOf(this.kills.getOrDefault(uuid, 0))));
            Msg.send((CommandSender)p, "Your Points: " + Msg.accent(String.valueOf(this.points.getPoints(uuid))));
            Msg.send((CommandSender)p, "Top Killer: " + Msg.accent(topName) + " (" + topKills + ")");
            Msg.raw((CommandSender)p, "");
            this.plugin.getStatsManager().get(uuid).addWin();
            Reward reward = this.plugin.getRewardManager().get("win");
            if (reward == null) continue;
            reward.give(p, this.plugin);
        }
        new BukkitRunnable(){

            public void run() {
                GameSession.this.cleanup();
            }
        }.runTaskLater((Plugin)this.plugin, 100L);
    }

    private void cleanup() {
        for (UUID uuid : new HashSet<UUID>(this.players)) {
            Player p = Bukkit.getPlayer((UUID)uuid);
            if (p != null) {
                this.restorePlayerState(p);
            }
            this.points.resetSession(uuid);
            this.plugin.getShopManager().resetPurchases(uuid);
        }
        this.players.clear();
        this.alive.clear();
        this.kills.clear();
        this.plugin.getGameManager().endSession(this.id);
    }

    private void savePlayerState(Player player) {
        PlayerState.save(player);
    }

    private void restorePlayerState(Player player) {
        PlayerState.restore(player);
    }

    public Player getNearestPlayer(Location location) {
        Player nearest = null;
        double nearestDist = Double.MAX_VALUE;
        for (UUID uuid : this.alive) {
            double dist;
            Player p = Bukkit.getPlayer((UUID)uuid);
            if (p == null || !p.getWorld().equals((Object)location.getWorld()) || !((dist = p.getLocation().distanceSquared(location)) < nearestDist)) continue;
            nearestDist = dist;
            nearest = p;
        }
        return nearest;
    }

    private void broadcast(String message) {
        for (UUID uuid : this.players) {
            Player p = Bukkit.getPlayer((UUID)uuid);
            if (p == null) continue;
            Msg.send((CommandSender)p, message);
        }
    }

    private void updateScoreboard() {
        for (UUID uuid : this.players) {
            Player p = Bukkit.getPlayer((UUID)uuid);
            if (p == null) continue;
            StringBuilder info = new StringBuilder();
            info.append(this.difficulty.getColor()).append(this.difficulty.getDisplay()).append(" ");
            info.append("\u00a7f| Wave: ").append(this.currentWave);
            if (this.spawner != null) {
                info.append(" | Mobs: ").append(this.spawner.getAliveMobCount());
            }
            info.append(" | Points: ").append(this.points.getPoints(uuid));
            if (this.difficulty.getStartingLives() > 0) {
                info.append(" | Lives: ").append(this.lives);
            }
            Msg.actionBar(p, info.toString());
        }
    }

    public WaveSpawner getSpawner() {
        return this.spawner;
    }

    public static enum State {
        WAITING,
        COUNTDOWN,
        ACTIVE,
        PAUSED,
        ENDING;

    }
}

