/*
 * Decompiled with CFR 0.152.
 */
package AM.arenaMaker.game;

import org.bukkit.entity.EntityType;

public enum MobType {
    ZOMBIE(EntityType.ZOMBIE, "Zombie", 10, 20.0, 1.0),
    SKELETON(EntityType.SKELETON, "Skeleton", 15, 20.0, 1.0),
    SPIDER(EntityType.SPIDER, "Spider", 10, 16.0, 1.2),
    CREEPER(EntityType.CREEPER, "Creeper", 25, 20.0, 0.9),
    ENDERMAN(EntityType.ENDERMAN, "Enderman", 30, 40.0, 1.0),
    WITCH(EntityType.WITCH, "Witch", 20, 26.0, 1.0),
    BLAZE(EntityType.BLAZE, "Blaze", 25, 20.0, 1.0),
    WITHER_SKELETON(EntityType.WITHER_SKELETON, "Wither Skeleton", 35, 20.0, 1.0),
    PIGLIN_BRUTE(EntityType.PIGLIN_BRUTE, "Piglin Brute", 40, 50.0, 1.0),
    VINDICATOR(EntityType.VINDICATOR, "Vindicator", 30, 24.0, 1.0),
    RAVAGER(EntityType.RAVAGER, "Ravager", 100, 100.0, 0.8),
    WARDEN(EntityType.WARDEN, "Warden", 500, 500.0, 0.6);

    private final EntityType entityType;
    private final String display;
    private final int points;
    private final double baseHealth;
    private final double speedMult;

    private MobType(EntityType entityType, String display, int points, double baseHealth, double speedMult) {
        this.entityType = entityType;
        this.display = display;
        this.points = points;
        this.baseHealth = baseHealth;
        this.speedMult = speedMult;
    }

    public EntityType getEntityType() {
        return this.entityType;
    }

    public String getDisplay() {
        return this.display;
    }

    public int getPoints() {
        return this.points;
    }

    public double getBaseHealth() {
        return this.baseHealth;
    }

    public double getSpeedMult() {
        return this.speedMult;
    }

    public static MobType fromName(String name) {
        for (MobType type : MobType.values()) {
            if (!type.name().equalsIgnoreCase(name)) continue;
            return type;
        }
        return ZOMBIE;
    }
}

