/*
 * Decompiled with CFR 0.152.
 */
package AM.arenaMaker.game;

import AM.arenaMaker.ArenaMaker;
import AM.arenaMaker.util.Msg;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.bukkit.entity.Player;

public class PointsManager {
    private final ArenaMaker plugin;
    private final Map<UUID, Integer> sessionPoints;
    private final Map<UUID, Integer> totalPoints;

    public PointsManager(ArenaMaker plugin) {
        this.plugin = plugin;
        this.sessionPoints = new HashMap<UUID, Integer>();
        this.totalPoints = new HashMap<UUID, Integer>();
    }

    public int getPoints(UUID uuid) {
        return this.sessionPoints.getOrDefault(uuid, 0);
    }

    public int getTotalPoints(UUID uuid) {
        return this.totalPoints.getOrDefault(uuid, 0);
    }

    public void addPoints(Player player, int amount, String reason) {
        UUID uuid = player.getUniqueId();
        int current = this.sessionPoints.getOrDefault(uuid, 0);
        this.sessionPoints.put(uuid, current + amount);
        this.totalPoints.merge(uuid, amount, Integer::sum);
        Msg.actionBar(player, "+" + amount + " points (" + reason + ")");
    }

    public void addPoints(UUID uuid, int amount) {
        int current = this.sessionPoints.getOrDefault(uuid, 0);
        this.sessionPoints.put(uuid, current + amount);
        this.totalPoints.merge(uuid, amount, Integer::sum);
    }

    public boolean removePoints(Player player, int amount) {
        UUID uuid = player.getUniqueId();
        int current = this.sessionPoints.getOrDefault(uuid, 0);
        if (current < amount) {
            return false;
        }
        this.sessionPoints.put(uuid, current - amount);
        return true;
    }

    public boolean hasPoints(UUID uuid, int amount) {
        return this.sessionPoints.getOrDefault(uuid, 0) >= amount;
    }

    public void resetSession(UUID uuid) {
        this.sessionPoints.remove(uuid);
    }

    public void resetAll() {
        this.sessionPoints.clear();
    }

    private List<Map.Entry<UUID, Integer>> getSorted() {
        ArrayList<Map.Entry<UUID, Integer>> sorted = new ArrayList<Map.Entry<UUID, Integer>>(this.sessionPoints.entrySet());
        sorted.sort((a, b) -> ((Integer)b.getValue()).compareTo((Integer)a.getValue()));
        return sorted;
    }

    public List<Map.Entry<UUID, Integer>> getTopPoints(int limit) {
        List<Map.Entry<UUID, Integer>> sorted = this.getSorted();
        return sorted.subList(0, Math.min(limit, sorted.size()));
    }

    public int getRank(UUID uuid) {
        List<Map.Entry<UUID, Integer>> sorted = this.getSorted();
        for (int i = 0; i < sorted.size(); ++i) {
            if (!sorted.get(i).getKey().equals(uuid)) continue;
            return i + 1;
        }
        return -1;
    }
}

