/*
 * Decompiled with CFR 0.152.
 */
package AM.arenaMaker.game;

import AM.arenaMaker.game.MobType;
import java.util.HashMap;
import java.util.Map;
import org.bukkit.configuration.ConfigurationSection;

public class Wave {
    private final int number;
    private final Map<MobType, Integer> mobs;
    private final int delaySeconds;
    private final double healthMult;
    private final double damageMult;
    private final int bonusPoints;

    public Wave(int number) {
        this.number = number;
        this.mobs = new HashMap<MobType, Integer>();
        this.delaySeconds = 5;
        this.healthMult = 1.0 + (double)number * 0.1;
        this.damageMult = 1.0 + (double)number * 0.05;
        this.bonusPoints = number * 50;
    }

    public Wave(int number, Map<MobType, Integer> mobs, int delaySeconds, double healthMult, double damageMult, int bonusPoints) {
        this.number = number;
        this.mobs = mobs;
        this.delaySeconds = delaySeconds;
        this.healthMult = healthMult;
        this.damageMult = damageMult;
        this.bonusPoints = bonusPoints;
    }

    public int getNumber() {
        return this.number;
    }

    public Map<MobType, Integer> getMobs() {
        return this.mobs;
    }

    public void addMob(MobType type, int count) {
        this.mobs.put(type, this.mobs.getOrDefault((Object)type, 0) + count);
    }

    public int getTotalMobs() {
        return this.mobs.values().stream().mapToInt(Integer::intValue).sum();
    }

    public int getDelaySeconds() {
        return this.delaySeconds;
    }

    public double getHealthMult() {
        return this.healthMult;
    }

    public double getDamageMult() {
        return this.damageMult;
    }

    public int getBonusPoints() {
        return this.bonusPoints;
    }

    public void save(ConfigurationSection section) {
        section.set("delay", (Object)this.delaySeconds);
        section.set("health-mult", (Object)this.healthMult);
        section.set("damage-mult", (Object)this.damageMult);
        section.set("bonus-points", (Object)this.bonusPoints);
        for (Map.Entry<MobType, Integer> entry : this.mobs.entrySet()) {
            section.set("mobs." + entry.getKey().name(), (Object)entry.getValue());
        }
    }

    public static Wave load(int number, ConfigurationSection section) {
        HashMap<MobType, Integer> mobs = new HashMap<MobType, Integer>();
        ConfigurationSection mobSection = section.getConfigurationSection("mobs");
        if (mobSection != null) {
            for (String key : mobSection.getKeys(false)) {
                MobType type = MobType.fromName(key);
                mobs.put(type, mobSection.getInt(key));
            }
        }
        return new Wave(number, mobs, section.getInt("delay", 5), section.getDouble("health-mult", 1.0 + (double)number * 0.1), section.getDouble("damage-mult", 1.0 + (double)number * 0.05), section.getInt("bonus-points", number * 50));
    }

    public static Wave createDefault(int waveNum) {
        Wave wave = new Wave(waveNum);
        int baseCount = 3 + waveNum;
        wave.addMob(MobType.ZOMBIE, baseCount);
        if (waveNum >= 3) {
            wave.addMob(MobType.SKELETON, baseCount / 2);
        }
        if (waveNum >= 5) {
            wave.addMob(MobType.SPIDER, baseCount / 3);
        }
        if (waveNum >= 7) {
            wave.addMob(MobType.CREEPER, baseCount / 4);
        }
        if (waveNum >= 10) {
            wave.addMob(MobType.WITCH, 2);
        }
        if (waveNum >= 15) {
            wave.addMob(MobType.VINDICATOR, 2);
        }
        if (waveNum >= 20) {
            wave.addMob(MobType.RAVAGER, 1);
        }
        return wave;
    }
}

