/*
 * Decompiled with CFR 0.152.
 */
package AM.arenaMaker.game;

import AM.arenaMaker.ArenaMaker;
import AM.arenaMaker.arena.Arena;
import AM.arenaMaker.game.GameSession;
import AM.arenaMaker.game.MobType;
import AM.arenaMaker.game.Wave;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.UUID;
import org.bukkit.Location;
import org.bukkit.attribute.Attribute;
import org.bukkit.attribute.AttributeInstance;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Mob;
import org.bukkit.metadata.FixedMetadataValue;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;

public class WaveSpawner {
    private final ArenaMaker plugin;
    private final GameSession session;
    private final Arena arena;
    private final List<Location> spawnPoints;
    private final Set<UUID> aliveMobs;
    private int currentWave;
    private boolean spawning;

    public WaveSpawner(ArenaMaker plugin, GameSession session, Arena arena) {
        this.plugin = plugin;
        this.session = session;
        this.arena = arena;
        this.spawnPoints = new ArrayList<Location>(arena.getMobSpawns());
        this.aliveMobs = new HashSet<UUID>();
        this.currentWave = 0;
        this.spawning = false;
    }

    public void startNextWave() {
        if (this.spawning) {
            return;
        }
        ++this.currentWave;
        this.spawning = true;
        Wave wave = this.session.getWaveConfig(this.currentWave);
        if (wave == null) {
            wave = Wave.createDefault(this.currentWave);
        }
        this.session.onWaveStart(this.currentWave);
        final Wave finalWave = wave;
        new BukkitRunnable(){

            public void run() {
                WaveSpawner.this.spawnWave(finalWave);
            }
        }.runTaskLater((Plugin)this.plugin, (long)wave.getDelaySeconds() * 20L);
    }

    private void spawnWave(Wave wave) {
        if (this.spawnPoints.isEmpty()) {
            if (this.arena.getSpawn1() != null) {
                this.spawnPoints.add(this.arena.getSpawn1());
            }
            if (this.arena.getSpawn2() != null) {
                this.spawnPoints.add(this.arena.getSpawn2());
            }
        }
        if (this.spawnPoints.isEmpty()) {
            this.spawning = false;
            return;
        }
        Random random = new Random();
        for (Map.Entry<MobType, Integer> entry : wave.getMobs().entrySet()) {
            MobType type = entry.getKey();
            int count = entry.getValue();
            for (int i = 0; i < count; ++i) {
                Location spawn = this.spawnPoints.get(random.nextInt(this.spawnPoints.size()));
                spawn = spawn.clone().add(random.nextDouble() * 4.0 - 2.0, 0.0, random.nextDouble() * 4.0 - 2.0);
                this.spawnMob(type, spawn, wave);
            }
        }
        this.spawning = false;
    }

    private void spawnMob(MobType type, Location location, Wave wave) {
        Entity entity = location.getWorld().spawnEntity(location, type.getEntityType());
        if (entity instanceof LivingEntity) {
            LivingEntity living = (LivingEntity)entity;
            double diffMult = this.session.getHealthMult();
            double health = type.getBaseHealth() * wave.getHealthMult() * diffMult;
            living.getAttribute(Attribute.GENERIC_MAX_HEALTH).setBaseValue(health);
            living.setHealth(health);
            AttributeInstance attackAttr = living.getAttribute(Attribute.GENERIC_ATTACK_DAMAGE);
            if (attackAttr != null) {
                double baseDmg = attackAttr.getBaseValue();
                attackAttr.setBaseValue(baseDmg * this.session.getDamageMult());
            }
            living.setMetadata("arena_mob", (MetadataValue)new FixedMetadataValue((Plugin)this.plugin, (Object)this.session.getId()));
            living.setMetadata("mob_type", (MetadataValue)new FixedMetadataValue((Plugin)this.plugin, (Object)type.name()));
            living.setMetadata("mob_points", (MetadataValue)new FixedMetadataValue((Plugin)this.plugin, (Object)type.getPoints()));
            if (living instanceof Mob) {
                Mob mob = (Mob)living;
                mob.setTarget((LivingEntity)this.session.getNearestPlayer(location));
            }
            this.aliveMobs.add(entity.getUniqueId());
        }
    }

    public void onMobDeath(UUID mobId) {
        this.aliveMobs.remove(mobId);
        if (this.aliveMobs.isEmpty() && !this.spawning) {
            this.session.onWaveComplete(this.currentWave);
        }
    }

    public void cleanup() {
        for (UUID mobId : this.aliveMobs) {
            Entity entity = this.plugin.getServer().getEntity(mobId);
            if (entity == null) continue;
            entity.remove();
        }
        this.aliveMobs.clear();
    }

    public int getCurrentWave() {
        return this.currentWave;
    }

    public int getAliveMobCount() {
        return this.aliveMobs.size();
    }

    public boolean isSpawning() {
        return this.spawning;
    }

    public Set<UUID> getAliveMobs() {
        return this.aliveMobs;
    }
}

