/*
 * Decompiled with CFR 0.152.
 */
package AM.arenaMaker.gui;

import AM.arenaMaker.ArenaMaker;
import AM.arenaMaker.arena.Arena;
import AM.arenaMaker.arena.Preset;
import AM.arenaMaker.game.GameMode;
import AM.arenaMaker.game.GameSession;
import AM.arenaMaker.game.MobType;
import AM.arenaMaker.kit.Kit;
import AM.arenaMaker.shop.Shop;
import AM.arenaMaker.shop.ShopItem;
import AM.arenaMaker.shop.ShopTier;
import AM.arenaMaker.util.Msg;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.ClickType;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.plugin.Plugin;

public class AdminGUI
implements Listener {
    private final ArenaMaker plugin;
    private static final String MAIN_MENU = String.valueOf(ChatColor.DARK_AQUA) + "Arena Admin";
    private static final String ARENA_LIST = String.valueOf(ChatColor.DARK_AQUA) + "Manage Arenas";
    private static final String ARENA_EDIT = String.valueOf(ChatColor.DARK_AQUA) + "Edit Arena: ";
    private static final String ARENA_SETTINGS = String.valueOf(ChatColor.DARK_AQUA) + "Arena Settings: ";
    private static final String KIT_LIST = String.valueOf(ChatColor.DARK_AQUA) + "Manage Kits";
    private static final String KIT_EDIT = String.valueOf(ChatColor.DARK_AQUA) + "Edit Kit: ";
    private static final String SHOP_LIST = String.valueOf(ChatColor.DARK_AQUA) + "Manage Shops";
    private static final String SHOP_EDIT = String.valueOf(ChatColor.DARK_AQUA) + "Edit Shop: ";
    private static final String ITEM_EDIT = String.valueOf(ChatColor.DARK_AQUA) + "Edit Item: ";
    private static final String GAME_LIST = String.valueOf(ChatColor.DARK_AQUA) + "Active Games";
    private static final String GLOBAL_SETTINGS = String.valueOf(ChatColor.DARK_AQUA) + "Global Settings";
    private static final String WAVE_CONFIG = String.valueOf(ChatColor.DARK_AQUA) + "Wave Settings";
    private static final String MOB_SELECT = String.valueOf(ChatColor.DARK_AQUA) + "Select Mob Types";
    private static final String TIER_SELECT = String.valueOf(ChatColor.DARK_AQUA) + "Select Tier";
    private static final String MODE_SELECT = String.valueOf(ChatColor.DARK_AQUA) + "Select Game Mode";
    private static final String DIFF_SELECT = String.valueOf(ChatColor.DARK_AQUA) + "Select Difficulty";
    private static final String PRESET_SELECT = String.valueOf(ChatColor.DARK_AQUA) + "Select Preset";
    private static final String KIT_SELECT = String.valueOf(ChatColor.DARK_AQUA) + "Assign Kit";
    private static final String SHOP_SELECT = String.valueOf(ChatColor.DARK_AQUA) + "Assign Shop";
    private final Map<UUID, String> editing = new HashMap<UUID, String>();
    private final Map<UUID, String> editingItem = new HashMap<UUID, String>();
    private final Map<UUID, String> context = new HashMap<UUID, String>();

    public AdminGUI(ArenaMaker plugin) {
        this.plugin = plugin;
        plugin.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)plugin);
    }

    public void openMain(Player player) {
        Inventory inv = Bukkit.createInventory(null, (int)45, (String)MAIN_MENU);
        inv.setItem(10, this.item(Material.GRASS_BLOCK, String.valueOf(ChatColor.AQUA) + "Arenas", String.valueOf(ChatColor.GRAY) + "Create and manage arenas", String.valueOf(ChatColor.GRAY) + "Total: " + this.plugin.getArenaManager().getAll().size(), "", String.valueOf(ChatColor.DARK_AQUA) + "Click to manage"));
        inv.setItem(12, this.item(Material.DIAMOND_SWORD, String.valueOf(ChatColor.AQUA) + "Kits", String.valueOf(ChatColor.GRAY) + "Create and manage kits", String.valueOf(ChatColor.GRAY) + "Total: " + this.plugin.getKitManager().getAll().size(), "", String.valueOf(ChatColor.DARK_AQUA) + "Click to manage"));
        inv.setItem(14, this.item(Material.EMERALD, String.valueOf(ChatColor.AQUA) + "Shops", String.valueOf(ChatColor.GRAY) + "Create and manage shops", String.valueOf(ChatColor.GRAY) + "Total: " + this.plugin.getShopManager().getAll().size(), "", String.valueOf(ChatColor.DARK_AQUA) + "Click to manage"));
        inv.setItem(16, this.item(Material.CLOCK, String.valueOf(ChatColor.AQUA) + "Active Games", String.valueOf(ChatColor.GRAY) + "View and manage games", String.valueOf(ChatColor.GRAY) + "Active: " + this.plugin.getGameManager().getActiveSessions().size(), "", String.valueOf(ChatColor.DARK_AQUA) + "Click to view"));
        inv.setItem(28, this.item(Material.COMPARATOR, String.valueOf(ChatColor.AQUA) + "Global Settings", String.valueOf(ChatColor.GRAY) + "Configure default settings", String.valueOf(ChatColor.GRAY) + "Waves, points, difficulty", "", String.valueOf(ChatColor.DARK_AQUA) + "Click to configure"));
        inv.setItem(30, this.item(Material.SPAWNER, String.valueOf(ChatColor.AQUA) + "Wave Config", String.valueOf(ChatColor.GRAY) + "Configure wave defaults", String.valueOf(ChatColor.GRAY) + "Mob types, scaling, timing", "", String.valueOf(ChatColor.DARK_AQUA) + "Click to configure"));
        inv.setItem(32, this.item(Material.EXPERIENCE_BOTTLE, String.valueOf(ChatColor.AQUA) + "Statistics", String.valueOf(ChatColor.GRAY) + "View player statistics", String.valueOf(ChatColor.GRAY) + "Kills, wins, games played", "", String.valueOf(ChatColor.DARK_AQUA) + "Click to view"));
        inv.setItem(34, this.item(Material.COMMAND_BLOCK, String.valueOf(ChatColor.AQUA) + "Reload Plugin", String.valueOf(ChatColor.GRAY) + "Reload all configurations", "", String.valueOf(ChatColor.DARK_AQUA) + "Click to reload"));
        player.openInventory(inv);
    }

    public void openArenaList(Player player) {
        Collection<Arena> arenas = this.plugin.getArenaManager().getAll();
        int size = Math.max(36, (arenas.size() / 9 + 2) * 9);
        size = Math.min(54, size);
        Inventory inv = Bukkit.createInventory(null, (int)size, (String)ARENA_LIST);
        int slot = 0;
        for (Arena arena : arenas) {
            ItemStack it = this.item(arena.getPreset().getFloor(), String.valueOf(ChatColor.AQUA) + arena.getName(), String.valueOf(ChatColor.GRAY) + "ID: " + arena.getId(), String.valueOf(ChatColor.GRAY) + "Mode: " + arena.getGameMode().getDisplay(), String.valueOf(ChatColor.GRAY) + "Players: " + arena.getMinPlayers() + "-" + arena.getMaxPlayers(), arena.isEnabled() ? String.valueOf(ChatColor.GREEN) + "Enabled" : String.valueOf(ChatColor.RED) + "Disabled", "", String.valueOf(ChatColor.DARK_AQUA) + "Click to edit", String.valueOf(ChatColor.DARK_AQUA) + "Right-click for settings");
            this.setData(it, arena.getId());
            inv.setItem(slot++, it);
        }
        inv.setItem(size - 5, this.item(Material.LIME_DYE, String.valueOf(ChatColor.GREEN) + "Create Arena", String.valueOf(ChatColor.GRAY) + "Create a new arena", "", String.valueOf(ChatColor.DARK_AQUA) + "Click to create"));
        inv.setItem(size - 1, this.item(Material.ARROW, String.valueOf(ChatColor.GRAY) + "Back", "", String.valueOf(ChatColor.DARK_AQUA) + "Return to main menu"));
        player.openInventory(inv);
    }

    public void openArenaEdit(Player player, Arena arena) {
        this.editing.put(player.getUniqueId(), arena.getId());
        Inventory inv = Bukkit.createInventory(null, (int)54, (String)(ARENA_EDIT + arena.getName()));
        inv.setItem(4, this.item(arena.getPreset().getFloor(), String.valueOf(ChatColor.AQUA) + arena.getName(), String.valueOf(ChatColor.GRAY) + "ID: " + arena.getId(), String.valueOf(ChatColor.GRAY) + "Mode: " + arena.getGameMode().getDisplay(), arena.isComplete() ? String.valueOf(ChatColor.GREEN) + "Setup Complete" : String.valueOf(ChatColor.RED) + "Setup Incomplete"));
        inv.setItem(10, this.item(arena.isEnabled() ? Material.LIME_DYE : Material.GRAY_DYE, arena.isEnabled() ? String.valueOf(ChatColor.GREEN) + "Enabled" : String.valueOf(ChatColor.RED) + "Disabled", String.valueOf(ChatColor.GRAY) + "Toggle arena state", "", String.valueOf(ChatColor.DARK_AQUA) + "Click to toggle"));
        inv.setItem(12, this.item(Material.COMPASS, String.valueOf(ChatColor.AQUA) + "Spawn 1", String.valueOf(ChatColor.GRAY) + "Current: " + this.locStr(arena.getSpawn1()), "", String.valueOf(ChatColor.DARK_AQUA) + "Click to set at your position"));
        inv.setItem(14, this.item(Material.COMPASS, String.valueOf(ChatColor.AQUA) + "Spawn 2", String.valueOf(ChatColor.GRAY) + "Current: " + this.locStr(arena.getSpawn2()), "", String.valueOf(ChatColor.DARK_AQUA) + "Click to set at your position"));
        inv.setItem(16, this.item(Material.ENDER_PEARL, String.valueOf(ChatColor.AQUA) + "Lobby Spawn", String.valueOf(ChatColor.GRAY) + "Current: " + this.locStr(arena.getLobby()), "", String.valueOf(ChatColor.DARK_AQUA) + "Click to set at your position"));
        inv.setItem(19, this.item(arena.getPreset().getFloor(), String.valueOf(ChatColor.AQUA) + "Preset", String.valueOf(ChatColor.GRAY) + "Current: " + arena.getPreset().getDisplay(), "", String.valueOf(ChatColor.DARK_AQUA) + "Click to change"));
        inv.setItem(21, this.item(Material.ZOMBIE_HEAD, String.valueOf(ChatColor.AQUA) + "Game Mode", String.valueOf(ChatColor.GRAY) + "Current: " + arena.getGameMode().getDisplay(), "", String.valueOf(ChatColor.DARK_AQUA) + "Click to change"));
        inv.setItem(23, this.item(Material.SPAWNER, String.valueOf(ChatColor.AQUA) + "Mob Spawns", String.valueOf(ChatColor.GRAY) + "Spawns: " + arena.getMobSpawns().size(), "", String.valueOf(ChatColor.DARK_AQUA) + "Click to add spawn", String.valueOf(ChatColor.DARK_AQUA) + "Shift-click to clear all"));
        inv.setItem(25, this.item(Material.COMPARATOR, String.valueOf(ChatColor.AQUA) + "Advanced Settings", String.valueOf(ChatColor.GRAY) + "Player limits, kits, shop", "", String.valueOf(ChatColor.DARK_AQUA) + "Click to configure"));
        inv.setItem(28, this.item(Material.DIAMOND_SWORD, String.valueOf(ChatColor.AQUA) + "Assign Kit", String.valueOf(ChatColor.GRAY) + "Default kit for this arena", "", String.valueOf(ChatColor.DARK_AQUA) + "Click to select"));
        inv.setItem(30, this.item(Material.EMERALD, String.valueOf(ChatColor.AQUA) + "Assign Shop", String.valueOf(ChatColor.GRAY) + "Shop for this arena", String.valueOf(ChatColor.GRAY) + "Current: " + (arena.getShopId() != null ? arena.getShopId() : "default"), "", String.valueOf(ChatColor.DARK_AQUA) + "Click to select"));
        inv.setItem(32, this.item(Material.FILLED_MAP, String.valueOf(ChatColor.AQUA) + "Teleport", String.valueOf(ChatColor.GRAY) + "Go to arena spawn", "", String.valueOf(ChatColor.DARK_AQUA) + "Click to teleport"));
        inv.setItem(34, this.item(Material.WRITABLE_BOOK, String.valueOf(ChatColor.AQUA) + "Clone Arena", String.valueOf(ChatColor.GRAY) + "Duplicate this arena", "", String.valueOf(ChatColor.DARK_AQUA) + "Click to clone"));
        inv.setItem(49, this.item(Material.BARRIER, String.valueOf(ChatColor.RED) + "Delete Arena", String.valueOf(ChatColor.GRAY) + "Permanently delete", "", String.valueOf(ChatColor.RED) + "Shift-click to delete"));
        inv.setItem(53, this.item(Material.ARROW, String.valueOf(ChatColor.GRAY) + "Back", "", String.valueOf(ChatColor.DARK_AQUA) + "Return to arena list"));
        player.openInventory(inv);
    }

    public void openArenaSettings(Player player, Arena arena) {
        this.editing.put(player.getUniqueId(), arena.getId());
        Inventory inv = Bukkit.createInventory(null, (int)45, (String)(ARENA_SETTINGS + arena.getName()));
        inv.setItem(10, this.item(Material.PLAYER_HEAD, String.valueOf(ChatColor.AQUA) + "Min Players", String.valueOf(ChatColor.GRAY) + "Current: " + arena.getMinPlayers(), "", String.valueOf(ChatColor.DARK_AQUA) + "Left-click: +1", String.valueOf(ChatColor.DARK_AQUA) + "Right-click: -1"));
        inv.setItem(12, this.item(Material.SKELETON_SKULL, String.valueOf(ChatColor.AQUA) + "Max Players", String.valueOf(ChatColor.GRAY) + "Current: " + arena.getMaxPlayers(), "", String.valueOf(ChatColor.DARK_AQUA) + "Left-click: +1", String.valueOf(ChatColor.DARK_AQUA) + "Right-click: -1"));
        inv.setItem(14, this.item(Material.CLOCK, String.valueOf(ChatColor.AQUA) + "Time Limit", String.valueOf(ChatColor.GRAY) + "Not implemented yet", "", String.valueOf(ChatColor.DARK_AQUA) + "Coming soon"));
        inv.setItem(16, this.item(Material.SHIELD, String.valueOf(ChatColor.AQUA) + "PvP Mode", String.valueOf(ChatColor.GRAY) + "Control player damage", "", String.valueOf(ChatColor.DARK_AQUA) + "Click to toggle"));
        inv.setItem(28, this.item(Material.GOLDEN_APPLE, String.valueOf(ChatColor.AQUA) + "Keep Inventory", String.valueOf(ChatColor.GRAY) + "Keep items on death", "", String.valueOf(ChatColor.DARK_AQUA) + "Click to toggle"));
        inv.setItem(30, this.item(Material.FEATHER, String.valueOf(ChatColor.AQUA) + "Fall Damage", String.valueOf(ChatColor.GRAY) + "Toggle fall damage", "", String.valueOf(ChatColor.DARK_AQUA) + "Click to toggle"));
        inv.setItem(32, this.item(Material.COOKED_BEEF, String.valueOf(ChatColor.AQUA) + "Hunger", String.valueOf(ChatColor.GRAY) + "Toggle hunger drain", "", String.valueOf(ChatColor.DARK_AQUA) + "Click to toggle"));
        inv.setItem(34, this.item(Material.ENDER_EYE, String.valueOf(ChatColor.AQUA) + "Spectator Mode", String.valueOf(ChatColor.GRAY) + "Allow spectating on death", "", String.valueOf(ChatColor.DARK_AQUA) + "Click to toggle"));
        inv.setItem(44, this.item(Material.ARROW, String.valueOf(ChatColor.GRAY) + "Back", "", String.valueOf(ChatColor.DARK_AQUA) + "Return to arena edit"));
        player.openInventory(inv);
    }

    public void openKitList(Player player) {
        Collection<Kit> kits = this.plugin.getKitManager().getAll();
        int size = Math.max(36, (kits.size() / 9 + 2) * 9);
        size = Math.min(54, size);
        Inventory inv = Bukkit.createInventory(null, (int)size, (String)KIT_LIST);
        int slot = 0;
        for (Kit kit : kits) {
            ItemStack it = kit.getIconItem();
            ItemMeta meta = it.getItemMeta();
            if (meta != null) {
                meta.setDisplayName(String.valueOf(ChatColor.AQUA) + kit.getName());
                ArrayList<Object> lore = new ArrayList<Object>();
                lore.add(String.valueOf(ChatColor.GRAY) + "ID: " + kit.getId());
                lore.add(String.valueOf(ChatColor.GRAY) + "Effects: " + kit.getEffects().size());
                lore.add("");
                lore.add(String.valueOf(ChatColor.DARK_AQUA) + "Click to edit");
                lore.add(String.valueOf(ChatColor.DARK_AQUA) + "Right-click to preview");
                meta.setLore(lore);
                it.setItemMeta(meta);
            }
            this.setData(it, kit.getId());
            inv.setItem(slot++, it);
        }
        inv.setItem(size - 5, this.item(Material.LIME_DYE, String.valueOf(ChatColor.GREEN) + "Create Kit", String.valueOf(ChatColor.GRAY) + "Create from your inventory", "", String.valueOf(ChatColor.DARK_AQUA) + "Click to create"));
        inv.setItem(size - 1, this.item(Material.ARROW, String.valueOf(ChatColor.GRAY) + "Back", "", String.valueOf(ChatColor.DARK_AQUA) + "Return to main menu"));
        player.openInventory(inv);
    }

    public void openKitEdit(Player player, Kit kit) {
        this.editing.put(player.getUniqueId(), kit.getId());
        Inventory inv = Bukkit.createInventory(null, (int)45, (String)(KIT_EDIT + kit.getName()));
        inv.setItem(4, this.item(kit.getIconItem().getType(), String.valueOf(ChatColor.AQUA) + kit.getName(), String.valueOf(ChatColor.GRAY) + "ID: " + kit.getId(), String.valueOf(ChatColor.GRAY) + "Effects: " + kit.getEffects().size()));
        inv.setItem(19, this.item(Material.CHEST, String.valueOf(ChatColor.AQUA) + "Update Items", String.valueOf(ChatColor.GRAY) + "Set from your inventory", "", String.valueOf(ChatColor.DARK_AQUA) + "Click to save your current inventory"));
        inv.setItem(21, this.item(kit.getIconItem().getType(), String.valueOf(ChatColor.AQUA) + "Set Icon", String.valueOf(ChatColor.GRAY) + "Set from held item", "", String.valueOf(ChatColor.DARK_AQUA) + "Hold item and click"));
        inv.setItem(23, this.item(Material.NAME_TAG, String.valueOf(ChatColor.AQUA) + "Preview Kit", String.valueOf(ChatColor.GRAY) + "Apply kit to yourself", "", String.valueOf(ChatColor.DARK_AQUA) + "Click to preview"));
        inv.setItem(25, this.item(Material.BREWING_STAND, String.valueOf(ChatColor.AQUA) + "Potion Effects", String.valueOf(ChatColor.GRAY) + "Effects: " + kit.getEffects().size(), "", String.valueOf(ChatColor.DARK_AQUA) + "Click to manage effects"));
        inv.setItem(40, this.item(Material.BARRIER, String.valueOf(ChatColor.RED) + "Delete Kit", String.valueOf(ChatColor.GRAY) + "Permanently delete", "", String.valueOf(ChatColor.RED) + "Shift-click to delete"));
        inv.setItem(44, this.item(Material.ARROW, String.valueOf(ChatColor.GRAY) + "Back", "", String.valueOf(ChatColor.DARK_AQUA) + "Return to kit list"));
        player.openInventory(inv);
    }

    public void openShopList(Player player) {
        Collection<Shop> shops = this.plugin.getShopManager().getAll();
        int size = Math.max(36, (shops.size() / 9 + 2) * 9);
        size = Math.min(54, size);
        Inventory inv = Bukkit.createInventory(null, (int)size, (String)SHOP_LIST);
        int slot = 0;
        for (Shop shop : shops) {
            boolean isDefault = shop.getId().equals("default");
            ItemStack it = this.item(isDefault ? Material.NETHER_STAR : Material.EMERALD, String.valueOf(ChatColor.AQUA) + shop.getName(), new String[]{String.valueOf(ChatColor.GRAY) + "ID: " + shop.getId(), String.valueOf(ChatColor.GRAY) + "Items: " + shop.getItems().size(), isDefault ? String.valueOf(ChatColor.GOLD) + "Default Shop" : "", "", String.valueOf(ChatColor.DARK_AQUA) + "Click to edit"});
            this.setData(it, shop.getId());
            inv.setItem(slot++, it);
        }
        inv.setItem(size - 5, this.item(Material.LIME_DYE, String.valueOf(ChatColor.GREEN) + "Create Shop", String.valueOf(ChatColor.GRAY) + "Create a new shop", "", String.valueOf(ChatColor.DARK_AQUA) + "Click to create"));
        inv.setItem(size - 1, this.item(Material.ARROW, String.valueOf(ChatColor.GRAY) + "Back", "", String.valueOf(ChatColor.DARK_AQUA) + "Return to main menu"));
        player.openInventory(inv);
    }

    public void openShopEdit(Player player, Shop shop) {
        this.editing.put(player.getUniqueId(), shop.getId());
        Collection<ShopItem> items = shop.getItems();
        int size = Math.max(45, (items.size() / 9 + 3) * 9);
        size = Math.min(54, size);
        Inventory inv = Bukkit.createInventory(null, (int)size, (String)(SHOP_EDIT + shop.getName()));
        int slot = 0;
        for (ShopItem it : items) {
            ItemStack display = it.getDisplayItem();
            ItemMeta meta = display.getItemMeta();
            if (meta != null) {
                ArrayList<String> lore = meta.getLore();
                if (lore == null) {
                    lore = new ArrayList<String>();
                }
                lore.add("");
                lore.add(String.valueOf(ChatColor.DARK_AQUA) + "Left-click to edit");
                lore.add(String.valueOf(ChatColor.DARK_AQUA) + "Right-click to change tier");
                lore.add(String.valueOf(ChatColor.RED) + "Shift-click to remove");
                meta.setLore(lore);
                display.setItemMeta(meta);
            }
            this.setData(display, it.getId());
            inv.setItem(slot++, display);
            if (slot < size - 9) continue;
            break;
        }
        inv.setItem(size - 8, this.item(Material.LIME_DYE, String.valueOf(ChatColor.GREEN) + "Add Item", String.valueOf(ChatColor.GRAY) + "Add item from hand", "", String.valueOf(ChatColor.DARK_AQUA) + "Hold item and click"));
        inv.setItem(size - 6, this.item(Material.NAME_TAG, String.valueOf(ChatColor.AQUA) + "Rename Shop", String.valueOf(ChatColor.GRAY) + "Change shop name", "", String.valueOf(ChatColor.DARK_AQUA) + "Click then type in chat"));
        inv.setItem(size - 4, this.item(Material.HOPPER, String.valueOf(ChatColor.AQUA) + "Sort Items", String.valueOf(ChatColor.GRAY) + "Sort by tier/cost", "", String.valueOf(ChatColor.DARK_AQUA) + "Click to sort"));
        if (!shop.getId().equals("default")) {
            inv.setItem(size - 2, this.item(Material.BARRIER, String.valueOf(ChatColor.RED) + "Delete Shop", String.valueOf(ChatColor.GRAY) + "Permanently delete", "", String.valueOf(ChatColor.RED) + "Shift-click to delete"));
        }
        inv.setItem(size - 1, this.item(Material.ARROW, String.valueOf(ChatColor.GRAY) + "Back", "", String.valueOf(ChatColor.DARK_AQUA) + "Return to shop list"));
        player.openInventory(inv);
    }

    public void openItemEdit(Player player, Shop shop, ShopItem shopItem) {
        this.editing.put(player.getUniqueId(), shop.getId());
        this.editingItem.put(player.getUniqueId(), shopItem.getId());
        Inventory inv = Bukkit.createInventory(null, (int)45, (String)(ITEM_EDIT + shopItem.getName()));
        inv.setItem(4, shopItem.getDisplayItem());
        inv.setItem(19, this.item(Material.GOLD_INGOT, String.valueOf(ChatColor.AQUA) + "Cost", String.valueOf(ChatColor.GRAY) + "Current: " + shopItem.getCost() + " points", "", String.valueOf(ChatColor.DARK_AQUA) + "Left-click: +10", String.valueOf(ChatColor.DARK_AQUA) + "Right-click: -10", String.valueOf(ChatColor.DARK_AQUA) + "Shift+Left: +100", String.valueOf(ChatColor.DARK_AQUA) + "Shift+Right: -100"));
        inv.setItem(21, this.item(shopItem.getTier().getIcon(), String.valueOf(ChatColor.AQUA) + "Tier", String.valueOf(shopItem.getTier().getColor()) + "Current: " + shopItem.getTier().getDisplay(), String.valueOf(ChatColor.GRAY) + "Unlocks at wave " + shopItem.getTier().getWaveUnlock(), "", String.valueOf(ChatColor.DARK_AQUA) + "Click to change tier"));
        inv.setItem(23, this.item(Material.REPEATER, String.valueOf(ChatColor.AQUA) + "Max Purchases", String.valueOf(ChatColor.GRAY) + "Current: " + String.valueOf(shopItem.getMaxPurchases() < 0 ? "Unlimited" : Integer.valueOf(shopItem.getMaxPurchases())), "", String.valueOf(ChatColor.DARK_AQUA) + "Left-click: +1", String.valueOf(ChatColor.DARK_AQUA) + "Right-click: -1", String.valueOf(ChatColor.DARK_AQUA) + "Shift-click: Unlimited"));
        inv.setItem(25, this.item(Material.WRITABLE_BOOK, String.valueOf(ChatColor.AQUA) + "Description", String.valueOf(ChatColor.GRAY) + "Current: " + (shopItem.getDescription() != null ? shopItem.getDescription() : "None"), "", String.valueOf(ChatColor.DARK_AQUA) + "Click then type in chat"));
        inv.setItem(29, this.item(Material.PAPER, String.valueOf(ChatColor.AQUA) + "Item Type", String.valueOf(ChatColor.GRAY) + "Current: " + shopItem.getType().name(), "", String.valueOf(ChatColor.DARK_AQUA) + "Click to cycle type"));
        inv.setItem(31, this.item(Material.CHEST, String.valueOf(ChatColor.AQUA) + "Update Item", String.valueOf(ChatColor.GRAY) + "Replace with held item", "", String.valueOf(ChatColor.DARK_AQUA) + "Hold item and click"));
        inv.setItem(33, this.item(Material.COMMAND_BLOCK, String.valueOf(ChatColor.AQUA) + "Run Command", String.valueOf(ChatColor.GRAY) + "Command: " + (shopItem.getCommand() != null ? shopItem.getCommand() : "None"), "", String.valueOf(ChatColor.DARK_AQUA) + "Click to set command"));
        inv.setItem(44, this.item(Material.ARROW, String.valueOf(ChatColor.GRAY) + "Back", "", String.valueOf(ChatColor.DARK_AQUA) + "Return to shop"));
        player.openInventory(inv);
    }

    public void openTierSelect(Player player, String shopId, String itemId) {
        this.editing.put(player.getUniqueId(), shopId);
        this.editingItem.put(player.getUniqueId(), itemId);
        Inventory inv = Bukkit.createInventory(null, (int)27, (String)TIER_SELECT);
        int slot = 10;
        for (ShopTier tier : ShopTier.values()) {
            ItemStack it = this.item(tier.getIcon(), String.valueOf(tier.getColor()) + tier.getDisplay(), String.valueOf(ChatColor.GRAY) + "Unlocks at wave " + tier.getWaveUnlock(), "", String.valueOf(tier.getColor()) + "Click to select");
            this.setData(it, tier.name());
            inv.setItem(slot++, it);
        }
        inv.setItem(22, this.item(Material.ARROW, String.valueOf(ChatColor.GRAY) + "Back", "", String.valueOf(ChatColor.DARK_AQUA) + "Return to item edit"));
        player.openInventory(inv);
    }

    public void openGameList(Player player) {
        Collection<GameSession> sessions = this.plugin.getGameManager().getActiveSessions();
        int size = Math.max(27, (sessions.size() / 9 + 2) * 9);
        size = Math.min(54, size);
        Inventory inv = Bukkit.createInventory(null, (int)size, (String)GAME_LIST);
        int slot = 0;
        for (GameSession session : sessions) {
            ItemStack it = this.item(Material.CLOCK, String.valueOf(ChatColor.AQUA) + session.getId(), String.valueOf(ChatColor.GRAY) + "Arena: " + session.getArena().getName(), String.valueOf(ChatColor.GRAY) + "Mode: " + session.getMode().getDisplay(), String.valueOf(session.getDifficulty().getColor()) + "Difficulty: " + session.getDifficulty().getDisplay(), String.valueOf(ChatColor.GRAY) + "Wave: " + session.getCurrentWave(), String.valueOf(ChatColor.GRAY) + "Players: " + session.getPlayerCount() + "/" + session.getMode().getMaxPlayers(), String.valueOf(ChatColor.GRAY) + "Lives: " + session.getLives(), String.valueOf(ChatColor.GRAY) + "State: " + session.getState().name(), "", String.valueOf(ChatColor.RED) + "Click to end game", String.valueOf(ChatColor.DARK_AQUA) + "Right-click to view players");
            this.setData(it, session.getId());
            inv.setItem(slot++, it);
        }
        if (sessions.isEmpty()) {
            inv.setItem(13, this.item(Material.BARRIER, String.valueOf(ChatColor.RED) + "No Active Games", String.valueOf(ChatColor.GRAY) + "Start a game with /game create"));
        }
        inv.setItem(size - 1, this.item(Material.ARROW, String.valueOf(ChatColor.GRAY) + "Back", "", String.valueOf(ChatColor.DARK_AQUA) + "Return to main menu"));
        player.openInventory(inv);
    }

    public void openGlobalSettings(Player player) {
        Inventory inv = Bukkit.createInventory(null, (int)45, (String)GLOBAL_SETTINGS);
        inv.setItem(10, this.item(Material.EXPERIENCE_BOTTLE, String.valueOf(ChatColor.AQUA) + "Starting Points", String.valueOf(ChatColor.GRAY) + "Points given at game start", String.valueOf(ChatColor.GRAY) + "Default: 500", "", String.valueOf(ChatColor.DARK_AQUA) + "Left-click: +50", String.valueOf(ChatColor.DARK_AQUA) + "Right-click: -50"));
        inv.setItem(12, this.item(Material.DIAMOND, String.valueOf(ChatColor.AQUA) + "Kill Point Bonus", String.valueOf(ChatColor.GRAY) + "Extra points per kill", String.valueOf(ChatColor.GRAY) + "Default: 0", "", String.valueOf(ChatColor.DARK_AQUA) + "Left-click: +5", String.valueOf(ChatColor.DARK_AQUA) + "Right-click: -5"));
        inv.setItem(14, this.item(Material.SKELETON_SKULL, String.valueOf(ChatColor.AQUA) + "Default Difficulty", String.valueOf(ChatColor.GRAY) + "For new games", "", String.valueOf(ChatColor.DARK_AQUA) + "Click to select"));
        inv.setItem(16, this.item(Material.ZOMBIE_HEAD, String.valueOf(ChatColor.AQUA) + "Default Game Mode", String.valueOf(ChatColor.GRAY) + "For quick start", "", String.valueOf(ChatColor.DARK_AQUA) + "Click to select"));
        inv.setItem(28, this.item(Material.CLOCK, String.valueOf(ChatColor.AQUA) + "Wave Delay", String.valueOf(ChatColor.GRAY) + "Seconds between waves", String.valueOf(ChatColor.GRAY) + "Default: 5", "", String.valueOf(ChatColor.DARK_AQUA) + "Left-click: +1", String.valueOf(ChatColor.DARK_AQUA) + "Right-click: -1"));
        inv.setItem(30, this.item(Material.HEART_OF_THE_SEA, String.valueOf(ChatColor.AQUA) + "Health Regen", String.valueOf(ChatColor.GRAY) + "Regen between waves", "", String.valueOf(ChatColor.DARK_AQUA) + "Click to toggle"));
        inv.setItem(32, this.item(Material.BEACON, String.valueOf(ChatColor.AQUA) + "Announcements", String.valueOf(ChatColor.GRAY) + "Game event messages", "", String.valueOf(ChatColor.DARK_AQUA) + "Click to toggle"));
        inv.setItem(34, this.item(Material.MUSIC_DISC_CAT, String.valueOf(ChatColor.AQUA) + "Sound Effects", String.valueOf(ChatColor.GRAY) + "Game sounds", "", String.valueOf(ChatColor.DARK_AQUA) + "Click to toggle"));
        inv.setItem(44, this.item(Material.ARROW, String.valueOf(ChatColor.GRAY) + "Back", "", String.valueOf(ChatColor.DARK_AQUA) + "Return to main menu"));
        player.openInventory(inv);
    }

    public void openWaveConfig(Player player) {
        Inventory inv = Bukkit.createInventory(null, (int)45, (String)WAVE_CONFIG);
        inv.setItem(10, this.item(Material.ZOMBIE_HEAD, String.valueOf(ChatColor.AQUA) + "Base Mob Count", String.valueOf(ChatColor.GRAY) + "Mobs in wave 1", String.valueOf(ChatColor.GRAY) + "Default: 5", "", String.valueOf(ChatColor.DARK_AQUA) + "Left-click: +1", String.valueOf(ChatColor.DARK_AQUA) + "Right-click: -1"));
        inv.setItem(12, this.item(Material.ARROW, String.valueOf(ChatColor.AQUA) + "Mob Scaling", String.valueOf(ChatColor.GRAY) + "Extra mobs per wave", String.valueOf(ChatColor.GRAY) + "Default: +2 per wave", "", String.valueOf(ChatColor.DARK_AQUA) + "Left-click: +1", String.valueOf(ChatColor.DARK_AQUA) + "Right-click: -1"));
        inv.setItem(14, this.item(Material.GOLDEN_APPLE, String.valueOf(ChatColor.AQUA) + "Health Scaling", String.valueOf(ChatColor.GRAY) + "HP increase per wave", String.valueOf(ChatColor.GRAY) + "Default: +10% per wave", "", String.valueOf(ChatColor.DARK_AQUA) + "Left-click: +5%", String.valueOf(ChatColor.DARK_AQUA) + "Right-click: -5%"));
        inv.setItem(16, this.item(Material.DIAMOND_SWORD, String.valueOf(ChatColor.AQUA) + "Damage Scaling", String.valueOf(ChatColor.GRAY) + "Damage increase per wave", String.valueOf(ChatColor.GRAY) + "Default: +5% per wave", "", String.valueOf(ChatColor.DARK_AQUA) + "Left-click: +5%", String.valueOf(ChatColor.DARK_AQUA) + "Right-click: -5%"));
        inv.setItem(28, this.item(Material.SPAWNER, String.valueOf(ChatColor.AQUA) + "Mob Types", String.valueOf(ChatColor.GRAY) + "Configure which mobs spawn", "", String.valueOf(ChatColor.DARK_AQUA) + "Click to configure"));
        inv.setItem(30, this.item(Material.WITHER_SKELETON_SKULL, String.valueOf(ChatColor.AQUA) + "Boss Waves", String.valueOf(ChatColor.GRAY) + "Every X waves spawn boss", String.valueOf(ChatColor.GRAY) + "Default: Every 5 waves", "", String.valueOf(ChatColor.DARK_AQUA) + "Left-click: +1", String.valueOf(ChatColor.DARK_AQUA) + "Right-click: -1"));
        inv.setItem(32, this.item(Material.GOLD_INGOT, String.valueOf(ChatColor.AQUA) + "Wave Bonus Points", String.valueOf(ChatColor.GRAY) + "Bonus for completing wave", String.valueOf(ChatColor.GRAY) + "Default: wave * 50", "", String.valueOf(ChatColor.DARK_AQUA) + "Left-click: +10", String.valueOf(ChatColor.DARK_AQUA) + "Right-click: -10"));
        inv.setItem(34, this.item(Material.ENDER_PEARL, String.valueOf(ChatColor.AQUA) + "Max Wave", String.valueOf(ChatColor.GRAY) + "End game at wave X", String.valueOf(ChatColor.GRAY) + "Default: Unlimited", "", String.valueOf(ChatColor.DARK_AQUA) + "Left-click: +5", String.valueOf(ChatColor.DARK_AQUA) + "Right-click: -5"));
        inv.setItem(44, this.item(Material.ARROW, String.valueOf(ChatColor.GRAY) + "Back", "", String.valueOf(ChatColor.DARK_AQUA) + "Return to main menu"));
        player.openInventory(inv);
    }

    public void openMobSelect(Player player) {
        Inventory inv = Bukkit.createInventory(null, (int)45, (String)MOB_SELECT);
        int slot = 0;
        for (MobType mob : MobType.values()) {
            ItemStack it = this.item(this.getMobIcon(mob), String.valueOf(ChatColor.AQUA) + mob.getDisplay(), String.valueOf(ChatColor.GRAY) + "Points: " + mob.getPoints(), String.valueOf(ChatColor.GRAY) + "Base HP: " + (int)mob.getBaseHealth(), "", String.valueOf(ChatColor.GREEN) + "Enabled", String.valueOf(ChatColor.DARK_AQUA) + "Click to toggle");
            this.setData(it, mob.name());
            inv.setItem(slot++, it);
            if (slot >= 36) break;
        }
        inv.setItem(44, this.item(Material.ARROW, String.valueOf(ChatColor.GRAY) + "Back", "", String.valueOf(ChatColor.DARK_AQUA) + "Return to wave config"));
        player.openInventory(inv);
    }

    public void openKitSelect(Player player, String arenaId) {
        this.editing.put(player.getUniqueId(), arenaId);
        Collection<Kit> kits = this.plugin.getKitManager().getAll();
        Inventory inv = Bukkit.createInventory(null, (int)36, (String)KIT_SELECT);
        inv.setItem(4, this.item(Material.BARRIER, String.valueOf(ChatColor.RED) + "No Kit", String.valueOf(ChatColor.GRAY) + "Remove kit assignment", "", String.valueOf(ChatColor.DARK_AQUA) + "Click to remove"));
        int slot = 9;
        for (Kit kit : kits) {
            ItemStack it = kit.getIconItem();
            ItemMeta meta = it.getItemMeta();
            if (meta != null) {
                meta.setDisplayName(String.valueOf(ChatColor.AQUA) + kit.getName());
                ArrayList<Object> lore = new ArrayList<Object>();
                lore.add(String.valueOf(ChatColor.GRAY) + "ID: " + kit.getId());
                lore.add("");
                lore.add(String.valueOf(ChatColor.DARK_AQUA) + "Click to assign");
                meta.setLore(lore);
                it.setItemMeta(meta);
            }
            this.setData(it, kit.getId());
            inv.setItem(slot++, it);
        }
        inv.setItem(35, this.item(Material.ARROW, String.valueOf(ChatColor.GRAY) + "Back", "", String.valueOf(ChatColor.DARK_AQUA) + "Return to arena"));
        player.openInventory(inv);
    }

    public void openShopSelect(Player player, String arenaId) {
        this.editing.put(player.getUniqueId(), arenaId);
        Collection<Shop> shops = this.plugin.getShopManager().getAll();
        Inventory inv = Bukkit.createInventory(null, (int)36, (String)SHOP_SELECT);
        int slot = 9;
        for (Shop shop : shops) {
            ItemStack it = this.item(Material.EMERALD, String.valueOf(ChatColor.AQUA) + shop.getName(), String.valueOf(ChatColor.GRAY) + "ID: " + shop.getId(), String.valueOf(ChatColor.GRAY) + "Items: " + shop.getItems().size(), "", String.valueOf(ChatColor.DARK_AQUA) + "Click to assign");
            this.setData(it, shop.getId());
            inv.setItem(slot++, it);
        }
        inv.setItem(35, this.item(Material.ARROW, String.valueOf(ChatColor.GRAY) + "Back", "", String.valueOf(ChatColor.DARK_AQUA) + "Return to arena"));
        player.openInventory(inv);
    }

    @EventHandler
    public void onClick(InventoryClickEvent event) {
        HumanEntity humanEntity = event.getWhoClicked();
        if (!(humanEntity instanceof Player)) {
            return;
        }
        Player player = (Player)humanEntity;
        String title = event.getView().getTitle();
        ItemStack it = event.getCurrentItem();
        ClickType click = event.getClick();
        if (it == null || it.getType() == Material.AIR) {
            return;
        }
        if (title.equals(MAIN_MENU)) {
            event.setCancelled(true);
            this.handleMainMenu(player, event.getSlot());
        } else if (title.equals(ARENA_LIST)) {
            event.setCancelled(true);
            this.handleArenaList(player, it, event.getSlot(), event.getView().getTopInventory().getSize(), click);
        } else if (title.startsWith(ARENA_EDIT)) {
            event.setCancelled(true);
            this.handleArenaEdit(player, event.getSlot(), click);
        } else if (title.startsWith(ARENA_SETTINGS)) {
            event.setCancelled(true);
            this.handleArenaSettings(player, event.getSlot(), click);
        } else if (title.equals(KIT_LIST)) {
            event.setCancelled(true);
            this.handleKitList(player, it, event.getSlot(), event.getView().getTopInventory().getSize(), click);
        } else if (title.startsWith(KIT_EDIT)) {
            event.setCancelled(true);
            this.handleKitEdit(player, event.getSlot(), click);
        } else if (title.equals(SHOP_LIST)) {
            event.setCancelled(true);
            this.handleShopList(player, it, event.getSlot(), event.getView().getTopInventory().getSize());
        } else if (title.startsWith(SHOP_EDIT)) {
            event.setCancelled(true);
            this.handleShopEdit(player, it, event.getSlot(), event.getView().getTopInventory().getSize(), click);
        } else if (title.startsWith(ITEM_EDIT)) {
            event.setCancelled(true);
            this.handleItemEdit(player, event.getSlot(), click);
        } else if (title.equals(TIER_SELECT)) {
            event.setCancelled(true);
            this.handleTierSelect(player, it, event.getSlot());
        } else if (title.equals(GAME_LIST)) {
            event.setCancelled(true);
            this.handleGameList(player, it, event.getSlot(), event.getView().getTopInventory().getSize(), click);
        } else if (title.equals(GLOBAL_SETTINGS)) {
            event.setCancelled(true);
            this.handleGlobalSettings(player, event.getSlot(), click);
        } else if (title.equals(WAVE_CONFIG)) {
            event.setCancelled(true);
            this.handleWaveConfig(player, event.getSlot(), click);
        } else if (title.equals(MOB_SELECT)) {
            event.setCancelled(true);
            this.handleMobSelect(player, it, event.getSlot());
        } else if (title.equals(KIT_SELECT)) {
            event.setCancelled(true);
            this.handleKitSelect(player, it, event.getSlot());
        } else if (title.equals(SHOP_SELECT)) {
            event.setCancelled(true);
            this.handleShopSelectClick(player, it, event.getSlot());
        }
    }

    private void handleMainMenu(Player player, int slot) {
        switch (slot) {
            case 10: {
                this.openArenaList(player);
                break;
            }
            case 12: {
                this.openKitList(player);
                break;
            }
            case 14: {
                this.openShopList(player);
                break;
            }
            case 16: {
                this.openGameList(player);
                break;
            }
            case 28: {
                this.openGlobalSettings(player);
                break;
            }
            case 30: {
                this.openWaveConfig(player);
                break;
            }
            case 34: {
                player.closeInventory();
                this.plugin.reloadConfig();
                this.plugin.getArenaManager().load();
                this.plugin.getKitManager().load();
                this.plugin.getShopManager().load();
                Msg.success((CommandSender)player, "Plugin reloaded!");
            }
        }
    }

    private void handleArenaList(Player player, ItemStack it, int slot, int size, ClickType click) {
        Arena arena;
        if (slot == size - 5) {
            player.closeInventory();
            Msg.info((CommandSender)player, "Use: /arena create <name>");
            return;
        }
        if (slot == size - 1) {
            this.openMain(player);
            return;
        }
        String id = this.getData(it);
        if (id != null && (arena = this.plugin.getArenaManager().get(id)) != null) {
            if (click.isRightClick()) {
                this.openArenaSettings(player, arena);
            } else {
                this.openArenaEdit(player, arena);
            }
        }
    }

    private void handleArenaEdit(Player player, int slot, ClickType click) {
        String id = this.editing.get(player.getUniqueId());
        if (id == null) {
            return;
        }
        Arena arena = this.plugin.getArenaManager().get(id);
        if (arena == null) {
            return;
        }
        switch (slot) {
            case 10: {
                arena.setEnabled(!arena.isEnabled());
                this.plugin.getArenaManager().save();
                this.openArenaEdit(player, arena);
                break;
            }
            case 12: {
                arena.setSpawn1(player.getLocation());
                this.plugin.getArenaManager().save();
                Msg.success((CommandSender)player, "Spawn 1 set!");
                this.openArenaEdit(player, arena);
                break;
            }
            case 14: {
                arena.setSpawn2(player.getLocation());
                this.plugin.getArenaManager().save();
                Msg.success((CommandSender)player, "Spawn 2 set!");
                this.openArenaEdit(player, arena);
                break;
            }
            case 16: {
                arena.setLobby(player.getLocation());
                this.plugin.getArenaManager().save();
                Msg.success((CommandSender)player, "Lobby set!");
                this.openArenaEdit(player, arena);
                break;
            }
            case 19: {
                Preset[] presets = Preset.values();
                int current = arena.getPreset().ordinal();
                arena.setPreset(presets[(current + 1) % presets.length]);
                this.plugin.getArenaManager().save();
                this.openArenaEdit(player, arena);
                break;
            }
            case 21: {
                GameMode[] modes = GameMode.values();
                int current = arena.getGameMode().ordinal();
                arena.setGameMode(modes[(current + 1) % modes.length]);
                this.plugin.getArenaManager().save();
                this.openArenaEdit(player, arena);
                break;
            }
            case 23: {
                if (click.isShiftClick()) {
                    arena.clearMobSpawns();
                    this.plugin.getArenaManager().save();
                    Msg.success((CommandSender)player, "Mob spawns cleared!");
                } else {
                    arena.addMobSpawn(player.getLocation());
                    this.plugin.getArenaManager().save();
                    Msg.success((CommandSender)player, "Mob spawn added! Total: " + arena.getMobSpawns().size());
                }
                this.openArenaEdit(player, arena);
                break;
            }
            case 25: {
                this.openArenaSettings(player, arena);
                break;
            }
            case 28: {
                this.openKitSelect(player, arena.getId());
                break;
            }
            case 30: {
                this.openShopSelect(player, arena.getId());
                break;
            }
            case 32: {
                player.closeInventory();
                if (arena.getSpawn1() != null) {
                    player.teleport(arena.getSpawn1());
                    Msg.success((CommandSender)player, "Teleported to " + arena.getName());
                    break;
                }
                Msg.error((CommandSender)player, "No spawn set!");
                break;
            }
            case 34: {
                String newId = arena.getId() + "_copy";
                Arena copy = this.plugin.getArenaManager().create(newId);
                if (copy == null) break;
                copy.setName(arena.getName() + " Copy");
                copy.setPreset(arena.getPreset());
                copy.setGameMode(arena.getGameMode());
                this.plugin.getArenaManager().save();
                Msg.success((CommandSender)player, "Arena cloned as " + newId);
                this.openArenaEdit(player, copy);
                break;
            }
            case 49: {
                if (click.isShiftClick()) {
                    this.plugin.getArenaManager().delete(id);
                    Msg.success((CommandSender)player, "Arena deleted!");
                    this.openArenaList(player);
                    break;
                }
                Msg.error((CommandSender)player, "Shift-click to confirm deletion!");
                break;
            }
            case 53: {
                this.openArenaList(player);
            }
        }
    }

    private void handleArenaSettings(Player player, int slot, ClickType click) {
        String id = this.editing.get(player.getUniqueId());
        if (id == null) {
            return;
        }
        Arena arena = this.plugin.getArenaManager().get(id);
        if (arena == null) {
            return;
        }
        switch (slot) {
            case 10: {
                int val = arena.getMinPlayers() + (click.isLeftClick() ? 1 : -1);
                arena.setMinPlayers(Math.max(1, Math.min(val, arena.getMaxPlayers())));
                this.plugin.getArenaManager().save();
                this.openArenaSettings(player, arena);
                break;
            }
            case 12: {
                int val = arena.getMaxPlayers() + (click.isLeftClick() ? 1 : -1);
                arena.setMaxPlayers(Math.max(arena.getMinPlayers(), Math.min(val, 100)));
                this.plugin.getArenaManager().save();
                this.openArenaSettings(player, arena);
                break;
            }
            case 44: {
                this.openArenaEdit(player, arena);
            }
        }
    }

    private void handleKitList(Player player, ItemStack it, int slot, int size, ClickType click) {
        Kit kit;
        if (slot == size - 5) {
            player.closeInventory();
            Msg.info((CommandSender)player, "Use: /kit create <name>");
            return;
        }
        if (slot == size - 1) {
            this.openMain(player);
            return;
        }
        String id = this.getData(it);
        if (id != null && (kit = this.plugin.getKitManager().get(id)) != null) {
            if (click.isRightClick()) {
                kit.apply(player);
                Msg.success((CommandSender)player, "Kit previewed!");
            } else {
                this.openKitEdit(player, kit);
            }
        }
    }

    private void handleKitEdit(Player player, int slot, ClickType click) {
        String id = this.editing.get(player.getUniqueId());
        if (id == null) {
            return;
        }
        Kit kit = this.plugin.getKitManager().get(id);
        if (kit == null) {
            return;
        }
        switch (slot) {
            case 19: {
                kit.setItems((ItemStack[])player.getInventory().getContents().clone());
                kit.setArmor((ItemStack[])player.getInventory().getArmorContents().clone());
                this.plugin.getKitManager().save();
                Msg.success((CommandSender)player, "Kit items updated!");
                this.openKitEdit(player, kit);
                break;
            }
            case 21: {
                ItemStack held = player.getInventory().getItemInMainHand();
                if (held.getType() != Material.AIR) {
                    kit.setIcon(held.getType().name());
                    this.plugin.getKitManager().save();
                    Msg.success((CommandSender)player, "Kit icon updated!");
                }
                this.openKitEdit(player, kit);
                break;
            }
            case 23: {
                kit.apply(player);
                Msg.success((CommandSender)player, "Kit applied!");
                break;
            }
            case 40: {
                if (click.isShiftClick()) {
                    this.plugin.getKitManager().delete(id);
                    Msg.success((CommandSender)player, "Kit deleted!");
                    this.openKitList(player);
                    break;
                }
                Msg.error((CommandSender)player, "Shift-click to confirm deletion!");
                break;
            }
            case 44: {
                this.openKitList(player);
            }
        }
    }

    private void handleShopList(Player player, ItemStack it, int slot, int size) {
        Shop shop;
        if (slot == size - 5) {
            player.closeInventory();
            Msg.info((CommandSender)player, "Use: /arena shop create <name>");
            return;
        }
        if (slot == size - 1) {
            this.openMain(player);
            return;
        }
        String id = this.getData(it);
        if (id != null && (shop = this.plugin.getShopManager().get(id)) != null) {
            this.openShopEdit(player, shop);
        }
    }

    private void handleShopEdit(Player player, ItemStack it, int slot, int size, ClickType click) {
        ShopItem shopItem;
        String id = this.editing.get(player.getUniqueId());
        if (id == null) {
            return;
        }
        Shop shop = this.plugin.getShopManager().get(id);
        if (shop == null) {
            return;
        }
        if (slot == size - 8) {
            ItemStack held = player.getInventory().getItemInMainHand();
            if (held.getType() != Material.AIR) {
                String itemId = held.getType().name().toLowerCase() + "_" + System.currentTimeMillis() % 10000L;
                ShopItem shopItem2 = new ShopItem(itemId);
                shopItem2.setName(this.formatName(held.getType().name()));
                shopItem2.setMaterial(held.getType());
                shopItem2.setItem(held.clone());
                shopItem2.setTier(ShopTier.STARTER);
                shopItem2.setCost(100);
                shop.addItem(shopItem2);
                this.plugin.getShopManager().save();
                Msg.success((CommandSender)player, "Item added!");
            }
            this.openShopEdit(player, shop);
            return;
        }
        if (slot == size - 4) {
            Msg.info((CommandSender)player, "Sorting by tier...");
            this.openShopEdit(player, shop);
            return;
        }
        if (slot == size - 2 && !id.equals("default")) {
            if (click.isShiftClick()) {
                this.plugin.getShopManager().delete(id);
                Msg.success((CommandSender)player, "Shop deleted!");
                this.openShopList(player);
            } else {
                Msg.error((CommandSender)player, "Shift-click to confirm deletion!");
            }
            return;
        }
        if (slot == size - 1) {
            this.openShopList(player);
            return;
        }
        String itemId = this.getData(it);
        if (itemId != null && (shopItem = shop.getItem(itemId)) != null) {
            if (click.isShiftClick()) {
                shop.removeItem(itemId);
                this.plugin.getShopManager().save();
                Msg.success((CommandSender)player, "Item removed!");
                this.openShopEdit(player, shop);
            } else if (click.isRightClick()) {
                ShopTier[] tiers = ShopTier.values();
                int current = shopItem.getTier().ordinal();
                shopItem.setTier(tiers[(current + 1) % tiers.length]);
                this.plugin.getShopManager().save();
                Msg.success((CommandSender)player, "Tier: " + shopItem.getTier().getFormatted());
                this.openShopEdit(player, shop);
            } else {
                this.openItemEdit(player, shop, shopItem);
            }
        }
    }

    private void handleItemEdit(Player player, int slot, ClickType click) {
        String shopId = this.editing.get(player.getUniqueId());
        String itemId = this.editingItem.get(player.getUniqueId());
        if (shopId == null || itemId == null) {
            return;
        }
        Shop shop = this.plugin.getShopManager().get(shopId);
        if (shop == null) {
            return;
        }
        ShopItem it = shop.getItem(itemId);
        if (it == null) {
            return;
        }
        switch (slot) {
            case 19: {
                int delta;
                int n = delta = click.isShiftClick() ? 100 : 10;
                if (click.isRightClick()) {
                    delta = -delta;
                }
                it.setCost(Math.max(0, it.getCost() + delta));
                this.plugin.getShopManager().save();
                this.openItemEdit(player, shop, it);
                break;
            }
            case 21: {
                this.openTierSelect(player, shopId, itemId);
                break;
            }
            case 23: {
                if (click.isShiftClick()) {
                    it.setMaxPurchases(-1);
                } else {
                    int delta = click.isLeftClick() ? 1 : -1;
                    it.setMaxPurchases(Math.max(-1, it.getMaxPurchases() + delta));
                }
                this.plugin.getShopManager().save();
                this.openItemEdit(player, shop, it);
                break;
            }
            case 29: {
                ShopItem.Type[] types = ShopItem.Type.values();
                int current = it.getType().ordinal();
                it.setType(types[(current + 1) % types.length]);
                this.plugin.getShopManager().save();
                this.openItemEdit(player, shop, it);
                break;
            }
            case 31: {
                ItemStack held = player.getInventory().getItemInMainHand();
                if (held.getType() != Material.AIR) {
                    it.setItem(held.clone());
                    it.setMaterial(held.getType());
                    this.plugin.getShopManager().save();
                    Msg.success((CommandSender)player, "Item updated!");
                }
                this.openItemEdit(player, shop, it);
                break;
            }
            case 44: {
                this.openShopEdit(player, shop);
            }
        }
    }

    private void handleTierSelect(Player player, ItemStack it, int slot) {
        if (slot == 22) {
            String shopId = this.editing.get(player.getUniqueId());
            String itemId = this.editingItem.get(player.getUniqueId());
            if (shopId != null && itemId != null) {
                ShopItem shopItem;
                Shop shop = this.plugin.getShopManager().get(shopId);
                ShopItem shopItem2 = shopItem = shop != null ? shop.getItem(itemId) : null;
                if (shop != null && shopItem != null) {
                    this.openItemEdit(player, shop, shopItem);
                }
            }
            return;
        }
        String tierName = this.getData(it);
        if (tierName != null) {
            String shopId = this.editing.get(player.getUniqueId());
            String itemId = this.editingItem.get(player.getUniqueId());
            if (shopId != null && itemId != null) {
                ShopItem shopItem;
                Shop shop = this.plugin.getShopManager().get(shopId);
                ShopItem shopItem3 = shopItem = shop != null ? shop.getItem(itemId) : null;
                if (shopItem != null) {
                    shopItem.setTier(ShopTier.fromName(tierName));
                    this.plugin.getShopManager().save();
                    Msg.success((CommandSender)player, "Tier set to " + shopItem.getTier().getFormatted());
                    this.openItemEdit(player, shop, shopItem);
                }
            }
        }
    }

    private void handleGameList(Player player, ItemStack it, int slot, int size, ClickType click) {
        GameSession session;
        if (slot == size - 1) {
            this.openMain(player);
            return;
        }
        String id = this.getData(it);
        if (id != null && (session = this.plugin.getGameManager().getSession(id)) != null) {
            if (click.isRightClick()) {
                Msg.info((CommandSender)player, "Players in " + id + ":");
                for (UUID uuid : session.getPlayers()) {
                    Player p = Bukkit.getPlayer((UUID)uuid);
                    if (p == null) continue;
                    Msg.send((CommandSender)player, " - " + p.getName() + " (pts: " + session.getPoints().getPoints(uuid) + ")");
                }
            } else {
                session.end();
                Msg.success((CommandSender)player, "Game ended!");
                this.openGameList(player);
            }
        }
    }

    private void handleGlobalSettings(Player player, int slot, ClickType click) {
        if (slot == 44) {
            this.openMain(player);
        }
    }

    private void handleWaveConfig(Player player, int slot, ClickType click) {
        if (slot == 28) {
            this.openMobSelect(player);
        } else if (slot == 44) {
            this.openMain(player);
        }
    }

    private void handleMobSelect(Player player, ItemStack it, int slot) {
        if (slot == 44) {
            this.openWaveConfig(player);
            return;
        }
        String mobName = this.getData(it);
        if (mobName != null) {
            Msg.info((CommandSender)player, "Toggled " + mobName);
            this.openMobSelect(player);
        }
    }

    private void handleKitSelect(Player player, ItemStack it, int slot) {
        String arenaId = this.editing.get(player.getUniqueId());
        if (arenaId == null) {
            return;
        }
        Arena arena = this.plugin.getArenaManager().get(arenaId);
        if (arena == null) {
            return;
        }
        if (slot == 35) {
            this.openArenaEdit(player, arena);
            return;
        }
        if (slot == 4) {
            Msg.success((CommandSender)player, "Kit removed from arena");
            this.openArenaEdit(player, arena);
            return;
        }
        String kitId = this.getData(it);
        if (kitId != null) {
            Msg.success((CommandSender)player, "Kit " + kitId + " assigned to arena");
            this.openArenaEdit(player, arena);
        }
    }

    private void handleShopSelectClick(Player player, ItemStack it, int slot) {
        String arenaId = this.editing.get(player.getUniqueId());
        if (arenaId == null) {
            return;
        }
        Arena arena = this.plugin.getArenaManager().get(arenaId);
        if (arena == null) {
            return;
        }
        if (slot == 35) {
            this.openArenaEdit(player, arena);
            return;
        }
        String shopId = this.getData(it);
        if (shopId != null) {
            arena.setShopId(shopId);
            this.plugin.getArenaManager().save();
            Msg.success((CommandSender)player, "Shop " + shopId + " assigned to arena");
            this.openArenaEdit(player, arena);
        }
    }

    private Material getMobIcon(MobType mob) {
        return switch (mob) {
            default -> throw new MatchException(null, null);
            case MobType.ZOMBIE -> Material.ZOMBIE_HEAD;
            case MobType.SKELETON -> Material.SKELETON_SKULL;
            case MobType.SPIDER -> Material.SPIDER_EYE;
            case MobType.CREEPER -> Material.CREEPER_HEAD;
            case MobType.ENDERMAN -> Material.ENDER_PEARL;
            case MobType.WITCH -> Material.SPLASH_POTION;
            case MobType.BLAZE -> Material.BLAZE_ROD;
            case MobType.WITHER_SKELETON -> Material.WITHER_SKELETON_SKULL;
            case MobType.PIGLIN_BRUTE -> Material.GOLDEN_AXE;
            case MobType.VINDICATOR -> Material.IRON_AXE;
            case MobType.RAVAGER -> Material.RAVAGER_SPAWN_EGG;
            case MobType.WARDEN -> Material.SCULK_SHRIEKER;
        };
    }

    private String formatName(String name) {
        String[] words = name.toLowerCase().split("_");
        StringBuilder sb = new StringBuilder();
        for (String word : words) {
            if (word.isEmpty()) continue;
            sb.append(Character.toUpperCase(word.charAt(0))).append(word.substring(1)).append(" ");
        }
        return sb.toString().trim();
    }

    private ItemStack item(Material material, String name, String ... lore) {
        ItemStack it = new ItemStack(material);
        ItemMeta meta = it.getItemMeta();
        if (meta != null) {
            meta.setDisplayName(name);
            ArrayList<String> loreList = new ArrayList<String>();
            for (String line : lore) {
                if (line.isEmpty()) continue;
                loreList.add(line);
            }
            meta.setLore(loreList);
            it.setItemMeta(meta);
        }
        return it;
    }

    private void setData(ItemStack it, String data) {
        if (it == null) {
            return;
        }
        ItemMeta meta = it.getItemMeta();
        if (meta != null) {
            ArrayList<CallSite> lore = meta.getLore();
            if (lore == null) {
                lore = new ArrayList<CallSite>();
            }
            lore.add((CallSite)((Object)(String.valueOf(ChatColor.BLACK) + String.valueOf(ChatColor.MAGIC) + data)));
            meta.setLore(lore);
            it.setItemMeta(meta);
        }
    }

    private String getData(ItemStack it) {
        if (it == null || !it.hasItemMeta()) {
            return null;
        }
        ItemMeta meta = it.getItemMeta();
        if (meta == null || !meta.hasLore()) {
            return null;
        }
        List lore = meta.getLore();
        if (lore == null || lore.isEmpty()) {
            return null;
        }
        String last = (String)lore.get(lore.size() - 1);
        if (last.startsWith(String.valueOf(ChatColor.BLACK) + String.valueOf(ChatColor.MAGIC))) {
            return ChatColor.stripColor((String)last.substring(4));
        }
        return null;
    }

    private String locStr(Location loc) {
        if (loc == null) {
            return "Not set";
        }
        return String.format("%.0f, %.0f, %.0f", loc.getX(), loc.getY(), loc.getZ());
    }
}

