/*
 * Decompiled with CFR 0.152.
 */
package AM.arenaMaker.gui;

import AM.arenaMaker.ArenaMaker;
import AM.arenaMaker.arena.Arena;
import AM.arenaMaker.kit.Kit;
import AM.arenaMaker.util.Msg;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.plugin.Plugin;

public class MenuManager
implements Listener {
    private final ArenaMaker plugin;
    private final String ARENA_MENU = String.valueOf(ChatColor.DARK_AQUA) + "Select Arena";
    private final String KIT_MENU = String.valueOf(ChatColor.DARK_AQUA) + "Select Kit";
    private final String DUEL_MENU = String.valueOf(ChatColor.DARK_AQUA) + "Duel Settings";

    public MenuManager(ArenaMaker plugin) {
        this.plugin = plugin;
        plugin.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)plugin);
    }

    public void openArenaMenu(Player player) {
        List<Arena> arenas = this.plugin.getArenaManager().getAll().stream().filter(Arena::isEnabled).toList();
        int size = Math.min(54, (arenas.size() / 9 + 1) * 9);
        Inventory inv = Bukkit.createInventory(null, (int)Math.max(9, size), (String)this.ARENA_MENU);
        int slot = 0;
        for (Arena arena : arenas) {
            ItemStack item = this.createItem(arena.getPreset().getFloor(), String.valueOf(ChatColor.AQUA) + arena.getName(), String.valueOf(ChatColor.GRAY) + "Preset: " + arena.getPreset().getDisplay(), String.valueOf(ChatColor.GRAY) + "Status: " + (this.plugin.getDuelManager().isArenaBusy(arena.getId()) ? String.valueOf(ChatColor.RED) + "In Use" : String.valueOf(ChatColor.GREEN) + "Available"), "", String.valueOf(ChatColor.DARK_AQUA) + "Click to select");
            this.setData(item, arena.getId());
            inv.setItem(slot++, item);
        }
        player.openInventory(inv);
    }

    public void openKitMenu(Player player) {
        Collection<Kit> kits = this.plugin.getKitManager().getAll();
        int size = Math.min(54, (kits.size() / 9 + 1) * 9);
        Inventory inv = Bukkit.createInventory(null, (int)Math.max(9, size), (String)this.KIT_MENU);
        int slot = 0;
        for (Kit kit : kits) {
            ItemStack item = kit.getIconItem();
            ItemMeta meta = item.getItemMeta();
            if (meta != null) {
                meta.setDisplayName(String.valueOf(ChatColor.AQUA) + kit.getName());
                ArrayList<Object> lore = new ArrayList<Object>();
                lore.add(String.valueOf(ChatColor.GRAY) + "ID: " + kit.getId());
                lore.add("");
                lore.add(String.valueOf(ChatColor.DARK_AQUA) + "Click to select");
                meta.setLore(lore);
                item.setItemMeta(meta);
            }
            this.setData(item, kit.getId());
            inv.setItem(slot++, item);
        }
        player.openInventory(inv);
    }

    public void openDuelMenu(Player player, Player target) {
        Inventory inv = Bukkit.createInventory(null, (int)27, (String)this.DUEL_MENU);
        inv.setItem(11, this.createItem(Material.DIAMOND_SWORD, String.valueOf(ChatColor.AQUA) + "Select Kit", String.valueOf(ChatColor.GRAY) + "Choose your kit", "", String.valueOf(ChatColor.DARK_AQUA) + "Click to select"));
        inv.setItem(13, this.createItem(Material.MAP, String.valueOf(ChatColor.AQUA) + "Select Arena", String.valueOf(ChatColor.GRAY) + "Choose an arena", "", String.valueOf(ChatColor.DARK_AQUA) + "Click to select"));
        inv.setItem(15, this.createItem(Material.GOLD_INGOT, String.valueOf(ChatColor.AQUA) + "Set Wager", String.valueOf(ChatColor.GRAY) + "Current: $0", "", String.valueOf(ChatColor.DARK_AQUA) + "Click to change"));
        inv.setItem(22, this.createItem(Material.EMERALD, String.valueOf(ChatColor.GREEN) + "Send Challenge", String.valueOf(ChatColor.GRAY) + "To: " + target.getName(), "", String.valueOf(ChatColor.DARK_AQUA) + "Click to send"));
        this.setData(inv.getItem(22), target.getName());
        player.openInventory(inv);
    }

    @EventHandler
    public void onClick(InventoryClickEvent event) {
        HumanEntity humanEntity = event.getWhoClicked();
        if (!(humanEntity instanceof Player)) {
            return;
        }
        Player player = (Player)humanEntity;
        String title = event.getView().getTitle();
        ItemStack item = event.getCurrentItem();
        if (item == null || item.getType() == Material.AIR) {
            return;
        }
        if (title.equals(this.ARENA_MENU)) {
            event.setCancelled(true);
            String arenaId = this.getData(item);
            if (arenaId != null) {
                player.closeInventory();
                Arena arena = this.plugin.getArenaManager().get(arenaId);
                if (arena != null) {
                    this.plugin.getQueueManager().addToQueue(player, arena);
                }
            }
        } else if (title.equals(this.KIT_MENU)) {
            event.setCancelled(true);
            String kitId = this.getData(item);
            if (kitId != null) {
                player.closeInventory();
                Kit kit = this.plugin.getKitManager().get(kitId);
                if (kit != null) {
                    Msg.success((CommandSender)player, "Selected kit: " + Msg.accent(kit.getName()));
                }
            }
        } else if (title.equals(this.DUEL_MENU)) {
            Player target;
            String targetName;
            event.setCancelled(true);
            int slot = event.getSlot();
            if (slot == 11) {
                this.openKitMenu(player);
            } else if (slot == 13) {
                this.openArenaMenu(player);
            } else if (slot == 22 && (targetName = this.getData(item)) != null && (target = Bukkit.getPlayer((String)targetName)) != null) {
                player.closeInventory();
                player.performCommand("duel " + target.getName());
            }
        }
    }

    private ItemStack createItem(Material material, String name, String ... lore) {
        ItemStack item = new ItemStack(material);
        ItemMeta meta = item.getItemMeta();
        if (meta != null) {
            meta.setDisplayName(name);
            ArrayList<String> loreList = new ArrayList<String>();
            for (String line : lore) {
                loreList.add(line);
            }
            meta.setLore(loreList);
            item.setItemMeta(meta);
        }
        return item;
    }

    private void setData(ItemStack item, String data) {
        if (item == null) {
            return;
        }
        ItemMeta meta = item.getItemMeta();
        if (meta != null) {
            ArrayList<CallSite> lore = meta.getLore();
            if (lore == null) {
                lore = new ArrayList<CallSite>();
            }
            lore.add((CallSite)((Object)(String.valueOf(ChatColor.BLACK) + String.valueOf(ChatColor.MAGIC) + data)));
            meta.setLore(lore);
            item.setItemMeta(meta);
        }
    }

    private String getData(ItemStack item) {
        if (item == null || !item.hasItemMeta()) {
            return null;
        }
        ItemMeta meta = item.getItemMeta();
        if (meta == null || !meta.hasLore()) {
            return null;
        }
        List lore = meta.getLore();
        if (lore == null || lore.isEmpty()) {
            return null;
        }
        String last = (String)lore.get(lore.size() - 1);
        if (last.startsWith(String.valueOf(ChatColor.BLACK) + String.valueOf(ChatColor.MAGIC))) {
            return ChatColor.stripColor((String)last.substring(4));
        }
        return null;
    }
}

