/*
 * Decompiled with CFR 0.152.
 */
package AM.arenaMaker.gui;

import AM.arenaMaker.ArenaMaker;
import AM.arenaMaker.game.GameSession;
import AM.arenaMaker.shop.Shop;
import AM.arenaMaker.shop.ShopItem;
import AM.arenaMaker.shop.ShopTier;
import AM.arenaMaker.util.Msg;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.plugin.Plugin;

public class ShopGUI
implements Listener {
    private final ArenaMaker plugin;
    private final String SHOP_TITLE = String.valueOf(ChatColor.DARK_AQUA) + "Wave Shop";

    public ShopGUI(ArenaMaker plugin) {
        this.plugin = plugin;
        plugin.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)plugin);
    }

    public void open(Player player, Shop shop) {
        ItemStack info;
        ItemMeta infoMeta;
        GameSession session = this.plugin.getGameManager().getPlayerSession(player.getUniqueId());
        int playerPoints = session != null ? session.getPoints().getPoints(player.getUniqueId()) : 0;
        int currentWave = session != null ? session.getCurrentWave() : 0;
        double priceMult = session != null ? session.getPriceMult() : 1.0;
        Collection<ShopItem> items = shop.getItems();
        int size = Math.max(27, (items.size() / 9 + 1) * 9);
        size = Math.min(54, size);
        Inventory inv = Bukkit.createInventory(null, (int)size, (String)this.SHOP_TITLE);
        int slot = 0;
        for (ShopItem item : items) {
            ItemStack display = item.getDisplayItem(currentWave, playerPoints, priceMult);
            this.addItemId(display, item.getId());
            inv.setItem(slot++, display);
            if (slot < size - 9) continue;
            break;
        }
        if ((infoMeta = (info = new ItemStack(Material.GOLD_INGOT)).getItemMeta()) != null) {
            ArrayList<CallSite> infoLore = new ArrayList<CallSite>();
            infoMeta.setDisplayName(String.valueOf(ChatColor.GREEN) + "Your Points: " + playerPoints);
            infoLore.add((CallSite)((Object)(String.valueOf(ChatColor.GRAY) + "Wave: " + currentWave)));
            if (session != null) {
                ShopTier highest = ShopTier.getHighestUnlocked(currentWave);
                infoLore.add((CallSite)((Object)(String.valueOf(highest.getColor()) + "Tier: " + highest.getDisplay())));
            }
            infoMeta.setLore(infoLore);
            info.setItemMeta(infoMeta);
        }
        inv.setItem(size - 5, info);
        ItemStack close = new ItemStack(Material.BARRIER);
        ItemMeta closeMeta = close.getItemMeta();
        if (closeMeta != null) {
            closeMeta.setDisplayName(String.valueOf(ChatColor.RED) + "Close");
            close.setItemMeta(closeMeta);
        }
        inv.setItem(size - 1, close);
        player.openInventory(inv);
    }

    private void addItemId(ItemStack item, String id) {
        if (item == null) {
            return;
        }
        ItemMeta meta = item.getItemMeta();
        if (meta != null) {
            ArrayList<CallSite> lore = meta.getLore();
            if (lore == null) {
                lore = new ArrayList<CallSite>();
            }
            lore.add((CallSite)((Object)(String.valueOf(ChatColor.BLACK) + String.valueOf(ChatColor.MAGIC) + id)));
            meta.setLore(lore);
            item.setItemMeta(meta);
        }
    }

    @EventHandler
    public void onClick(InventoryClickEvent event) {
        ShopItem shopItem;
        HumanEntity humanEntity = event.getWhoClicked();
        if (!(humanEntity instanceof Player)) {
            return;
        }
        Player player = (Player)humanEntity;
        if (!event.getView().getTitle().equals(this.SHOP_TITLE)) {
            return;
        }
        event.setCancelled(true);
        ItemStack clicked = event.getCurrentItem();
        if (clicked == null || clicked.getType() == Material.AIR) {
            return;
        }
        if (clicked.getType() == Material.BARRIER) {
            player.closeInventory();
            return;
        }
        if (clicked.getType() == Material.GOLD_INGOT) {
            return;
        }
        String itemId = this.getItemId(clicked);
        if (itemId == null) {
            return;
        }
        GameSession session = this.plugin.getGameManager().getPlayerSession(player.getUniqueId());
        if (session == null) {
            Msg.error((CommandSender)player, "You're not in a game.");
            player.closeInventory();
            return;
        }
        Shop shop = session.getShop();
        if (shop == null) {
            shop = this.plugin.getShopManager().getDefault();
        }
        if ((shopItem = shop.getItem(itemId)) == null) {
            Msg.error((CommandSender)player, "Item not found.");
            return;
        }
        int currentWave = session.getCurrentWave();
        double priceMult = session.getPriceMult();
        int playerPoints = session.getPoints().getPoints(player.getUniqueId());
        int purchases = this.plugin.getShopManager().getPurchaseCount(player.getUniqueId(), itemId);
        int adjustedCost = shopItem.getAdjustedCost(priceMult);
        if (!shopItem.isUnlocked(currentWave)) {
            Msg.error((CommandSender)player, "Unlocks at wave " + shopItem.getTier().getWaveUnlock() + ".");
            return;
        }
        if (shopItem.getMaxPurchases() > 0 && purchases >= shopItem.getMaxPurchases()) {
            Msg.error((CommandSender)player, "Max purchases reached for this item.");
            return;
        }
        if (playerPoints < adjustedCost) {
            Msg.error((CommandSender)player, "Not enough points! Need " + adjustedCost + ".");
            return;
        }
        if (!session.getPoints().removePoints(player, adjustedCost)) {
            Msg.error((CommandSender)player, "Failed to purchase.");
            return;
        }
        shopItem.give(player);
        this.plugin.getShopManager().addPurchase(player.getUniqueId(), itemId);
        Msg.success((CommandSender)player, "Purchased " + Msg.accent(shopItem.getName()) + "!");
        this.open(player, shop);
    }

    private String getItemId(ItemStack item) {
        if (item == null || !item.hasItemMeta()) {
            return null;
        }
        ItemMeta meta = item.getItemMeta();
        if (meta == null || !meta.hasLore()) {
            return null;
        }
        List lore = meta.getLore();
        if (lore == null || lore.isEmpty()) {
            return null;
        }
        String last = (String)lore.get(lore.size() - 1);
        if (last.startsWith(String.valueOf(ChatColor.BLACK) + String.valueOf(ChatColor.MAGIC))) {
            return ChatColor.stripColor((String)last.substring(4));
        }
        return null;
    }
}

