/*
 * Decompiled with CFR 0.152.
 */
package AM.arenaMaker.hook;

import AM.arenaMaker.ArenaMaker;
import AM.arenaMaker.data.PlayerStats;
import AM.arenaMaker.duel.DuelMatch;
import java.util.List;
import me.clip.placeholderapi.expansion.PlaceholderExpansion;
import org.bukkit.OfflinePlayer;
import org.jetbrains.annotations.NotNull;

public class PAPIHook
extends PlaceholderExpansion {
    private final ArenaMaker plugin;

    public PAPIHook(ArenaMaker plugin) {
        this.plugin = plugin;
    }

    @NotNull
    public String getIdentifier() {
        return "arena";
    }

    @NotNull
    public String getAuthor() {
        return "ArenaMaker";
    }

    @NotNull
    public String getVersion() {
        return this.plugin.getDescription().getVersion();
    }

    public boolean persist() {
        return true;
    }

    public String onRequest(OfflinePlayer offlinePlayer, @NotNull String params) {
        String[] parts;
        if (offlinePlayer == null) {
            return "";
        }
        PlayerStats stats = this.plugin.getStatsManager().get(offlinePlayer.getUniqueId());
        switch (params.toLowerCase()) {
            case "wins": {
                return String.valueOf(stats.getWins());
            }
            case "losses": {
                return String.valueOf(stats.getLosses());
            }
            case "draws": {
                return String.valueOf(stats.getDraws());
            }
            case "streak": {
                return String.valueOf(stats.getStreak());
            }
            case "best_streak": {
                return String.valueOf(stats.getBestStreak());
            }
            case "elo": {
                return String.valueOf(stats.getElo());
            }
            case "rank": {
                return String.valueOf(this.plugin.getStatsManager().getRank(offlinePlayer.getUniqueId()));
            }
            case "winrate": {
                return String.format("%.1f", stats.getWinRate());
            }
            case "kdr": {
                return String.format("%.2f", stats.getKdr());
            }
            case "kills": {
                return String.valueOf(stats.getKills());
            }
            case "deaths": {
                return String.valueOf(stats.getDeaths());
            }
            case "matches": {
                return String.valueOf(stats.getTotalMatches());
            }
            case "earnings": {
                return this.plugin.getVaultHook().format(stats.getEarnings());
            }
            case "wagered": {
                return this.plugin.getVaultHook().format(stats.getWagered());
            }
            case "in_match": {
                return this.plugin.getDuelManager().isInMatch(offlinePlayer.getUniqueId()) ? "true" : "false";
            }
            case "in_queue": {
                return this.plugin.getQueueManager().isInQueue(offlinePlayer.getUniqueId()) ? "true" : "false";
            }
            case "queue_position": {
                int pos = this.plugin.getQueueManager().getQueuePosition(offlinePlayer.getUniqueId());
                return pos > 0 ? String.valueOf(pos) : "N/A";
            }
            case "current_arena": {
                DuelMatch match = this.plugin.getDuelManager().getPlayerMatch(offlinePlayer.getUniqueId());
                return match != null ? match.getArena().getName() : "None";
            }
            case "opponent": {
                if (!offlinePlayer.isOnline()) {
                    return "None";
                }
                DuelMatch match = this.plugin.getDuelManager().getPlayerMatch(offlinePlayer.getUniqueId());
                if (match == null) {
                    return "None";
                }
                OfflinePlayer opp = this.plugin.getServer().getOfflinePlayer(match.getOpponent(offlinePlayer.getUniqueId()));
                return opp.getName() != null ? opp.getName() : "Unknown";
            }
            case "time_left": {
                DuelMatch match = this.plugin.getDuelManager().getPlayerMatch(offlinePlayer.getUniqueId());
                if (match == null) {
                    return "0:00";
                }
                int secs = match.getTimeLeft();
                return String.format("%d:%02d", secs / 60, secs % 60);
            }
            case "active_matches": {
                return String.valueOf(this.plugin.getDuelManager().getActiveMatchCount());
            }
            case "arena_count": {
                return String.valueOf(this.plugin.getArenaManager().count());
            }
            case "kit_count": {
                return String.valueOf(this.plugin.getKitManager().count());
            }
        }
        if (params.startsWith("top_") && (parts = params.split("_")).length >= 3) {
            List<PlayerStats> topList;
            int position;
            String type = parts[1];
            try {
                position = Integer.parseInt(parts[2]);
            }
            catch (NumberFormatException e) {
                return "";
            }
            switch (type) {
                case "wins": {
                    List<PlayerStats> list = this.plugin.getStatsManager().getTopByWins(position);
                    break;
                }
                case "streak": {
                    List<PlayerStats> list = this.plugin.getStatsManager().getTopByStreak(position);
                    break;
                }
                case "earnings": {
                    List<PlayerStats> list = this.plugin.getStatsManager().getTopByEarnings(position);
                    break;
                }
                default: {
                    List<PlayerStats> list = topList = this.plugin.getStatsManager().getTopByElo(position);
                }
            }
            if (position > 0 && position <= topList.size()) {
                PlayerStats topStats = topList.get(position - 1);
                OfflinePlayer topPlayer = this.plugin.getServer().getOfflinePlayer(topStats.getUuid());
                if (parts.length >= 4 && parts[3].equals("name")) {
                    return topPlayer.getName() != null ? topPlayer.getName() : "Unknown";
                }
                if (parts.length >= 4 && parts[3].equals("value")) {
                    return switch (type) {
                        case "wins" -> String.valueOf(topStats.getWins());
                        case "streak" -> String.valueOf(topStats.getBestStreak());
                        case "earnings" -> this.plugin.getVaultHook().format(topStats.getEarnings());
                        default -> String.valueOf(topStats.getElo());
                    };
                }
            }
        }
        return null;
    }
}

