/*
 * Decompiled with CFR 0.152.
 */
package AM.arenaMaker.hook;

import net.milkbowl.vault.economy.Economy;
import net.milkbowl.vault.economy.EconomyResponse;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;
import org.bukkit.plugin.RegisteredServiceProvider;

public class VaultHook {
    private Economy economy;
    private boolean enabled;

    public VaultHook() {
        if (Bukkit.getPluginManager().getPlugin("Vault") == null) {
            return;
        }
        RegisteredServiceProvider rsp = Bukkit.getServicesManager().getRegistration(Economy.class);
        if (rsp != null) {
            this.economy = (Economy)rsp.getProvider();
            this.enabled = true;
        }
    }

    public boolean isEnabled() {
        return this.enabled && this.economy != null;
    }

    public double getBalance(Player player) {
        if (!this.isEnabled()) {
            return 0.0;
        }
        return this.economy.getBalance((OfflinePlayer)player);
    }

    public double getBalance(OfflinePlayer player) {
        if (!this.isEnabled()) {
            return 0.0;
        }
        return this.economy.getBalance(player);
    }

    public boolean has(Player player, double amount) {
        if (!this.isEnabled()) {
            return false;
        }
        return this.economy.has((OfflinePlayer)player, amount);
    }

    public boolean withdraw(Player player, double amount) {
        if (!this.isEnabled()) {
            return false;
        }
        EconomyResponse response = this.economy.withdrawPlayer((OfflinePlayer)player, amount);
        return response.transactionSuccess();
    }

    public boolean deposit(Player player, double amount) {
        if (!this.isEnabled()) {
            return false;
        }
        EconomyResponse response = this.economy.depositPlayer((OfflinePlayer)player, amount);
        return response.transactionSuccess();
    }

    public boolean deposit(OfflinePlayer player, double amount) {
        if (!this.isEnabled()) {
            return false;
        }
        EconomyResponse response = this.economy.depositPlayer(player, amount);
        return response.transactionSuccess();
    }

    public boolean transfer(Player from, Player to, double amount) {
        if (!this.isEnabled()) {
            return false;
        }
        if (!this.has(from, amount)) {
            return false;
        }
        if (!this.withdraw(from, amount)) {
            return false;
        }
        if (!this.deposit(to, amount)) {
            this.deposit(from, amount);
            return false;
        }
        return true;
    }

    public String format(double amount) {
        if (!this.isEnabled()) {
            return String.format("$%.2f", amount);
        }
        return this.economy.format(amount);
    }

    public String getCurrencyName() {
        if (!this.isEnabled()) {
            return "coins";
        }
        return this.economy.currencyNamePlural();
    }
}

