/*
 * Decompiled with CFR 0.152.
 */
package AM.arenaMaker.hook;

import com.sk89q.worldedit.IncompleteRegionException;
import com.sk89q.worldedit.LocalSession;
import com.sk89q.worldedit.WorldEdit;
import com.sk89q.worldedit.bukkit.BukkitAdapter;
import com.sk89q.worldedit.bukkit.WorldEditPlugin;
import com.sk89q.worldedit.math.BlockVector3;
import com.sk89q.worldedit.regions.CuboidRegion;
import com.sk89q.worldedit.regions.Region;
import com.sk89q.worldedit.session.SessionOwner;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

public class WEHook {
    private WorldEditPlugin we;
    private boolean enabled;

    public WEHook() {
        Plugin plugin = Bukkit.getPluginManager().getPlugin("WorldEdit");
        if (plugin instanceof WorldEditPlugin) {
            this.we = (WorldEditPlugin)plugin;
            this.enabled = true;
        }
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public Location[] getSelection(Player player) {
        if (!this.enabled) {
            return null;
        }
        try {
            LocalSession session = WorldEdit.getInstance().getSessionManager().get((SessionOwner)BukkitAdapter.adapt((Player)player));
            Region region = session.getSelection(BukkitAdapter.adapt((World)player.getWorld()));
            if (region instanceof CuboidRegion) {
                CuboidRegion cuboid = (CuboidRegion)region;
                BlockVector3 min = cuboid.getMinimumPoint();
                BlockVector3 max = cuboid.getMaximumPoint();
                Location pos1 = new Location(player.getWorld(), (double)min.getX(), (double)min.getY(), (double)min.getZ());
                Location pos2 = new Location(player.getWorld(), (double)max.getX(), (double)max.getY(), (double)max.getZ());
                return new Location[]{pos1, pos2};
            }
        }
        catch (IncompleteRegionException e) {
            return null;
        }
        return null;
    }

    public boolean hasSelection(Player player) {
        return this.getSelection(player) != null;
    }
}

