/*
 * Decompiled with CFR 0.152.
 */
package AM.arenaMaker.hook;

import com.sk89q.worldedit.bukkit.BukkitAdapter;
import com.sk89q.worldedit.math.BlockVector3;
import com.sk89q.worldguard.WorldGuard;
import com.sk89q.worldguard.bukkit.WorldGuardPlugin;
import com.sk89q.worldguard.protection.flags.Flag;
import com.sk89q.worldguard.protection.flags.Flags;
import com.sk89q.worldguard.protection.flags.StateFlag;
import com.sk89q.worldguard.protection.managers.RegionManager;
import com.sk89q.worldguard.protection.regions.ProtectedCuboidRegion;
import com.sk89q.worldguard.protection.regions.ProtectedRegion;
import com.sk89q.worldguard.protection.regions.RegionContainer;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.plugin.Plugin;

public class WGHook {
    private boolean enabled;

    public WGHook() {
        Plugin plugin = Bukkit.getPluginManager().getPlugin("WorldGuard");
        if (plugin instanceof WorldGuardPlugin) {
            this.enabled = true;
        }
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public String createRegion(String id, Location pos1, Location pos2) {
        if (!this.enabled) {
            return null;
        }
        World world = pos1.getWorld();
        RegionContainer container = WorldGuard.getInstance().getPlatform().getRegionContainer();
        RegionManager manager = container.get(BukkitAdapter.adapt((World)world));
        if (manager == null) {
            return null;
        }
        String regionId = "arena_" + id.toLowerCase();
        BlockVector3 min = BlockVector3.at((int)Math.min(pos1.getBlockX(), pos2.getBlockX()), (int)Math.min(pos1.getBlockY(), pos2.getBlockY()), (int)Math.min(pos1.getBlockZ(), pos2.getBlockZ()));
        BlockVector3 max = BlockVector3.at((int)Math.max(pos1.getBlockX(), pos2.getBlockX()), (int)Math.max(pos1.getBlockY(), pos2.getBlockY()), (int)Math.max(pos1.getBlockZ(), pos2.getBlockZ()));
        ProtectedCuboidRegion region = new ProtectedCuboidRegion(regionId, min, max);
        region.setFlag((Flag)Flags.PVP, (Object)StateFlag.State.ALLOW);
        region.setFlag((Flag)Flags.BUILD, (Object)StateFlag.State.DENY);
        region.setFlag((Flag)Flags.BLOCK_BREAK, (Object)StateFlag.State.DENY);
        region.setFlag((Flag)Flags.BLOCK_PLACE, (Object)StateFlag.State.DENY);
        region.setFlag((Flag)Flags.MOB_SPAWNING, (Object)StateFlag.State.DENY);
        region.setFlag((Flag)Flags.ITEM_DROP, (Object)StateFlag.State.DENY);
        manager.addRegion((ProtectedRegion)region);
        return regionId;
    }

    public boolean removeRegion(String regionId, World world) {
        if (!this.enabled || regionId == null) {
            return false;
        }
        RegionContainer container = WorldGuard.getInstance().getPlatform().getRegionContainer();
        RegionManager manager = container.get(BukkitAdapter.adapt((World)world));
        if (manager == null) {
            return false;
        }
        ProtectedRegion region = manager.getRegion(regionId);
        if (region == null) {
            return false;
        }
        manager.removeRegion(regionId);
        return true;
    }

    public boolean regionExists(String regionId, World world) {
        if (!this.enabled || regionId == null) {
            return false;
        }
        RegionContainer container = WorldGuard.getInstance().getPlatform().getRegionContainer();
        RegionManager manager = container.get(BukkitAdapter.adapt((World)world));
        if (manager == null) {
            return false;
        }
        return manager.getRegion(regionId) != null;
    }

    public void updateRegionFlags(String regionId, World world, boolean pvpEnabled) {
        if (!this.enabled || regionId == null) {
            return;
        }
        RegionContainer container = WorldGuard.getInstance().getPlatform().getRegionContainer();
        RegionManager manager = container.get(BukkitAdapter.adapt((World)world));
        if (manager == null) {
            return;
        }
        ProtectedRegion region = manager.getRegion(regionId);
        if (region == null) {
            return;
        }
        region.setFlag((Flag)Flags.PVP, (Object)(pvpEnabled ? StateFlag.State.ALLOW : StateFlag.State.DENY));
    }
}

