/*
 * Decompiled with CFR 0.152.
 */
package AM.arenaMaker.kit;

import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.Material;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;

public class Kit {
    private final String id;
    private String name;
    private String icon;
    private ItemStack[] armor;
    private ItemStack[] items;
    private List<PotionEffect> effects;

    public Kit(String id) {
        this.id = id;
        this.name = id;
        this.icon = "DIAMOND_SWORD";
        this.armor = new ItemStack[4];
        this.items = new ItemStack[36];
        this.effects = new ArrayList<PotionEffect>();
    }

    public String getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getIcon() {
        return this.icon;
    }

    public void setIcon(String icon) {
        this.icon = icon;
    }

    public ItemStack[] getArmor() {
        return this.armor;
    }

    public void setArmor(ItemStack[] armor) {
        this.armor = armor;
    }

    public ItemStack[] getItems() {
        return this.items;
    }

    public void setItems(ItemStack[] items) {
        this.items = items;
    }

    public List<PotionEffect> getEffects() {
        return this.effects;
    }

    public void addEffect(PotionEffect effect) {
        this.effects.add(effect);
    }

    public void apply(Player player) {
        player.getInventory().clear();
        player.getInventory().setArmorContents(this.armor);
        player.getInventory().setContents(this.items);
        for (PotionEffect effect : player.getActivePotionEffects()) {
            player.removePotionEffect(effect.getType());
        }
        for (PotionEffect effect : this.effects) {
            player.addPotionEffect(effect);
        }
        player.updateInventory();
    }

    public void loadFromPlayer(Player player) {
        this.armor = (ItemStack[])player.getInventory().getArmorContents().clone();
        this.items = (ItemStack[])player.getInventory().getContents().clone();
    }

    public void save(ConfigurationSection section) {
        int i;
        section.set("name", (Object)this.name);
        section.set("icon", (Object)this.icon);
        for (i = 0; i < this.armor.length; ++i) {
            if (this.armor[i] == null) continue;
            section.set("armor." + i, (Object)this.armor[i]);
        }
        for (i = 0; i < this.items.length; ++i) {
            if (this.items[i] == null) continue;
            section.set("items." + i, (Object)this.items[i]);
        }
        ArrayList<CallSite> effectList = new ArrayList<CallSite>();
        for (PotionEffect effect : this.effects) {
            effectList.add((CallSite)((Object)(effect.getType().getName() + ":" + effect.getDuration() + ":" + effect.getAmplifier())));
        }
        section.set("effects", effectList);
    }

    public static Kit load(String id, ConfigurationSection section) {
        ConfigurationSection itemsSection;
        Kit kit = new Kit(id);
        kit.name = section.getString("name", id);
        kit.icon = section.getString("icon", "DIAMOND_SWORD");
        ConfigurationSection armorSection = section.getConfigurationSection("armor");
        if (armorSection != null) {
            for (Object key : armorSection.getKeys(false)) {
                int slot = Integer.parseInt((String)key);
                kit.armor[slot] = armorSection.getItemStack((String)key);
            }
        }
        if ((itemsSection = section.getConfigurationSection("items")) != null) {
            for (String key : itemsSection.getKeys(false)) {
                int slot = Integer.parseInt(key);
                kit.items[slot] = itemsSection.getItemStack(key);
            }
        }
        List effectList = section.getStringList("effects");
        for (String effectStr : effectList) {
            PotionEffectType type;
            String[] parts = effectStr.split(":");
            if (parts.length < 3 || (type = PotionEffectType.getByName((String)parts[0])) == null) continue;
            int duration = Integer.parseInt(parts[1]);
            int amplifier = Integer.parseInt(parts[2]);
            kit.effects.add(new PotionEffect(type, duration, amplifier));
        }
        return kit;
    }

    public ItemStack getIconItem() {
        ItemStack item;
        ItemMeta meta;
        Material mat = Material.getMaterial((String)this.icon);
        if (mat == null) {
            mat = Material.DIAMOND_SWORD;
        }
        if ((meta = (item = new ItemStack(mat)).getItemMeta()) != null) {
            meta.setDisplayName(this.name);
            item.setItemMeta(meta);
        }
        return item;
    }
}

