/*
 * Decompiled with CFR 0.152.
 */
package AM.arenaMaker.kit;

import AM.arenaMaker.ArenaMaker;
import AM.arenaMaker.kit.Kit;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Player;

public class KitManager {
    private final ArenaMaker plugin;
    private final Map<String, Kit> kits;
    private final File file;
    private FileConfiguration data;

    public KitManager(ArenaMaker plugin) {
        this.plugin = plugin;
        this.kits = new HashMap<String, Kit>();
        this.file = new File(plugin.getDataFolder(), "kits.yml");
        this.load();
        this.createDefaults();
    }

    public Kit create(String id) {
        if (this.kits.containsKey(id.toLowerCase())) {
            return null;
        }
        Kit kit = new Kit(id.toLowerCase());
        this.kits.put(id.toLowerCase(), kit);
        this.save();
        return kit;
    }

    public Kit createFromPlayer(String id, Player player) {
        Kit kit = this.create(id);
        if (kit == null) {
            return null;
        }
        kit.loadFromPlayer(player);
        this.save();
        return kit;
    }

    public Kit get(String id) {
        return this.kits.get(id.toLowerCase());
    }

    public boolean exists(String id) {
        return this.kits.containsKey(id.toLowerCase());
    }

    public boolean delete(String id) {
        if (this.kits.remove(id.toLowerCase()) == null) {
            return false;
        }
        this.save();
        return true;
    }

    public Collection<Kit> getAll() {
        return this.kits.values();
    }

    public int count() {
        return this.kits.size();
    }

    public void load() {
        this.kits.clear();
        if (!this.file.exists()) {
            this.data = new YamlConfiguration();
            return;
        }
        this.data = YamlConfiguration.loadConfiguration((File)this.file);
        ConfigurationSection section = this.data.getConfigurationSection("kits");
        if (section == null) {
            return;
        }
        for (String key : section.getKeys(false)) {
            ConfigurationSection kitSection = section.getConfigurationSection(key);
            if (kitSection == null) continue;
            Kit kit = Kit.load(key, kitSection);
            this.kits.put(key.toLowerCase(), kit);
        }
    }

    public void save() {
        this.data = new YamlConfiguration();
        for (Kit kit : this.kits.values()) {
            ConfigurationSection section = this.data.createSection("kits." + kit.getId());
            kit.save(section);
        }
        try {
            this.data.save(this.file);
        }
        catch (IOException e) {
            this.plugin.getLogger().severe("Failed to save kits: " + e.getMessage());
        }
    }

    private void createDefaults() {
        if (this.kits.isEmpty()) {
            Kit pvp = new Kit("pvp");
            pvp.setName("PvP Kit");
            pvp.setIcon("DIAMOND_SWORD");
            this.kits.put("pvp", pvp);
            Kit archer = new Kit("archer");
            archer.setName("Archer Kit");
            archer.setIcon("BOW");
            this.kits.put("archer", archer);
            Kit tank = new Kit("tank");
            tank.setName("Tank Kit");
            tank.setIcon("DIAMOND_CHESTPLATE");
            this.kits.put("tank", tank);
            this.save();
        }
    }
}

