/*
 * Decompiled with CFR 0.152.
 */
package AM.arenaMaker.listener;

import AM.arenaMaker.ArenaMaker;
import AM.arenaMaker.duel.DuelMatch;
import org.bukkit.entity.Entity;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.event.entity.EntityPickupItemEvent;
import org.bukkit.event.entity.FoodLevelChangeEvent;
import org.bukkit.event.entity.PlayerDeathEvent;
import org.bukkit.event.player.PlayerCommandPreprocessEvent;
import org.bukkit.event.player.PlayerDropItemEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.event.player.PlayerRespawnEvent;
import org.bukkit.event.player.PlayerTeleportEvent;

public class DuelListener
implements Listener {
    private final ArenaMaker plugin;

    public DuelListener(ArenaMaker plugin) {
        this.plugin = plugin;
    }

    @EventHandler(priority=EventPriority.HIGH)
    public void onDeath(PlayerDeathEvent event) {
        Player player = event.getEntity();
        DuelMatch match = this.plugin.getDuelManager().getPlayerMatch(player.getUniqueId());
        if (match == null) {
            return;
        }
        event.setKeepInventory(true);
        event.setKeepLevel(true);
        event.getDrops().clear();
        event.setDroppedExp(0);
        Player killer = player.getKiller();
        this.plugin.getDuelManager().handleDeath(player, killer);
    }

    @EventHandler
    public void onRespawn(PlayerRespawnEvent event) {
        Player player = event.getPlayer();
        DuelMatch match = this.plugin.getDuelManager().getPlayerMatch(player.getUniqueId());
        if (match != null && match.getArena().getLobby() != null) {
            event.setRespawnLocation(match.getArena().getLobby());
        }
    }

    @EventHandler
    public void onQuit(PlayerQuitEvent event) {
        this.plugin.getDuelManager().handleQuit(event.getPlayer());
        this.plugin.getQueueManager().handleQuit(event.getPlayer());
    }

    @EventHandler
    public void onDamage(EntityDamageEvent event) {
        Entity entity = event.getEntity();
        if (!(entity instanceof Player)) {
            return;
        }
        Player player = (Player)entity;
        DuelMatch match = this.plugin.getDuelManager().getPlayerMatch(player.getUniqueId());
        if (match == null) {
            return;
        }
        if (match.getState() != DuelMatch.State.ACTIVE) {
            event.setCancelled(true);
            return;
        }
        if (event.getCause() == EntityDamageEvent.DamageCause.FALL) {
            event.setCancelled(true);
        }
    }

    @EventHandler
    public void onPvP(EntityDamageByEntityEvent event) {
        Entity entity = event.getEntity();
        if (!(entity instanceof Player)) {
            return;
        }
        Player victim = (Player)entity;
        Entity entity2 = event.getDamager();
        if (!(entity2 instanceof Player)) {
            return;
        }
        Player attacker = (Player)entity2;
        DuelMatch victimMatch = this.plugin.getDuelManager().getPlayerMatch(victim.getUniqueId());
        DuelMatch attackerMatch = this.plugin.getDuelManager().getPlayerMatch(attacker.getUniqueId());
        if (victimMatch == null && attackerMatch == null) {
            return;
        }
        if (victimMatch != attackerMatch) {
            event.setCancelled(true);
            return;
        }
        if (victimMatch != null && victimMatch.getState() != DuelMatch.State.ACTIVE) {
            event.setCancelled(true);
        }
    }

    @EventHandler
    public void onHunger(FoodLevelChangeEvent event) {
        HumanEntity humanEntity = event.getEntity();
        if (!(humanEntity instanceof Player)) {
            return;
        }
        Player player = (Player)humanEntity;
        DuelMatch match = this.plugin.getDuelManager().getPlayerMatch(player.getUniqueId());
        if (match != null) {
            event.setCancelled(true);
            player.setFoodLevel(20);
        }
    }

    @EventHandler
    public void onCommand(PlayerCommandPreprocessEvent event) {
        Player player = event.getPlayer();
        DuelMatch match = this.plugin.getDuelManager().getPlayerMatch(player.getUniqueId());
        if (match == null) {
            return;
        }
        String cmd = event.getMessage().toLowerCase();
        if (cmd.startsWith("/duel") || cmd.startsWith("/arena") || cmd.startsWith("/msg") || cmd.startsWith("/r") || cmd.startsWith("/tell")) {
            return;
        }
        if (player.hasPermission("arena.bypass")) {
            return;
        }
        event.setCancelled(true);
    }

    @EventHandler
    public void onTeleport(PlayerTeleportEvent event) {
        Player player = event.getPlayer();
        DuelMatch match = this.plugin.getDuelManager().getPlayerMatch(player.getUniqueId());
        if (match == null) {
            return;
        }
        if (match.getState() == DuelMatch.State.ACTIVE) {
            if (event.getCause() == PlayerTeleportEvent.TeleportCause.ENDER_PEARL) {
                return;
            }
            if (!player.hasPermission("arena.bypass")) {
                event.setCancelled(true);
            }
        }
    }

    @EventHandler
    public void onDrop(PlayerDropItemEvent event) {
        Player player = event.getPlayer();
        DuelMatch match = this.plugin.getDuelManager().getPlayerMatch(player.getUniqueId());
        if (match != null) {
            event.setCancelled(true);
        }
    }

    @EventHandler
    public void onPickup(EntityPickupItemEvent event) {
        LivingEntity livingEntity = event.getEntity();
        if (!(livingEntity instanceof Player)) {
            return;
        }
        Player player = (Player)livingEntity;
        DuelMatch match = this.plugin.getDuelManager().getPlayerMatch(player.getUniqueId());
        if (match != null) {
            event.setCancelled(true);
        }
    }
}

