/*
 * Decompiled with CFR 0.152.
 */
package AM.arenaMaker.listener;

import AM.arenaMaker.ArenaMaker;
import AM.arenaMaker.game.GameSession;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.entity.EntityDeathEvent;
import org.bukkit.event.entity.EntityTargetEvent;
import org.bukkit.event.entity.PlayerDeathEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.event.player.PlayerRespawnEvent;
import org.bukkit.metadata.MetadataValue;

public class GameListener
implements Listener {
    private final ArenaMaker plugin;

    public GameListener(ArenaMaker plugin) {
        this.plugin = plugin;
    }

    @EventHandler(priority=EventPriority.HIGH)
    public void onMobDeath(EntityDeathEvent event) {
        LivingEntity entity = event.getEntity();
        if (!entity.hasMetadata("arena_mob")) {
            return;
        }
        String sessionId = ((MetadataValue)entity.getMetadata("arena_mob").get(0)).asString();
        GameSession session = this.plugin.getGameManager().getSession(sessionId);
        if (session == null) {
            return;
        }
        event.setDroppedExp(0);
        event.getDrops().clear();
        Player killer = entity.getKiller();
        if (killer != null) {
            int points = 10;
            if (entity.hasMetadata("mob_points")) {
                points = ((MetadataValue)entity.getMetadata("mob_points").get(0)).asInt();
            }
            session.onMobKill(killer, points);
        }
        if (session.getSpawner() != null) {
            session.getSpawner().onMobDeath(entity.getUniqueId());
        }
    }

    @EventHandler(priority=EventPriority.HIGH)
    public void onPlayerDeath(PlayerDeathEvent event) {
        Player player = event.getEntity();
        GameSession session = this.plugin.getGameManager().getPlayerSession(player.getUniqueId());
        if (session == null) {
            return;
        }
        event.setKeepInventory(true);
        event.setKeepLevel(true);
        event.getDrops().clear();
        event.setDroppedExp(0);
        session.onPlayerDeath(player);
    }

    @EventHandler
    public void onRespawn(PlayerRespawnEvent event) {
        Player player = event.getPlayer();
        GameSession session = this.plugin.getGameManager().getPlayerSession(player.getUniqueId());
        if (session == null) {
            return;
        }
        if (session.getArena().getLobby() != null) {
            event.setRespawnLocation(session.getArena().getLobby());
        } else if (session.getArena().getSpawn1() != null) {
            event.setRespawnLocation(session.getArena().getSpawn1());
        }
    }

    @EventHandler
    public void onQuit(PlayerQuitEvent event) {
        this.plugin.getGameManager().handlePlayerQuit(event.getPlayer());
    }

    @EventHandler
    public void onMobTarget(EntityTargetEvent event) {
        Entity entity = event.getEntity();
        if (!entity.hasMetadata("arena_mob")) {
            return;
        }
        Entity target = event.getTarget();
        if (!(target instanceof Player)) {
            return;
        }
        Player player = (Player)target;
        String sessionId = ((MetadataValue)entity.getMetadata("arena_mob").get(0)).asString();
        GameSession session = this.plugin.getGameManager().getSession(sessionId);
        if (session == null || !session.isAlive(player.getUniqueId())) {
            event.setCancelled(true);
        }
    }

    @EventHandler
    public void onMobDamage(EntityDamageByEntityEvent event) {
        GameSession session;
        String sessionId;
        Player player;
        Entity damager = event.getDamager();
        Entity victim = event.getEntity();
        if (damager.hasMetadata("arena_mob") && victim instanceof Player) {
            player = (Player)victim;
            sessionId = ((MetadataValue)damager.getMetadata("arena_mob").get(0)).asString();
            session = this.plugin.getGameManager().getSession(sessionId);
            if (session == null || !session.isAlive(player.getUniqueId())) {
                event.setCancelled(true);
            }
        }
        if (victim.hasMetadata("arena_mob") && damager instanceof Player) {
            player = (Player)damager;
            sessionId = ((MetadataValue)victim.getMetadata("arena_mob").get(0)).asString();
            session = this.plugin.getGameManager().getSession(sessionId);
            if (session == null || !session.isPlayer(player.getUniqueId())) {
                event.setCancelled(true);
            }
        }
    }
}

