/*
 * Decompiled with CFR 0.152.
 */
package AM.arenaMaker.queue;

import AM.arenaMaker.ArenaMaker;
import AM.arenaMaker.arena.Arena;
import AM.arenaMaker.duel.DuelRequest;
import AM.arenaMaker.kit.Kit;
import AM.arenaMaker.util.Msg;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;

public class QueueManager {
    private final ArenaMaker plugin;
    private final Map<String, LinkedList<UUID>> arenaQueues;
    private final Map<UUID, String> playerQueue;

    public QueueManager(ArenaMaker plugin) {
        this.plugin = plugin;
        this.arenaQueues = new HashMap<String, LinkedList<UUID>>();
        this.playerQueue = new HashMap<UUID, String>();
        new BukkitRunnable(){

            public void run() {
                QueueManager.this.processQueues();
            }
        }.runTaskTimer((Plugin)plugin, 40L, 40L);
    }

    public boolean addToQueue(Player player, Arena arena) {
        if (this.isInQueue(player.getUniqueId())) {
            Msg.error((CommandSender)player, "You're already in a queue.");
            return false;
        }
        if (this.plugin.getDuelManager().isInMatch(player.getUniqueId())) {
            Msg.error((CommandSender)player, "You're already in a match.");
            return false;
        }
        LinkedList queue = this.arenaQueues.computeIfAbsent(arena.getId(), k -> new LinkedList());
        queue.add(player.getUniqueId());
        this.playerQueue.put(player.getUniqueId(), arena.getId());
        Msg.success((CommandSender)player, "Joined queue for " + Msg.accent(arena.getName()) + ".");
        Msg.send((CommandSender)player, "Position: " + Msg.accent(String.valueOf(queue.size())));
        return true;
    }

    public boolean removeFromQueue(Player player) {
        String arenaId = this.playerQueue.remove(player.getUniqueId());
        if (arenaId == null) {
            return false;
        }
        LinkedList<UUID> queue = this.arenaQueues.get(arenaId);
        if (queue != null) {
            queue.remove(player.getUniqueId());
        }
        Msg.send((CommandSender)player, "Left the queue.");
        return true;
    }

    public boolean isInQueue(UUID uuid) {
        return this.playerQueue.containsKey(uuid);
    }

    public int getQueuePosition(UUID uuid) {
        String arenaId = this.playerQueue.get(uuid);
        if (arenaId == null) {
            return -1;
        }
        LinkedList<UUID> queue = this.arenaQueues.get(arenaId);
        if (queue == null) {
            return -1;
        }
        int pos = 1;
        for (UUID id : queue) {
            if (id.equals(uuid)) {
                return pos;
            }
            ++pos;
        }
        return -1;
    }

    public int getQueueSize(String arenaId) {
        LinkedList<UUID> queue = this.arenaQueues.get(arenaId);
        return queue == null ? 0 : queue.size();
    }

    private void processQueues() {
        for (Map.Entry<String, LinkedList<UUID>> entry : this.arenaQueues.entrySet()) {
            Arena arena;
            String arenaId = entry.getKey();
            LinkedList<UUID> queue = entry.getValue();
            if (queue.size() < 2 || (arena = this.plugin.getArenaManager().get(arenaId)) == null || !arena.isEnabled() || this.plugin.getDuelManager().isArenaBusy(arenaId)) continue;
            UUID uuid1 = queue.poll();
            UUID uuid2 = queue.poll();
            if (uuid1 == null || uuid2 == null) continue;
            this.playerQueue.remove(uuid1);
            this.playerQueue.remove(uuid2);
            Player p1 = Bukkit.getPlayer((UUID)uuid1);
            Player p2 = Bukkit.getPlayer((UUID)uuid2);
            if (p1 == null || p2 == null) {
                if (p1 != null) {
                    queue.addFirst(uuid1);
                    this.playerQueue.put(uuid1, arenaId);
                }
                if (p2 == null) continue;
                queue.addFirst(uuid2);
                this.playerQueue.put(uuid2, arenaId);
                continue;
            }
            Kit kit = this.plugin.getKitManager().get("pvp");
            int duration = Math.max(30, this.plugin.getConfig().getInt("duel.default-duration", 300));
            DuelRequest request = new DuelRequest(uuid1, uuid2, arena, kit, 0.0, duration);
            this.plugin.getDuelManager().startMatch(request);
            Msg.success((CommandSender)p1, "Match found! Fighting " + Msg.accent(p2.getName()));
            Msg.success((CommandSender)p2, "Match found! Fighting " + Msg.accent(p1.getName()));
        }
    }

    public void handleQuit(Player player) {
        this.removeFromQueue(player);
    }
}

