/*
 * Decompiled with CFR 0.152.
 */
package AM.arenaMaker.reward;

import AM.arenaMaker.ArenaMaker;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;

public class Reward {
    private final String id;
    private String name;
    private double money;
    private int xp;
    private List<ItemStack> items;
    private List<String> commands;

    public Reward(String id) {
        this.id = id;
        this.name = id;
        this.money = 0.0;
        this.xp = 0;
        this.items = new ArrayList<ItemStack>();
        this.commands = new ArrayList<String>();
    }

    public String getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public double getMoney() {
        return this.money;
    }

    public void setMoney(double money) {
        this.money = money;
    }

    public int getXp() {
        return this.xp;
    }

    public void setXp(int xp) {
        this.xp = xp;
    }

    public List<ItemStack> getItems() {
        return this.items;
    }

    public void addItem(ItemStack item) {
        this.items.add(item);
    }

    public List<String> getCommands() {
        return this.commands;
    }

    public void addCommand(String command) {
        this.commands.add(command);
    }

    public void give(Player player, ArenaMaker plugin) {
        if (this.money > 0.0 && plugin.getVaultHook().isEnabled()) {
            plugin.getVaultHook().deposit(player, this.money);
        }
        if (this.xp > 0) {
            player.giveExp(this.xp);
        }
        for (ItemStack item : this.items) {
            if (item == null) continue;
            player.getInventory().addItem(new ItemStack[]{item.clone()});
        }
        for (String cmd : this.commands) {
            String parsed = cmd.replace("{player}", player.getName()).replace("{uuid}", player.getUniqueId().toString());
            Bukkit.dispatchCommand((CommandSender)Bukkit.getConsoleSender(), (String)parsed);
        }
    }

    public void save(ConfigurationSection section) {
        section.set("name", (Object)this.name);
        section.set("money", (Object)this.money);
        section.set("xp", (Object)this.xp);
        section.set("items", this.items);
        section.set("commands", this.commands);
    }

    public static Reward load(String id, ConfigurationSection section) {
        Reward reward = new Reward(id);
        reward.name = section.getString("name", id);
        reward.money = section.getDouble("money", 0.0);
        reward.xp = section.getInt("xp", 0);
        List itemList = section.getList("items");
        if (itemList != null) {
            for (Object obj : itemList) {
                if (!(obj instanceof ItemStack)) continue;
                ItemStack item = (ItemStack)obj;
                reward.items.add(item);
            }
        }
        reward.commands = section.getStringList("commands");
        return reward;
    }
}

