/*
 * Decompiled with CFR 0.152.
 */
package AM.arenaMaker.reward;

import AM.arenaMaker.ArenaMaker;
import AM.arenaMaker.reward.Reward;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;

public class RewardManager {
    private final ArenaMaker plugin;
    private final Map<String, Reward> rewards;
    private final File file;
    private FileConfiguration data;

    public RewardManager(ArenaMaker plugin) {
        this.plugin = plugin;
        this.rewards = new HashMap<String, Reward>();
        this.file = new File(plugin.getDataFolder(), "rewards.yml");
        this.load();
        this.createDefaults();
    }

    public Reward create(String id) {
        if (this.rewards.containsKey(id.toLowerCase())) {
            return null;
        }
        Reward reward = new Reward(id.toLowerCase());
        this.rewards.put(id.toLowerCase(), reward);
        this.save();
        return reward;
    }

    public Reward get(String id) {
        return this.rewards.get(id.toLowerCase());
    }

    public boolean exists(String id) {
        return this.rewards.containsKey(id.toLowerCase());
    }

    public boolean delete(String id) {
        if (this.rewards.remove(id.toLowerCase()) == null) {
            return false;
        }
        this.save();
        return true;
    }

    public Collection<Reward> getAll() {
        return this.rewards.values();
    }

    public void load() {
        this.rewards.clear();
        if (!this.file.exists()) {
            this.data = new YamlConfiguration();
            return;
        }
        this.data = YamlConfiguration.loadConfiguration((File)this.file);
        ConfigurationSection section = this.data.getConfigurationSection("rewards");
        if (section == null) {
            return;
        }
        for (String key : section.getKeys(false)) {
            ConfigurationSection rewardSection = section.getConfigurationSection(key);
            if (rewardSection == null) continue;
            Reward reward = Reward.load(key, rewardSection);
            this.rewards.put(key.toLowerCase(), reward);
        }
    }

    public void save() {
        this.data = new YamlConfiguration();
        for (Reward reward : this.rewards.values()) {
            ConfigurationSection section = this.data.createSection("rewards." + reward.getId());
            reward.save(section);
        }
        try {
            this.data.save(this.file);
        }
        catch (IOException e) {
            this.plugin.getLogger().severe("Failed to save rewards: " + e.getMessage());
        }
    }

    private void createDefaults() {
        if (this.rewards.isEmpty()) {
            Reward win = new Reward("win");
            win.setName("Victory Reward");
            win.setMoney(100.0);
            win.setXp(50);
            this.rewards.put("win", win);
            Reward streak = new Reward("streak");
            streak.setName("Win Streak Bonus");
            streak.setMoney(250.0);
            streak.setXp(100);
            this.rewards.put("streak", streak);
            this.save();
        }
    }
}

