/*
 * Decompiled with CFR 0.152.
 */
package AM.arenaMaker.shop;

import AM.arenaMaker.shop.ShopItem;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.bukkit.configuration.ConfigurationSection;

public class Shop {
    private final String id;
    private String name;
    private final Map<String, ShopItem> items;

    public Shop(String id) {
        this.id = id;
        this.name = id;
        this.items = new HashMap<String, ShopItem>();
    }

    public String getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public ShopItem getItem(String itemId) {
        return this.items.get(itemId.toLowerCase());
    }

    public void addItem(ShopItem item) {
        this.items.put(item.getId().toLowerCase(), item);
    }

    public void removeItem(String itemId) {
        this.items.remove(itemId.toLowerCase());
    }

    public Collection<ShopItem> getItems() {
        return this.items.values();
    }

    public int getItemCount() {
        return this.items.size();
    }

    public void save(ConfigurationSection section) {
        section.set("name", (Object)this.name);
        for (ShopItem item : this.items.values()) {
            ConfigurationSection itemSection = section.createSection("items." + item.getId());
            item.save(itemSection);
        }
    }

    public static Shop load(String id, ConfigurationSection section) {
        Shop shop = new Shop(id);
        shop.name = section.getString("name", id);
        ConfigurationSection itemsSection = section.getConfigurationSection("items");
        if (itemsSection != null) {
            for (String key : itemsSection.getKeys(false)) {
                ConfigurationSection itemSection = itemsSection.getConfigurationSection(key);
                if (itemSection == null) continue;
                shop.items.put(key.toLowerCase(), ShopItem.load(key, itemSection));
            }
        }
        return shop;
    }
}

