/*
 * Decompiled with CFR 0.152.
 */
package AM.arenaMaker.shop;

import AM.arenaMaker.shop.ShopTier;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;

public class ShopItem {
    private final String id;
    private String name;
    private Material material;
    private Type type;
    private ShopTier tier;
    private int cost;
    private int maxPurchases;
    private ItemStack item;
    private List<PotionEffect> effects;
    private String command;
    private String description;

    public ShopItem(String id) {
        this.id = id;
        this.name = id;
        this.material = Material.STONE;
        this.type = Type.UTILITY;
        this.tier = ShopTier.STARTER;
        this.cost = 100;
        this.maxPurchases = -1;
        this.effects = new ArrayList<PotionEffect>();
    }

    public String getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Material getMaterial() {
        return this.material;
    }

    public void setMaterial(Material material) {
        this.material = material;
    }

    public Type getType() {
        return this.type;
    }

    public void setType(Type type) {
        this.type = type;
    }

    public ShopTier getTier() {
        return this.tier;
    }

    public void setTier(ShopTier tier) {
        this.tier = tier;
    }

    public int getCost() {
        return this.cost;
    }

    public void setCost(int cost) {
        this.cost = cost;
    }

    public int getMaxPurchases() {
        return this.maxPurchases;
    }

    public void setMaxPurchases(int maxPurchases) {
        this.maxPurchases = maxPurchases;
    }

    public ItemStack getItem() {
        return this.item;
    }

    public void setItem(ItemStack item) {
        this.item = item;
    }

    public List<PotionEffect> getEffects() {
        return this.effects;
    }

    public void addEffect(PotionEffect effect) {
        this.effects.add(effect);
    }

    public String getCommand() {
        return this.command;
    }

    public void setCommand(String command) {
        this.command = command;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public boolean isUnlocked(int wave) {
        return this.tier.isUnlocked(wave);
    }

    public int getAdjustedCost(double priceMult) {
        return (int)((double)this.cost * priceMult);
    }

    public void give(Player player) {
        if (this.item != null) {
            player.getInventory().addItem(new ItemStack[]{this.item.clone()});
        }
        for (PotionEffect effect : this.effects) {
            player.addPotionEffect(effect);
        }
        if (this.command != null && !this.command.isEmpty()) {
            String cmd = this.command.replace("{player}", player.getName());
            player.getServer().dispatchCommand((CommandSender)player.getServer().getConsoleSender(), cmd);
        }
    }

    public ItemStack getDisplayItem(int currentWave, int playerPoints, double priceMult) {
        ItemStack display = this.item != null ? this.item.clone() : new ItemStack(this.material);
        ItemMeta meta = display.getItemMeta();
        if (meta != null) {
            boolean unlocked = this.isUnlocked(currentWave);
            int adjustedCost = this.getAdjustedCost(priceMult);
            boolean canAfford = playerPoints >= adjustedCost;
            ChatColor nameColor = unlocked ? this.tier.getColor() : ChatColor.DARK_GRAY;
            meta.setDisplayName(String.valueOf(nameColor) + this.name);
            ArrayList<Object> lore = new ArrayList<Object>();
            lore.add(String.valueOf(this.tier.getColor()) + "\u25c6 " + this.tier.getDisplay() + " Tier");
            if (this.description != null) {
                lore.add(String.valueOf(ChatColor.GRAY) + this.description);
            }
            lore.add("");
            lore.add(String.valueOf(ChatColor.GRAY) + "Type: " + String.valueOf(ChatColor.WHITE) + this.type.name());
            lore.add(String.valueOf(ChatColor.GRAY) + "Cost: " + String.valueOf(canAfford ? ChatColor.GREEN : ChatColor.RED) + adjustedCost + " points");
            if (this.maxPurchases > 0) {
                lore.add(String.valueOf(ChatColor.GRAY) + "Limit: " + String.valueOf(ChatColor.WHITE) + this.maxPurchases + " per game");
            }
            lore.add("");
            if (!unlocked) {
                lore.add(String.valueOf(ChatColor.RED) + "\u2716 Unlocks at Wave " + this.tier.getWaveUnlock());
            } else if (!canAfford) {
                lore.add(String.valueOf(ChatColor.RED) + "\u2716 Not enough points");
            } else {
                lore.add(String.valueOf(ChatColor.GREEN) + "\u2714 Click to purchase");
            }
            meta.setLore(lore);
            display.setItemMeta(meta);
        }
        return display;
    }

    public ItemStack getDisplayItem() {
        return this.getDisplayItem(99, 99999, 1.0);
    }

    public void save(ConfigurationSection section) {
        section.set("name", (Object)this.name);
        section.set("material", (Object)this.material.name());
        section.set("type", (Object)this.type.name());
        section.set("tier", (Object)this.tier.name());
        section.set("cost", (Object)this.cost);
        section.set("max-purchases", (Object)this.maxPurchases);
        section.set("command", (Object)this.command);
        section.set("description", (Object)this.description);
        if (this.item != null) {
            section.set("item", (Object)this.item);
        }
        ArrayList<CallSite> effectList = new ArrayList<CallSite>();
        for (PotionEffect effect : this.effects) {
            effectList.add((CallSite)((Object)(effect.getType().getName() + ":" + effect.getDuration() + ":" + effect.getAmplifier())));
        }
        section.set("effects", effectList);
    }

    public static ShopItem load(String id, ConfigurationSection section) {
        ShopItem item = new ShopItem(id);
        item.name = section.getString("name", id);
        item.material = Material.getMaterial((String)section.getString("material", "STONE"));
        item.type = Type.valueOf(section.getString("type", "UTILITY"));
        item.tier = ShopTier.fromName(section.getString("tier", "STARTER"));
        item.cost = section.getInt("cost", 100);
        item.maxPurchases = section.getInt("max-purchases", -1);
        item.command = section.getString("command");
        item.description = section.getString("description");
        if (section.contains("item")) {
            item.item = section.getItemStack("item");
        }
        List effectList = section.getStringList("effects");
        for (String effectStr : effectList) {
            PotionEffectType type;
            String[] parts = effectStr.split(":");
            if (parts.length < 3 || (type = PotionEffectType.getByName((String)parts[0])) == null) continue;
            item.effects.add(new PotionEffect(type, Integer.parseInt(parts[1]), Integer.parseInt(parts[2])));
        }
        return item;
    }

    public static enum Type {
        WEAPON,
        ARMOR,
        CONSUMABLE,
        UTILITY,
        UPGRADE,
        SPECIAL;

    }
}

