/*
 * Decompiled with CFR 0.152.
 */
package AM.arenaMaker.shop;

import AM.arenaMaker.ArenaMaker;
import AM.arenaMaker.shop.Shop;
import AM.arenaMaker.shop.ShopItem;
import AM.arenaMaker.shop.ShopTier;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.bukkit.Material;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.inventory.ItemStack;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;

public class ShopManager {
    private final ArenaMaker plugin;
    private final Map<String, Shop> shops;
    private final Map<UUID, Map<String, Integer>> purchases;
    private final File file;
    private FileConfiguration data;

    public ShopManager(ArenaMaker plugin) {
        this.plugin = plugin;
        this.shops = new HashMap<String, Shop>();
        this.purchases = new HashMap<UUID, Map<String, Integer>>();
        this.file = new File(plugin.getDataFolder(), "shops.yml");
        this.load();
        this.createDefaults();
    }

    public Shop create(String id) {
        if (this.shops.containsKey(id.toLowerCase())) {
            return null;
        }
        Shop shop = new Shop(id.toLowerCase());
        this.shops.put(id.toLowerCase(), shop);
        this.save();
        return shop;
    }

    public Shop get(String id) {
        return this.shops.get(id.toLowerCase());
    }

    public Shop getDefault() {
        return this.shops.get("default");
    }

    public boolean exists(String id) {
        return this.shops.containsKey(id.toLowerCase());
    }

    public boolean delete(String id) {
        if (this.shops.remove(id.toLowerCase()) == null) {
            return false;
        }
        this.save();
        return true;
    }

    public Collection<Shop> getAll() {
        return this.shops.values();
    }

    public int getPurchaseCount(UUID uuid, String itemId) {
        Map<String, Integer> playerPurchases = this.purchases.get(uuid);
        if (playerPurchases == null) {
            return 0;
        }
        return playerPurchases.getOrDefault(itemId.toLowerCase(), 0);
    }

    public void addPurchase(UUID uuid, String itemId) {
        this.purchases.computeIfAbsent(uuid, k -> new HashMap()).merge(itemId.toLowerCase(), 1, Integer::sum);
    }

    public void resetPurchases(UUID uuid) {
        this.purchases.remove(uuid);
    }

    public void resetAllPurchases() {
        this.purchases.clear();
    }

    public void load() {
        this.shops.clear();
        if (!this.file.exists()) {
            this.data = new YamlConfiguration();
            return;
        }
        this.data = YamlConfiguration.loadConfiguration((File)this.file);
        ConfigurationSection section = this.data.getConfigurationSection("shops");
        if (section == null) {
            return;
        }
        for (String key : section.getKeys(false)) {
            ConfigurationSection shopSection = section.getConfigurationSection(key);
            if (shopSection == null) continue;
            this.shops.put(key.toLowerCase(), Shop.load(key, shopSection));
        }
    }

    public void save() {
        this.data = new YamlConfiguration();
        for (Shop shop : this.shops.values()) {
            ConfigurationSection section = this.data.createSection("shops." + shop.getId());
            shop.save(section);
        }
        try {
            this.data.save(this.file);
        }
        catch (IOException e) {
            this.plugin.getLogger().severe("Failed to save shops: " + e.getMessage());
        }
    }

    private void createDefaults() {
        if (this.shops.containsKey("default")) {
            return;
        }
        Shop shop = new Shop("default");
        shop.setName("Wave Shop");
        this.addItem(shop, "wooden_sword", "Wooden Sword", Material.WOODEN_SWORD, ShopItem.Type.WEAPON, ShopTier.STARTER, 50, "Basic melee weapon");
        this.addItem(shop, "stone_sword", "Stone Sword", Material.STONE_SWORD, ShopItem.Type.WEAPON, ShopTier.STARTER, 100, "Better than wood");
        this.addItem(shop, "iron_sword", "Iron Sword", Material.IRON_SWORD, ShopItem.Type.WEAPON, ShopTier.BASIC, 200, "Reliable blade");
        this.addItem(shop, "diamond_sword", "Diamond Sword", Material.DIAMOND_SWORD, ShopItem.Type.WEAPON, ShopTier.ADVANCED, 500, "Powerful weapon");
        this.addItem(shop, "netherite_sword", "Netherite Sword", Material.NETHERITE_SWORD, ShopItem.Type.WEAPON, ShopTier.ELITE, 1200, "Ultimate blade");
        this.addItem(shop, "bow", "Bow", Material.BOW, ShopItem.Type.WEAPON, ShopTier.STARTER, 150, "Ranged weapon");
        this.addItem(shop, "crossbow", "Crossbow", Material.CROSSBOW, ShopItem.Type.WEAPON, ShopTier.BASIC, 300, "Powerful ranged");
        this.addItem(shop, "arrows_16", "Arrows x16", Material.ARROW, ShopItem.Type.UTILITY, ShopTier.STARTER, 50, "Ammo for bows");
        this.addItem(shop, "arrows_64", "Arrows x64", Material.ARROW, ShopItem.Type.UTILITY, ShopTier.BASIC, 150, "Bulk ammo");
        this.addItem(shop, "leather_armor", "Leather Set", Material.LEATHER_CHESTPLATE, ShopItem.Type.ARMOR, ShopTier.STARTER, 100, "Basic protection");
        this.addItem(shop, "chainmail_armor", "Chainmail Set", Material.CHAINMAIL_CHESTPLATE, ShopItem.Type.ARMOR, ShopTier.BASIC, 250, "Light armor");
        this.addItem(shop, "iron_armor", "Iron Set", Material.IRON_CHESTPLATE, ShopItem.Type.ARMOR, ShopTier.ADVANCED, 500, "Standard protection");
        this.addItem(shop, "diamond_armor", "Diamond Set", Material.DIAMOND_CHESTPLATE, ShopItem.Type.ARMOR, ShopTier.ELITE, 1000, "Heavy protection");
        this.addItem(shop, "netherite_armor", "Netherite Set", Material.NETHERITE_CHESTPLATE, ShopItem.Type.ARMOR, ShopTier.LEGENDARY, 2500, "Ultimate armor");
        this.addItem(shop, "shield", "Shield", Material.SHIELD, ShopItem.Type.ARMOR, ShopTier.STARTER, 75, "Block attacks");
        this.addItem(shop, "totem", "Totem of Undying", Material.TOTEM_OF_UNDYING, ShopItem.Type.SPECIAL, ShopTier.LEGENDARY, 2000, "Cheat death once", 1);
        this.addPotionItem(shop, "heal", "Instant Health", Material.SPLASH_POTION, ShopTier.STARTER, 75, PotionEffectType.INSTANT_HEALTH, 1, 1);
        this.addPotionItem(shop, "heal2", "Instant Health II", Material.SPLASH_POTION, ShopTier.BASIC, 150, PotionEffectType.INSTANT_HEALTH, 1, 2);
        this.addPotionItem(shop, "regen", "Regeneration", Material.POTION, ShopTier.STARTER, 100, PotionEffectType.REGENERATION, 400, 0);
        this.addPotionItem(shop, "regen2", "Regeneration II", Material.POTION, ShopTier.ADVANCED, 250, PotionEffectType.REGENERATION, 200, 1);
        this.addPotionItem(shop, "speed", "Speed", Material.POTION, ShopTier.STARTER, 80, PotionEffectType.SPEED, 600, 0);
        this.addPotionItem(shop, "speed2", "Speed II", Material.POTION, ShopTier.BASIC, 180, PotionEffectType.SPEED, 400, 1);
        this.addPotionItem(shop, "strength", "Strength", Material.POTION, ShopTier.BASIC, 200, PotionEffectType.STRENGTH, 400, 0);
        this.addPotionItem(shop, "strength2", "Strength II", Material.POTION, ShopTier.ELITE, 500, PotionEffectType.STRENGTH, 200, 1);
        this.addPotionItem(shop, "resistance", "Resistance", Material.POTION, ShopTier.ADVANCED, 300, PotionEffectType.RESISTANCE, 400, 0);
        this.addPotionItem(shop, "fire_res", "Fire Resistance", Material.POTION, ShopTier.BASIC, 150, PotionEffectType.FIRE_RESISTANCE, 600, 0);
        this.addItem(shop, "golden_apple", "Golden Apple", Material.GOLDEN_APPLE, ShopItem.Type.CONSUMABLE, ShopTier.BASIC, 200, "Restore health");
        this.addItem(shop, "enchanted_apple", "Enchanted Apple", Material.ENCHANTED_GOLDEN_APPLE, ShopItem.Type.CONSUMABLE, ShopTier.LEGENDARY, 1500, "God apple", 2);
        this.addItem(shop, "ender_pearl", "Ender Pearl", Material.ENDER_PEARL, ShopItem.Type.UTILITY, ShopTier.ADVANCED, 250, "Teleport");
        this.addItem(shop, "tnt", "TNT x2", Material.TNT, ShopItem.Type.UTILITY, ShopTier.BASIC, 200, "Explosives");
        this.addItem(shop, "flint_steel", "Flint & Steel", Material.FLINT_AND_STEEL, ShopItem.Type.UTILITY, ShopTier.STARTER, 50, "Start fires");
        this.addItem(shop, "cobweb", "Cobwebs x4", Material.COBWEB, ShopItem.Type.UTILITY, ShopTier.BASIC, 100, "Slow enemies");
        this.addItem(shop, "lava_bucket", "Lava Bucket", Material.LAVA_BUCKET, ShopItem.Type.UTILITY, ShopTier.ADVANCED, 300, "Dangerous trap");
        this.addItem(shop, "water_bucket", "Water Bucket", Material.WATER_BUCKET, ShopItem.Type.UTILITY, ShopTier.STARTER, 50, "Extinguish fires");
        this.addItem(shop, "trident", "Trident", Material.TRIDENT, ShopItem.Type.WEAPON, ShopTier.ELITE, 800, "Throwable spear");
        this.addItem(shop, "mace", "Mace", Material.MACE, ShopItem.Type.WEAPON, ShopTier.ULTIMATE, 3000, "Crushing power", 1);
        this.shops.put("default", shop);
        this.save();
    }

    private void addItem(Shop shop, String id, String name, Material mat, ShopItem.Type type, ShopTier tier, int cost, String desc) {
        this.addItem(shop, id, name, mat, type, tier, cost, desc, -1);
    }

    private void addItem(Shop shop, String id, String name, Material mat, ShopItem.Type type, ShopTier tier, int cost, String desc, int maxPurchases) {
        ShopItem item = new ShopItem(id);
        item.setName(name);
        item.setMaterial(mat);
        item.setType(type);
        item.setTier(tier);
        item.setCost(cost);
        item.setDescription(desc);
        item.setMaxPurchases(maxPurchases);
        if (type == ShopItem.Type.ARMOR) {
            item.setItem(this.createArmorSet(mat));
        } else if (id.equals("arrows_16")) {
            item.setItem(new ItemStack(Material.ARROW, 16));
        } else if (id.equals("arrows_64")) {
            item.setItem(new ItemStack(Material.ARROW, 64));
        } else if (id.equals("tnt")) {
            item.setItem(new ItemStack(Material.TNT, 2));
        } else if (id.equals("cobweb")) {
            item.setItem(new ItemStack(Material.COBWEB, 4));
        } else {
            item.setItem(new ItemStack(mat));
        }
        shop.addItem(item);
    }

    private void addPotionItem(Shop shop, String id, String name, Material mat, ShopTier tier, int cost, PotionEffectType effectType, int duration, int amplifier) {
        ShopItem item = new ShopItem(id);
        item.setName(name);
        item.setMaterial(mat);
        item.setType(ShopItem.Type.CONSUMABLE);
        item.setTier(tier);
        item.setCost(cost);
        item.addEffect(new PotionEffect(effectType, duration, amplifier));
        shop.addItem(item);
    }

    private ItemStack createArmorSet(Material chestplate) {
        return new ItemStack(chestplate);
    }
}

