/*
 * Decompiled with CFR 0.152.
 */
package AM.arenaMaker.shop;

import org.bukkit.ChatColor;
import org.bukkit.Material;

public enum ShopTier {
    STARTER(0, "Starter", ChatColor.WHITE, Material.WOODEN_SWORD),
    BASIC(3, "Basic", ChatColor.GREEN, Material.STONE_SWORD),
    ADVANCED(7, "Advanced", ChatColor.BLUE, Material.IRON_SWORD),
    ELITE(12, "Elite", ChatColor.GOLD, Material.DIAMOND_SWORD),
    LEGENDARY(18, "Legendary", ChatColor.LIGHT_PURPLE, Material.NETHERITE_SWORD),
    ULTIMATE(25, "Ultimate", ChatColor.RED, Material.END_CRYSTAL);

    private final int waveUnlock;
    private final String display;
    private final ChatColor color;
    private final Material icon;

    private ShopTier(int waveUnlock, String display, ChatColor color, Material icon) {
        this.waveUnlock = waveUnlock;
        this.display = display;
        this.color = color;
        this.icon = icon;
    }

    public int getWaveUnlock() {
        return this.waveUnlock;
    }

    public String getDisplay() {
        return this.display;
    }

    public ChatColor getColor() {
        return this.color;
    }

    public Material getIcon() {
        return this.icon;
    }

    public String getFormatted() {
        return String.valueOf(this.color) + this.display;
    }

    public boolean isUnlocked(int currentWave) {
        return currentWave >= this.waveUnlock;
    }

    public static ShopTier fromName(String name) {
        for (ShopTier t : ShopTier.values()) {
            if (!t.name().equalsIgnoreCase(name)) continue;
            return t;
        }
        return STARTER;
    }

    public static ShopTier getHighestUnlocked(int wave) {
        ShopTier highest = STARTER;
        for (ShopTier t : ShopTier.values()) {
            if (!t.isUnlocked(wave)) continue;
            highest = t;
        }
        return highest;
    }
}

