/*
 * Decompiled with CFR 0.152.
 */
package AM.arenaMaker.sign;

import AM.arenaMaker.arena.Arena;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.block.BlockState;
import org.bukkit.block.Sign;
import org.bukkit.configuration.ConfigurationSection;

public class ArenaSign {
    private final Location location;
    private final String arenaId;
    private final Type type;

    public ArenaSign(Location location, String arenaId, Type type) {
        this.location = location;
        this.arenaId = arenaId;
        this.type = type;
    }

    public Location getLocation() {
        return this.location;
    }

    public String getArenaId() {
        return this.arenaId;
    }

    public Type getType() {
        return this.type;
    }

    public void update(Arena arena, boolean busy, int queueSize) {
        Block block = this.location.getBlock();
        BlockState blockState = block.getState();
        if (!(blockState instanceof Sign)) {
            return;
        }
        Sign sign = (Sign)blockState;
        String status = busy ? String.valueOf(ChatColor.RED) + "In Use" : String.valueOf(ChatColor.GREEN) + "Available";
        switch (this.type.ordinal()) {
            case 0: {
                sign.setLine(0, String.valueOf(ChatColor.DARK_AQUA) + "[Arena]");
                sign.setLine(1, String.valueOf(ChatColor.GRAY) + arena.getName());
                sign.setLine(2, status);
                sign.setLine(3, String.valueOf(ChatColor.AQUA) + "Click to join");
                break;
            }
            case 1: {
                sign.setLine(0, String.valueOf(ChatColor.DARK_AQUA) + "[Arena Info]");
                sign.setLine(1, String.valueOf(ChatColor.GRAY) + arena.getName());
                sign.setLine(2, String.valueOf(ChatColor.GRAY) + arena.getPreset().getDisplay());
                sign.setLine(3, status);
                break;
            }
            case 3: {
                sign.setLine(0, String.valueOf(ChatColor.DARK_AQUA) + "[Queue]");
                sign.setLine(1, String.valueOf(ChatColor.GRAY) + arena.getName());
                sign.setLine(2, String.valueOf(ChatColor.AQUA) + "Players: " + queueSize);
                sign.setLine(3, String.valueOf(ChatColor.GRAY) + "Click to queue");
                break;
            }
            case 2: {
                sign.setLine(0, String.valueOf(ChatColor.DARK_AQUA) + "[Stats]");
                sign.setLine(1, String.valueOf(ChatColor.GRAY) + arena.getName());
                sign.setLine(2, "");
                sign.setLine(3, String.valueOf(ChatColor.AQUA) + "Click for stats");
            }
        }
        sign.update();
    }

    public boolean isValid() {
        return this.location.getBlock().getState() instanceof Sign;
    }

    public String getKey() {
        return this.location.getWorld().getName() + ":" + this.location.getBlockX() + ":" + this.location.getBlockY() + ":" + this.location.getBlockZ();
    }

    public void save(ConfigurationSection section) {
        section.set("world", (Object)this.location.getWorld().getName());
        section.set("x", (Object)this.location.getBlockX());
        section.set("y", (Object)this.location.getBlockY());
        section.set("z", (Object)this.location.getBlockZ());
        section.set("arena", (Object)this.arenaId);
        section.set("type", (Object)this.type.name());
    }

    public static ArenaSign load(ConfigurationSection section) {
        World world = Bukkit.getWorld((String)section.getString("world"));
        if (world == null) {
            return null;
        }
        Location loc = new Location(world, (double)section.getInt("x"), (double)section.getInt("y"), (double)section.getInt("z"));
        String arenaId = section.getString("arena");
        Type type = Type.valueOf(section.getString("type", "JOIN"));
        return new ArenaSign(loc, arenaId, type);
    }

    public static enum Type {
        JOIN,
        INFO,
        STATS,
        QUEUE;

    }
}

