/*
 * Decompiled with CFR 0.152.
 */
package AM.arenaMaker.sign;

import AM.arenaMaker.ArenaMaker;
import AM.arenaMaker.arena.Arena;
import AM.arenaMaker.sign.ArenaSign;
import AM.arenaMaker.util.Msg;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.bukkit.Location;
import org.bukkit.block.Block;
import org.bukkit.block.Sign;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.block.Action;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.block.SignChangeEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;

public class SignManager
implements Listener {
    private final ArenaMaker plugin;
    private final Map<String, ArenaSign> signs;
    private final File file;
    private FileConfiguration data;

    public SignManager(ArenaMaker plugin) {
        this.plugin = plugin;
        this.signs = new HashMap<String, ArenaSign>();
        this.file = new File(plugin.getDataFolder(), "signs.yml");
        this.load();
        plugin.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)plugin);
        new BukkitRunnable(){

            public void run() {
                SignManager.this.updateAllSigns();
            }
        }.runTaskTimer((Plugin)plugin, 100L, 100L);
    }

    public ArenaSign create(Location location, String arenaId, ArenaSign.Type type) {
        ArenaSign sign = new ArenaSign(location, arenaId, type);
        this.signs.put(sign.getKey(), sign);
        this.save();
        Arena arena = this.plugin.getArenaManager().get(arenaId);
        if (arena != null) {
            sign.update(arena, this.plugin.getDuelManager().isArenaBusy(arenaId), 0);
        }
        return sign;
    }

    public ArenaSign get(Location location) {
        String key = location.getWorld().getName() + ":" + location.getBlockX() + ":" + location.getBlockY() + ":" + location.getBlockZ();
        return this.signs.get(key);
    }

    public boolean remove(Location location) {
        String key = location.getWorld().getName() + ":" + location.getBlockX() + ":" + location.getBlockY() + ":" + location.getBlockZ();
        if (this.signs.remove(key) == null) {
            return false;
        }
        this.save();
        return true;
    }

    public void updateAllSigns() {
        this.signs.values().removeIf(sign -> !sign.isValid());
        for (ArenaSign sign2 : this.signs.values()) {
            Arena arena = this.plugin.getArenaManager().get(sign2.getArenaId());
            if (arena == null) continue;
            sign2.update(arena, this.plugin.getDuelManager().isArenaBusy(sign2.getArenaId()), 0);
        }
    }

    @EventHandler
    public void onSignChange(final SignChangeEvent event) {
        String firstLine = event.getLine(0);
        if (firstLine == null) {
            return;
        }
        if (!firstLine.equalsIgnoreCase("[arena]")) {
            return;
        }
        final Player player = event.getPlayer();
        if (!player.hasPermission("arena.admin")) {
            Msg.error((CommandSender)player, "No permission to create arena signs.");
            return;
        }
        final String arenaId = event.getLine(1);
        if (arenaId == null || arenaId.isEmpty()) {
            Msg.error((CommandSender)player, "Specify arena name on line 2.");
            return;
        }
        final Arena arena = this.plugin.getArenaManager().get(arenaId);
        if (arena == null) {
            Msg.error((CommandSender)player, "Arena not found: " + arenaId);
            return;
        }
        String typeStr = event.getLine(2);
        ArenaSign.Type type = ArenaSign.Type.JOIN;
        if (typeStr != null && !typeStr.isEmpty()) {
            try {
                type = ArenaSign.Type.valueOf(typeStr.toUpperCase());
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        event.setCancelled(true);
        final ArenaSign.Type finalType = type;
        new BukkitRunnable(){

            public void run() {
                SignManager.this.create(event.getBlock().getLocation(), arenaId, finalType);
                Msg.success((CommandSender)player, "Created " + finalType.name().toLowerCase() + " sign for " + arena.getName());
            }
        }.runTask((Plugin)this.plugin);
    }

    @EventHandler
    public void onInteract(PlayerInteractEvent event) {
        if (event.getAction() != Action.RIGHT_CLICK_BLOCK) {
            return;
        }
        Block block = event.getClickedBlock();
        if (block == null || !(block.getState() instanceof Sign)) {
            return;
        }
        ArenaSign sign = this.get(block.getLocation());
        if (sign == null) {
            return;
        }
        event.setCancelled(true);
        Player player = event.getPlayer();
        Arena arena = this.plugin.getArenaManager().get(sign.getArenaId());
        if (arena == null) {
            Msg.error((CommandSender)player, "Arena no longer exists.");
            return;
        }
        switch (sign.getType()) {
            case JOIN: 
            case QUEUE: {
                if (this.plugin.getDuelManager().isInMatch(player.getUniqueId())) {
                    Msg.error((CommandSender)player, "You're already in a match.");
                    return;
                }
                if (this.plugin.getDuelManager().isArenaBusy(arena.getId())) {
                    Msg.error((CommandSender)player, "Arena is currently in use.");
                    return;
                }
                this.plugin.getQueueManager().addToQueue(player, arena);
                break;
            }
            case INFO: {
                player.performCommand("arena info " + arena.getId());
                break;
            }
            case STATS: {
                player.performCommand("duel stats");
            }
        }
    }

    @EventHandler
    public void onBreak(BlockBreakEvent event) {
        ArenaSign sign = this.get(event.getBlock().getLocation());
        if (sign == null) {
            return;
        }
        Player player = event.getPlayer();
        if (!player.hasPermission("arena.admin")) {
            event.setCancelled(true);
            Msg.error((CommandSender)player, "No permission to break arena signs.");
            return;
        }
        this.remove(event.getBlock().getLocation());
        Msg.send((CommandSender)player, "Arena sign removed.");
    }

    public void load() {
        this.signs.clear();
        if (!this.file.exists()) {
            this.data = new YamlConfiguration();
            return;
        }
        this.data = YamlConfiguration.loadConfiguration((File)this.file);
        ConfigurationSection section = this.data.getConfigurationSection("signs");
        if (section == null) {
            return;
        }
        for (String key : section.getKeys(false)) {
            ArenaSign sign;
            ConfigurationSection signSection = section.getConfigurationSection(key);
            if (signSection == null || (sign = ArenaSign.load(signSection)) == null || !sign.isValid()) continue;
            this.signs.put(sign.getKey(), sign);
        }
    }

    public void save() {
        this.data = new YamlConfiguration();
        int i = 0;
        for (ArenaSign sign : this.signs.values()) {
            ConfigurationSection section = this.data.createSection("signs.sign_" + i++);
            sign.save(section);
        }
        try {
            this.data.save(this.file);
        }
        catch (IOException e) {
            this.plugin.getLogger().severe("Failed to save signs: " + e.getMessage());
        }
    }
}

