/*
 * Decompiled with CFR 0.152.
 */
package AM.arenaMaker.util;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.GameMode;
import org.bukkit.Location;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;

public class PlayerState {
    private static final Map<UUID, Snapshot> states = new HashMap<UUID, Snapshot>();

    public static void save(Player player) {
        states.put(player.getUniqueId(), new Snapshot((ItemStack[])player.getInventory().getContents().clone(), (ItemStack[])player.getInventory().getArmorContents().clone(), player.getLocation().clone(), player.getGameMode()));
    }

    public static void restore(Player player) {
        Snapshot snap = states.remove(player.getUniqueId());
        if (snap == null) {
            return;
        }
        player.getInventory().clear();
        player.getInventory().setContents(snap.inv);
        player.getInventory().setArmorContents(snap.armor);
        player.teleport(snap.loc);
        player.setGameMode(snap.mode);
        player.setHealth(player.getMaxHealth());
        player.setFoodLevel(20);
    }

    public static void restore(UUID uuid) {
        Player player = Bukkit.getPlayer((UUID)uuid);
        if (player != null) {
            PlayerState.restore(player);
        }
    }

    public static boolean has(UUID uuid) {
        return states.containsKey(uuid);
    }

    public static void clear(UUID uuid) {
        states.remove(uuid);
    }

    private record Snapshot(ItemStack[] inv, ItemStack[] armor, Location loc, GameMode mode) {
    }
}

