/*
 * Decompiled with CFR 0.152.
 */
package AM.arenaMaker.util;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.bukkit.Color;
import org.bukkit.Location;
import org.bukkit.Particle;
import org.bukkit.World;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.scheduler.BukkitTask;

public class Visualizer {
    private static final double SPACING = 0.5;
    private static final int CORNER_HEIGHT = 3;
    private static final Particle.DustOptions CORNER_DUST = new Particle.DustOptions(Color.fromRGB((int)0, (int)255, (int)255), 1.2f);
    private static final Particle.DustOptions EDGE_DUST = new Particle.DustOptions(Color.fromRGB((int)0, (int)200, (int)200), 0.8f);
    private static final Particle.DustOptions SPAWN_DUST = new Particle.DustOptions(Color.fromRGB((int)50, (int)255, (int)50), 1.0f);
    private final Plugin plugin;
    private final Map<UUID, BukkitTask> tasks = new HashMap<UUID, BukkitTask>();

    public Visualizer(Plugin plugin) {
        this.plugin = plugin;
    }

    public void showCorner(final Player player, final Location corner) {
        this.stop(player);
        this.tasks.put(player.getUniqueId(), new BukkitRunnable(){

            public void run() {
                if (!player.isOnline()) {
                    this.cancel();
                    return;
                }
                Visualizer.this.drawPillar(player, corner, CORNER_DUST);
            }
        }.runTaskTimer(this.plugin, 0L, 10L));
    }

    public void showBounds(final Player player, final Location pos1, final Location pos2) {
        this.stop(player);
        this.tasks.put(player.getUniqueId(), new BukkitRunnable(){

            public void run() {
                if (!player.isOnline()) {
                    this.cancel();
                    return;
                }
                Visualizer.this.drawBox(player, pos1, pos2);
            }
        }.runTaskTimer(this.plugin, 0L, 10L));
    }

    public void showBoundsWithSpawn(final Player player, final Location pos1, final Location pos2, final Location spawn) {
        this.stop(player);
        this.tasks.put(player.getUniqueId(), new BukkitRunnable(){

            public void run() {
                if (!player.isOnline()) {
                    this.cancel();
                    return;
                }
                Visualizer.this.drawBox(player, pos1, pos2);
                if (spawn != null) {
                    Visualizer.this.drawSpawn(player, spawn);
                }
            }
        }.runTaskTimer(this.plugin, 0L, 10L));
    }

    public void showBoundsWithSpawns(final Player player, final Location pos1, final Location pos2, final Location spawn1, final Location spawn2) {
        this.stop(player);
        this.tasks.put(player.getUniqueId(), new BukkitRunnable(){

            public void run() {
                if (!player.isOnline()) {
                    this.cancel();
                    return;
                }
                Visualizer.this.drawBox(player, pos1, pos2);
                if (spawn1 != null) {
                    Visualizer.this.drawSpawn(player, spawn1);
                }
                if (spawn2 != null) {
                    Visualizer.this.drawSpawn(player, spawn2);
                }
            }
        }.runTaskTimer(this.plugin, 0L, 10L));
    }

    public void stop(Player player) {
        BukkitTask task = this.tasks.remove(player.getUniqueId());
        if (task != null) {
            task.cancel();
        }
    }

    private void drawBox(Player player, Location pos1, Location pos2) {
        World world = pos1.getWorld();
        if (world == null || !world.equals((Object)player.getWorld())) {
            return;
        }
        double minX = Math.min(pos1.getX(), pos2.getX());
        double minY = Math.min(pos1.getY(), pos2.getY());
        double minZ = Math.min(pos1.getZ(), pos2.getZ());
        double maxX = Math.max(pos1.getX(), pos2.getX()) + 1.0;
        double maxY = Math.max(pos1.getY(), pos2.getY()) + 1.0;
        double maxZ = Math.max(pos1.getZ(), pos2.getZ()) + 1.0;
        this.drawPillar(player, new Location(world, minX, minY, minZ), CORNER_DUST);
        this.drawPillar(player, new Location(world, maxX, minY, minZ), CORNER_DUST);
        this.drawPillar(player, new Location(world, minX, minY, maxZ), CORNER_DUST);
        this.drawPillar(player, new Location(world, maxX, minY, maxZ), CORNER_DUST);
        this.drawLine(player, minX, minY, minZ, maxX, minY, minZ, world, EDGE_DUST);
        this.drawLine(player, minX, minY, minZ, minX, minY, maxZ, world, EDGE_DUST);
        this.drawLine(player, maxX, minY, minZ, maxX, minY, maxZ, world, EDGE_DUST);
        this.drawLine(player, minX, minY, maxZ, maxX, minY, maxZ, world, EDGE_DUST);
        this.drawLine(player, minX, maxY, minZ, maxX, maxY, minZ, world, EDGE_DUST);
        this.drawLine(player, minX, maxY, minZ, minX, maxY, maxZ, world, EDGE_DUST);
        this.drawLine(player, maxX, maxY, minZ, maxX, maxY, maxZ, world, EDGE_DUST);
        this.drawLine(player, minX, maxY, maxZ, maxX, maxY, maxZ, world, EDGE_DUST);
        this.drawLine(player, minX, minY, minZ, minX, maxY, minZ, world, EDGE_DUST);
        this.drawLine(player, maxX, minY, minZ, maxX, maxY, minZ, world, EDGE_DUST);
        this.drawLine(player, minX, minY, maxZ, minX, maxY, maxZ, world, EDGE_DUST);
        this.drawLine(player, maxX, minY, maxZ, maxX, maxY, maxZ, world, EDGE_DUST);
    }

    private void drawPillar(Player player, Location base, Particle.DustOptions dust) {
        World world = base.getWorld();
        if (world == null) {
            return;
        }
        for (int i = 0; i < 3; ++i) {
            player.spawnParticle(Particle.DUST, base.getX(), base.getY() + (double)i, base.getZ(), 1, (Object)dust);
        }
    }

    private void drawSpawn(Player player, Location loc) {
        World world = loc.getWorld();
        if (world == null) {
            return;
        }
        for (double angle = 0.0; angle < Math.PI * 2; angle += 0.39269908169872414) {
            double x = loc.getX() + Math.cos(angle) * 0.8;
            double z = loc.getZ() + Math.sin(angle) * 0.8;
            player.spawnParticle(Particle.DUST, x, loc.getY() + 0.1, z, 1, (Object)SPAWN_DUST);
            player.spawnParticle(Particle.DUST, x, loc.getY() + 1.0, z, 1, (Object)SPAWN_DUST);
        }
    }

    private void drawLine(Player player, double x1, double y1, double z1, double x2, double y2, double z2, World world, Particle.DustOptions dust) {
        double dist = Math.sqrt(Math.pow(x2 - x1, 2.0) + Math.pow(y2 - y1, 2.0) + Math.pow(z2 - z1, 2.0));
        int points = (int)(dist / 0.5);
        if (points < 1) {
            points = 1;
        }
        double dx = (x2 - x1) / (double)points;
        double dy = (y2 - y1) / (double)points;
        double dz = (z2 - z1) / (double)points;
        for (int i = 0; i <= points; ++i) {
            player.spawnParticle(Particle.DUST, x1 + dx * (double)i, y1 + dy * (double)i, z1 + dz * (double)i, 1, (Object)dust);
        }
    }
}

