/*
 * Decompiled with CFR 0.152.
 */
package technicfan.lanlock;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.loader.api.FabricLoader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import technicfan.lanlock.LANLockConfig;

public class LANLock
implements ModInitializer {
    public static final String MOD_ID = "lanlock";
    private static final Logger LOGGER = LoggerFactory.getLogger((String)"lanlock");
    private static File CONFIG_FILE;
    private static LANLockConfig CONFIG;

    public void onInitialize() {
        CONFIG_FILE = FabricLoader.getInstance().getConfigDir().resolve("lanlock.json").toFile();
        LANLock.loadConfig();
    }

    private static Map<String, String> getPlayerFromWhitelist(String id) {
        String keyQuery = id.contains("-") ? "uuid" : "name";
        for (Map<String, String> player : CONFIG.whitelist()) {
            if (!player.get(keyQuery).equalsIgnoreCase(id)) continue;
            return player;
        }
        return null;
    }

    public static String getWhitelistCounterpart(String id) {
        String keyResult = id.contains("-") ? "name" : "uuid";
        Map<String, String> player = LANLock.getPlayerFromWhitelist(id);
        if (player == null) {
            return null;
        }
        return player.get(keyResult);
    }

    public static List<String> getNames() {
        ArrayList<String> names = new ArrayList<String>(Collections.emptyList());
        for (Map<String, String> user : CONFIG.whitelist()) {
            if (CONFIG.useUuid() && user.get("uuid").isEmpty()) continue;
            names.add(user.get("name"));
        }
        return names;
    }

    public static boolean getUseUuid() {
        return CONFIG.useUuid();
    }

    public static boolean enabled() {
        return CONFIG.enabled();
    }

    public static boolean getSendNotification() {
        return CONFIG.sendNotification();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static Map<String, String> getPlayer(String name) {
        if (LANLock.checkWhitelist(name)) {
            return LANLock.getPlayerFromWhitelist(name);
        }
        try (HttpClient client = HttpClient.newHttpClient();){
            HttpRequest request = HttpRequest.newBuilder().uri(URI.create("https://api.minecraftservices.com/minecraft/profile/lookup/name/" + name)).build();
            HttpResponse<String> response = client.send(request, HttpResponse.BodyHandlers.ofString());
            if (response.statusCode() != 200) return Map.of("uuid", "", "name", name);
            JsonObject json = JsonParser.parseString((String)response.body()).getAsJsonObject();
            Map<String, String> map = Map.of("uuid", json.get("id").getAsString().replaceAll("(\\w{8})(\\w{4})(\\w{4})(\\w{4})(\\w{12})", "$1-$2-$3-$4-$5"), "name", json.get("name").getAsString());
            return map;
        }
        catch (IOException | InterruptedException exception) {
            // empty catch block
        }
        return Map.of("uuid", "", "name", name);
    }

    public static boolean checkWhitelist(String id) {
        String keyQuery = id.contains("-") ? "uuid" : "name";
        for (Map<String, String> player : CONFIG.whitelist()) {
            if (!player.get(keyQuery).equalsIgnoreCase(id)) continue;
            return true;
        }
        return false;
    }

    private static Map<String, String> makePlayer(String name) {
        if (!name.isEmpty()) {
            Map<String, String> player = LANLock.getPlayer(name);
            if (!CONFIG.useUuid() || !player.get("uuid").isEmpty()) {
                return player;
            }
        }
        return null;
    }

    public static void loadConfig() {
        if (CONFIG_FILE.exists()) {
            try (FileReader reader = new FileReader(CONFIG_FILE);){
                LOGGER.info("Loaded LANLock config");
                CONFIG = (LANLockConfig)new Gson().fromJson((Reader)reader, LANLockConfig.class);
            }
            catch (IOException e) {
                LOGGER.error(Arrays.toString(e.getStackTrace()));
            }
        }
    }

    public static void saveConfig(boolean enabled, boolean useUuid, boolean sendNotifications, List<String> whitelist) {
        ArrayList removeIds = new ArrayList(Collections.emptyList());
        ArrayList<Map<String, String>> newWhitelist = new ArrayList<Map<String, String>>();
        for (String string : whitelist.stream().sorted().distinct().toList()) {
            Map<String, String> player2 = LANLock.makePlayer(string);
            if (player2 != null && !player2.get("uuid").isEmpty() && LANLock.checkWhitelist(player2.get("uuid")) && !LANLock.checkWhitelist(string)) {
                removeIds.add(player2.get("uuid"));
            }
            if (player2 == null) continue;
            newWhitelist.add(player2);
        }
        if (LANLock.getUseUuid() || useUuid) {
            for (Map map : CONFIG.whitelist()) {
                if (!((String)map.get("uuid")).isEmpty() || newWhitelist.contains(map)) continue;
                newWhitelist.add(map);
            }
        }
        for (String string : removeIds) {
            newWhitelist.removeIf(player -> ((String)player.get("name")).equalsIgnoreCase(LANLock.getWhitelistCounterpart(id)) && ((String)player.get("uuid")).equals(id));
        }
        CONFIG.setEnabled(enabled);
        CONFIG.setUseUuid(useUuid);
        CONFIG.setSendNotification(sendNotifications);
        CONFIG.setWhitelist(newWhitelist);
        LANLock.saveToFile();
    }

    private static void saveToFile() {
        Gson gson = new GsonBuilder().setPrettyPrinting().create();
        try (FileWriter writer = new FileWriter(CONFIG_FILE);){
            writer.write(gson.toJson((Object)CONFIG));
        }
        catch (IOException e) {
            LOGGER.error(Arrays.toString(e.getStackTrace()));
        }
    }

    public static String add(String name) {
        Map<String, String> player = LANLock.makePlayer(name);
        if (player == null) {
            return null;
        }
        if (!CONFIG.whitelist().contains(player)) {
            CONFIG.addToWhitelist(player);
            LANLock.saveToFile();
            return player.get("name");
        }
        return "";
    }

    public static boolean remove(String name) {
        if (LANLock.checkWhitelist(name)) {
            CONFIG.removeFromWhitelist(Map.of("uuid", Objects.requireNonNull(LANLock.getWhitelistCounterpart(name)), "name", name));
            LANLock.saveToFile();
            return true;
        }
        return false;
    }

    public static void setEnabled(boolean value) {
        if (CONFIG.enabled() != value) {
            CONFIG.setEnabled(value);
            LANLock.saveToFile();
        }
    }

    public static void setUseUuid(boolean value) {
        if (CONFIG.useUuid() != value) {
            CONFIG.setUseUuid(value);
            LANLock.saveToFile();
        }
    }

    public static void setSendNotification(boolean value) {
        if (CONFIG.sendNotification() != value) {
            CONFIG.setSendNotification(value);
            LANLock.saveToFile();
        }
    }

    static {
        CONFIG = new LANLockConfig();
    }
}

