/*
 * Decompiled with CFR 0.152.
 */
package technicfan.lanlock;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.BoolArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import java.util.concurrent.CompletableFuture;
import net.fabricmc.api.ClientModInitializer;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.command.v2.ClientCommandManager;
import net.fabricmc.fabric.api.client.command.v2.ClientCommandRegistrationCallback;
import net.fabricmc.fabric.api.client.command.v2.FabricClientCommandSource;
import net.minecraft.class_2561;
import technicfan.lanlock.LANLock;
import technicfan.lanlock.PlayerSuggestionProvider;
import technicfan.lanlock.WhitelistPlayerSuggestionProvider;

@Environment(value=EnvType.CLIENT)
public class LANLockClient
implements ClientModInitializer {
    public void onInitializeClient() {
        ClientCommandRegistrationCallback.EVENT.register((dispatcher, registryAccess) -> dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)ClientCommandManager.literal((String)"lanlock").then(ClientCommandManager.literal((String)"list").executes(LANLockClient::list))).then(ClientCommandManager.literal((String)"reload").executes(LANLockClient::reload))).then(ClientCommandManager.literal((String)"add").then(ClientCommandManager.argument((String)"player", (ArgumentType)StringArgumentType.string()).suggests((SuggestionProvider)new PlayerSuggestionProvider()).executes(LANLockClient::add)))).then(ClientCommandManager.literal((String)"remove").then(ClientCommandManager.argument((String)"player", (ArgumentType)StringArgumentType.string()).suggests((SuggestionProvider)new WhitelistPlayerSuggestionProvider()).executes(LANLockClient::remove)))).then(ClientCommandManager.literal((String)"on").executes(LANLockClient::on))).then(ClientCommandManager.literal((String)"off").executes(LANLockClient::off))).then(((LiteralArgumentBuilder)ClientCommandManager.literal((String)"useUuid").then(ClientCommandManager.argument((String)"enabled", (ArgumentType)BoolArgumentType.bool()).executes(LANLockClient::toggleUseUuid))).executes(LANLockClient::useUuid))).then(((LiteralArgumentBuilder)ClientCommandManager.literal((String)"notify").then(ClientCommandManager.argument((String)"enabled", (ArgumentType)BoolArgumentType.bool()).executes(LANLockClient::toggleNotify))).executes(LANLockClient::notify))));
    }

    private static int list(CommandContext<FabricClientCommandSource> commandContext) {
        if (LANLock.getNames().isEmpty()) {
            ((FabricClientCommandSource)commandContext.getSource()).sendFeedback((class_2561)class_2561.method_43471((String)"commands.whitelist.none"));
            return 1;
        }
        ((FabricClientCommandSource)commandContext.getSource()).sendFeedback((class_2561)class_2561.method_43469((String)"commands.whitelist.list", (Object[])new Object[]{LANLock.getNames().size(), String.join((CharSequence)", ", LANLock.getNames())}));
        return LANLock.getNames().size();
    }

    private static int reload(CommandContext<FabricClientCommandSource> commandContext) {
        CompletableFuture.runAsync(() -> {
            LANLock.loadConfig();
            ((FabricClientCommandSource)commandContext.getSource()).sendFeedback((class_2561)class_2561.method_43471((String)"commands.whitelist.reloaded"));
        });
        return 1;
    }

    private static int add(CommandContext<FabricClientCommandSource> commandContext) {
        CompletableFuture.runAsync(() -> {
            String name = LANLock.add(StringArgumentType.getString((CommandContext)commandContext, (String)"player"));
            if (name == null) {
                ((FabricClientCommandSource)commandContext.getSource()).sendError((class_2561)class_2561.method_43471((String)"argument.player.unknown"));
            } else if (!name.isEmpty()) {
                ((FabricClientCommandSource)commandContext.getSource()).sendFeedback((class_2561)class_2561.method_43469((String)"commands.whitelist.add.success", (Object[])new Object[]{name}));
            } else {
                ((FabricClientCommandSource)commandContext.getSource()).sendError((class_2561)class_2561.method_43471((String)"commands.whitelist.add.failed"));
            }
        });
        return 1;
    }

    private static int remove(CommandContext<FabricClientCommandSource> commandContext) {
        String name = StringArgumentType.getString(commandContext, (String)"player");
        boolean result = LANLock.remove(name);
        if (result) {
            ((FabricClientCommandSource)commandContext.getSource()).sendFeedback((class_2561)class_2561.method_43469((String)"commands.whitelist.remove.success", (Object[])new Object[]{name}));
        } else {
            ((FabricClientCommandSource)commandContext.getSource()).sendError((class_2561)class_2561.method_43471((String)"commands.whitelist.remove.failed"));
        }
        return 1;
    }

    private static int on(CommandContext<FabricClientCommandSource> commandContext) {
        if (LANLock.enabled()) {
            ((FabricClientCommandSource)commandContext.getSource()).sendFeedback((class_2561)class_2561.method_43471((String)"commands.whitelist.alreadyOn"));
            return 0;
        }
        ((FabricClientCommandSource)commandContext.getSource()).sendFeedback((class_2561)class_2561.method_43471((String)"commands.whitelist.enabled"));
        LANLock.setEnabled(true);
        return 1;
    }

    private static int off(CommandContext<FabricClientCommandSource> commandContext) {
        if (!LANLock.enabled()) {
            ((FabricClientCommandSource)commandContext.getSource()).sendFeedback((class_2561)class_2561.method_43471((String)"commands.whitelist.alreadyOff"));
            return 0;
        }
        ((FabricClientCommandSource)commandContext.getSource()).sendFeedback((class_2561)class_2561.method_43471((String)"commands.whitelist.disabled"));
        LANLock.setEnabled(false);
        return 1;
    }

    private static int toggleUseUuid(CommandContext<FabricClientCommandSource> commandContext) {
        boolean enabled = BoolArgumentType.getBool(commandContext, (String)"enabled");
        LANLock.setUseUuid(enabled);
        if (enabled) {
            ((FabricClientCommandSource)commandContext.getSource()).sendFeedback((class_2561)class_2561.method_43471((String)"lanlock.command.uuid.enable"));
        } else {
            ((FabricClientCommandSource)commandContext.getSource()).sendFeedback((class_2561)class_2561.method_43471((String)"lanlock.command.uuid.disable"));
        }
        return 1;
    }

    private static int useUuid(CommandContext<FabricClientCommandSource> commandContext) {
        if (LANLock.getUseUuid()) {
            ((FabricClientCommandSource)commandContext.getSource()).sendFeedback((class_2561)class_2561.method_43469((String)"lanlock.command.enabled", (Object[])new Object[]{"useUuid"}));
        } else {
            ((FabricClientCommandSource)commandContext.getSource()).sendFeedback((class_2561)class_2561.method_43469((String)"lanlock.command.disabled", (Object[])new Object[]{"useUuid"}));
        }
        return 1;
    }

    private static int toggleNotify(CommandContext<FabricClientCommandSource> commandContext) {
        boolean enabled = BoolArgumentType.getBool(commandContext, (String)"enabled");
        LANLock.setSendNotification(enabled);
        if (enabled) {
            ((FabricClientCommandSource)commandContext.getSource()).sendFeedback((class_2561)class_2561.method_43471((String)"lanlock.command.notify.enable"));
        } else {
            ((FabricClientCommandSource)commandContext.getSource()).sendFeedback((class_2561)class_2561.method_43471((String)"lanlock.command.notify.disable"));
        }
        return 1;
    }

    private static int notify(CommandContext<FabricClientCommandSource> commandContext) {
        if (LANLock.getSendNotification()) {
            ((FabricClientCommandSource)commandContext.getSource()).sendFeedback((class_2561)class_2561.method_43469((String)"lanlock.command.enabled", (Object[])new Object[]{"notify"}));
        } else {
            ((FabricClientCommandSource)commandContext.getSource()).sendFeedback((class_2561)class_2561.method_43469((String)"lanlock.command.disabled", (Object[])new Object[]{"notify"}));
        }
        return 1;
    }
}

