/*
 * Decompiled with CFR 0.152.
 */
package com.lgmrszd.compressedcreativity.compat.jei;

import com.lgmrszd.compressedcreativity.content.Mesh;
import com.lgmrszd.compressedcreativity.index.CCBlocks;
import com.lgmrszd.compressedcreativity.index.CCItems;
import com.lgmrszd.compressedcreativity.index.CCLang;
import com.lgmrszd.compressedcreativity.index.CCMisc;
import com.lgmrszd.compressedcreativity.items.MeshItem;
import com.simibubi.create.Create;
import com.simibubi.create.content.kinetics.fan.processing.HauntingRecipe;
import com.simibubi.create.content.kinetics.fan.processing.SplashingRecipe;
import com.tterrag.registrate.util.entry.ItemEntry;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.JeiPlugin;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.registration.IRecipeCatalystRegistration;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.BlastingRecipe;
import net.minecraft.world.item.crafting.SmokingRecipe;

@JeiPlugin
public class CompressedCreativityJEI
implements IModPlugin {
    public static final ResourceLocation ID = CCMisc.CCRL("");

    public ResourceLocation getPluginUid() {
        return ID;
    }

    public void registerRecipeCatalysts(IRecipeCatalystRegistration registration) {
        RecipeType washing = new RecipeType(Create.asResource((String)"fan_washing"), SplashingRecipe.class);
        RecipeType smoking = new RecipeType(Create.asResource((String)"fan_smoking"), SmokingRecipe.class);
        RecipeType blasting = new RecipeType(Create.asResource((String)"fan_blasting"), BlastingRecipe.class);
        RecipeType haunting = new RecipeType(Create.asResource((String)"fan_haunting"), HauntingRecipe.class);
        this.registerAirBlowers(registration, "washing", washing);
        this.registerAirBlowers(registration, "smoking", smoking);
        this.registerAirBlowers(registration, "blasting", blasting);
        this.registerAirBlowers(registration, "haunting", haunting);
        this.registerMeshRecipeCatalyst(registration, Mesh.MeshType.SPLASHING, washing);
        this.registerMeshRecipeCatalyst(registration, Mesh.MeshType.DENSE, smoking, blasting);
        this.registerMeshRecipeCatalyst(registration, Mesh.MeshType.HAUNTED, haunting);
    }

    private void registerAirBlowers(IRecipeCatalystRegistration registration, String name, RecipeType<?> recipeType) {
        registration.addRecipeCatalyst(this.getAirBlower(name, false), new RecipeType[]{recipeType});
        registration.addRecipeCatalyst(this.getAirBlower(name, true), new RecipeType[]{recipeType});
    }

    private ItemStack getAirBlower(String name, Boolean isIndustrial) {
        return (isIndustrial != false ? CCBlocks.INDUSTRIAL_AIR_BLOWER : CCBlocks.AIR_BLOWER).asStack().m_41714_((Component)CCLang.translate("recipe." + name + (isIndustrial != false ? ".industrial_air_blower" : ".air_blower"), new Object[0]).component().m_130938_(style -> style.m_131155_(Boolean.valueOf(false))));
    }

    public void registerMeshRecipeCatalyst(IRecipeCatalystRegistration registration, Mesh.MeshType meshType, RecipeType<?> ... recipeTypes) {
        ItemEntry<MeshItem> meshItem = CCItems.MESHES.get(meshType.getName());
        if (meshItem == null) {
            return;
        }
        registration.addRecipeCatalyst(meshItem.asStack(), recipeTypes);
    }
}

