/*
 * Decompiled with CFR 0.152.
 */
package com.lgmrszd.compressedcreativity.content.airhandler_backtank;

import com.simibubi.create.content.equipment.armor.BacktankUtil;
import me.desht.pneumaticcraft.api.PNCCapabilities;
import me.desht.pneumaticcraft.api.tileentity.IAirHandlerItem;
import net.minecraft.core.Direction;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AirHandlerBacktankItem
extends IAirHandlerItem.Provider {
    private final float MAX_PRESSURE = 3.0f;
    private final int RATIO = 2;
    private final int volume;
    private final LazyOptional<IAirHandlerItem> holder = LazyOptional.of(() -> this);
    private final ItemStack backtank;

    public AirHandlerBacktankItem(ItemStack backtank) {
        this.backtank = backtank;
        int maxVolume = 2 * BacktankUtil.maxAir((ItemStack)backtank);
        this.volume = (int)((float)maxVolume / 3.0f);
    }

    @NotNull
    public ItemStack getContainer() {
        return this.backtank;
    }

    public float getPressure() {
        return (float)this.getAir() / (float)this.volume;
    }

    public float maxPressure() {
        return 3.0f;
    }

    public int getAir() {
        float air = 2.0f * BacktankUtil.getAir((ItemStack)this.backtank);
        return Math.round(air);
    }

    public void addAir(int i) {
        BacktankUtil.consumeAir(null, (ItemStack)this.backtank, (float)(-1.0f * (float)i / 2.0f));
    }

    public int getBaseVolume() {
        return this.volume;
    }

    public int getVolume() {
        return this.volume;
    }

    public void setBaseVolume(int i) {
    }

    @NotNull
    public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap, @Nullable Direction side) {
        return PNCCapabilities.AIR_HANDLER_ITEM_CAPABILITY.orEmpty(cap, this.holder);
    }
}

