/*
 * Decompiled with CFR 0.152.
 */
package com.lgmrszd.compressedcreativity.upgrades;

import com.lgmrszd.compressedcreativity.config.ClientConfig;
import com.lgmrszd.compressedcreativity.config.MechanicalVisorConfig;
import com.lgmrszd.compressedcreativity.index.CCCommonUpgradeHandlers;
import com.lgmrszd.compressedcreativity.index.CCItems;
import com.lgmrszd.compressedcreativity.upgrades.MechanicalVisorHandler;
import com.lgmrszd.compressedcreativity.upgrades.MechanicalVisorOptions;
import com.mojang.blaze3d.vertex.PoseStack;
import com.simibubi.create.content.equipment.goggles.IHaveGoggleInformation;
import com.simibubi.create.content.equipment.goggles.IHaveHoveringInformation;
import java.util.ArrayList;
import java.util.Collections;
import me.desht.pneumaticcraft.api.PneumaticRegistry;
import me.desht.pneumaticcraft.api.client.IGuiAnimatedStat;
import me.desht.pneumaticcraft.api.client.pneumatic_helmet.IArmorUpgradeClientHandler;
import me.desht.pneumaticcraft.api.client.pneumatic_helmet.IGuiScreen;
import me.desht.pneumaticcraft.api.client.pneumatic_helmet.IOptionPage;
import me.desht.pneumaticcraft.api.pneumatic_armor.IArmorUpgradeHandler;
import me.desht.pneumaticcraft.api.pneumatic_armor.ICommonArmorHandler;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.block.entity.BlockEntity;

public class MechanicalVisorClientHandler
extends IArmorUpgradeClientHandler.SimpleToggleableHandler<MechanicalVisorHandler> {
    public MechanicalVisorConfig.TooltipMode tooltipMode;
    public MechanicalVisorConfig.BlockTrackerMode blockTrackerMode;
    private IGuiAnimatedStat visorInfo;
    private BlockEntity focusedBlockEntity;

    public MechanicalVisorClientHandler() {
        super((IArmorUpgradeHandler)CCCommonUpgradeHandlers.mechanicalVisorHandler);
        this.initConfig();
    }

    public IOptionPage getGuiOptionsPage(IGuiScreen screen) {
        return new MechanicalVisorOptions(screen, this);
    }

    public void initConfig() {
        this.tooltipMode = (MechanicalVisorConfig.TooltipMode)((Object)ClientConfig.MECHANICAL_VISOR_TOOLTIP_MODE.get());
        this.blockTrackerMode = (MechanicalVisorConfig.BlockTrackerMode)((Object)ClientConfig.MECHANICAL_VISOR_BLOCK_TRACKER_MODE.get());
    }

    public void saveToConfig() {
        ClientConfig.MECHANICAL_VISOR_TOOLTIP_MODE.set((Object)this.tooltipMode);
        ClientConfig.MECHANICAL_VISOR_BLOCK_TRACKER_MODE.set((Object)this.blockTrackerMode);
    }

    public void tickClient(ICommonArmorHandler armorHandler, boolean isEnabled) {
        super.tickClient(armorHandler, isEnabled);
        if (this.visorInfo == null || !isEnabled) {
            return;
        }
        if (!this.tooltipMode.isWidget()) {
            this.visorInfo.setText(Collections.emptyList());
            return;
        }
        Player player = armorHandler.getPlayer();
        ArrayList textList = new ArrayList();
        BlockEntity blockEntity = this.focusedBlockEntity;
        if (blockEntity instanceof IHaveGoggleInformation) {
            IHaveGoggleInformation goggleBE = (IHaveGoggleInformation)blockEntity;
            goggleBE.addToGoggleTooltip(textList, player.m_6144_());
        }
        if ((blockEntity = this.focusedBlockEntity) instanceof IHaveHoveringInformation) {
            IHaveHoveringInformation hoveringBE = (IHaveHoveringInformation)blockEntity;
            hoveringBE.addToTooltip(textList, player.m_6144_());
        }
        this.visorInfo.setText(textList);
        this.checkBlockFocus();
    }

    private void checkBlockFocus() {
        this.focusedBlockEntity = null;
        PneumaticRegistry.getInstance().getClientArmorRegistry().getBlockTrackerFocus().ifPresent(focus -> {
            BlockPos focusedBlockPos = focus.pos();
            if (focusedBlockPos == null) {
                return;
            }
            if (Minecraft.m_91087_().f_91073_ == null) {
                return;
            }
            BlockEntity currentBlockEntity = Minecraft.m_91087_().f_91073_.m_7702_(focusedBlockPos);
            if (currentBlockEntity instanceof IHaveHoveringInformation || currentBlockEntity instanceof IHaveGoggleInformation) {
                this.focusedBlockEntity = currentBlockEntity;
            }
        });
    }

    public void render3D(PoseStack matrixStack, MultiBufferSource buffer, float partialTicks) {
        super.render3D(matrixStack, buffer, partialTicks);
    }

    public void render2D(GuiGraphics graphics, float partialTicks, boolean armorPieceHasPressure) {
        super.render2D(graphics, partialTicks, armorPieceHasPressure);
    }

    public IGuiAnimatedStat getAnimatedStat() {
        if (this.visorInfo == null) {
            this.visorInfo = PneumaticRegistry.getInstance().getClientArmorRegistry().makeHUDStatPanel((Component)Component.m_237115_((String)"compressedcreativity.mechanical_visor.armor.gui.title"), CCItems.MECHANICAL_VISOR_UPGRADE.asStack(), (IArmorUpgradeClientHandler)this);
        }
        return this.visorInfo;
    }

    public void onResolutionChanged() {
        this.visorInfo = null;
    }
}

