/*
 * Decompiled with CFR 0.152.
 */
package zysws.setspawn;

import org.bukkit.Location;
import org.bukkit.command.CommandExecutor;
import org.bukkit.plugin.java.JavaPlugin;
import zysws.setspawn.Commands.LocationHandler;
import zysws.setspawn.Commands.SetSpawnLocation;
import zysws.setspawn.Commands.Spawn;

public final class SetSpawn
extends JavaPlugin {
    public void onEnable() {
        this.getCommand("SetSpawn").setExecutor((CommandExecutor)new SetSpawnLocation());
        this.getCommand("spawn").setExecutor((CommandExecutor)new Spawn());
        this.saveDefaultConfig();
        this.loadSpawnLocationFromConfig();
        Location spawnLocation = LocationHandler.getSpawnLocation();
        if (spawnLocation != null) {
            this.getLogger().info("Loaded spawn location: " + spawnLocation.toString());
        } else {
            this.getLogger().info("No spawn location set.");
        }
    }

    public void onDisable() {
        this.saveSpawnLocationToConfig();
    }

    public void loadSpawnLocationFromConfig() {
        String locationString = this.getConfig().getString("spawnLocation");
        if (locationString != null) {
            Location spawnLocation = LocationHandler.stringToLocation(locationString);
            LocationHandler.setSpawnLocation(spawnLocation);
        }
    }

    public void saveSpawnLocationToConfig() {
        Location spawnLocation = LocationHandler.getSpawnLocation();
        if (spawnLocation != null) {
            String locationString = LocationHandler.locationToString(spawnLocation);
            this.getConfig().set("spawnLocation", (Object)locationString);
            this.saveConfig();
        }
    }
}

